/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.settings;

import bilib.commons.gui.SpinnerDouble;
import bilib.commons.gui.SpinnerFloat;
import bilib.commons.gui.SpinnerInteger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Settings {
    private String filename;
    private String project;
    private ArrayList<Item> items;
    private Properties props;

    public Settings(String project, String filename) {
        this.filename = filename;
        this.project = project;
        this.items = new ArrayList();
        this.props = new Properties();
    }

    public String getProject() {
        return this.project;
    }

    public String getFilename() {
        return this.filename;
    }

    public void record(String key, JTextField component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JComboBox component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JSpinner component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public void record(String key, JToggleButton component, boolean defaultValue) {
        Item item = new Item(key, component, defaultValue ? "on" : "off");
        this.items.add(item);
    }

    public void record(String key, JCheckBox component, boolean defaultValue) {
        Item item = new Item(key, component, defaultValue ? "on" : "off");
        this.items.add(item);
    }

    public void record(String key, JSlider component, String defaultValue) {
        Item item = new Item(key, component, defaultValue);
        this.items.add(item);
    }

    public String loadValue(String key, String defaultValue) {
        String s = "";
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            s = this.props.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            s = defaultValue;
        }
        return s;
    }

    public double loadValue(String key, double defaultValue) {
        double d = 0.0;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            d = new Double(value);
        }
        catch (Exception e) {
            d = defaultValue;
        }
        return d;
    }

    public int loadValue(String key, int defaultValue) {
        int i = 0;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            i = new Integer(value);
        }
        catch (Exception e) {
            i = defaultValue;
        }
        return i;
    }

    public boolean loadValue(String key, boolean defaultValue) {
        boolean b = false;
        try {
            FileInputStream in = new FileInputStream(this.filename);
            this.props.load(in);
            String value = this.props.getProperty(key, "" + defaultValue);
            b = new Boolean(value);
        }
        catch (Exception e) {
            b = defaultValue;
        }
        return b;
    }

    public void storeValue(String key, String value) {
        this.props.setProperty(key, value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.project) + ": Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, double value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.project) + ": Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, int value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.project) + ": Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void storeValue(String key, boolean value) {
        this.props.setProperty(key, "" + value);
        try {
            FileOutputStream out = new FileOutputStream(this.filename);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.project) + ": Impossible to store settings in (" + this.filename + ")");
        }
    }

    public void loadRecordedItems() {
        this.loadRecordedItems(this.filename);
    }

    public void loadRecordedItems(String fname) {
        try {
            FileInputStream in = new FileInputStream(fname);
            this.props.load(in);
        }
        catch (Exception e) {
            this.props = new Properties();
        }
        int i = 0;
        while (i < this.items.size()) {
            Item item = this.items.get(i);
            String value = this.props.getProperty(item.key, item.defaultValue);
            if (item.component instanceof JTextField) {
                ((JTextField)item.component).setText(value);
            } else if (item.component instanceof JComboBox) {
                ((JComboBox)item.component).setSelectedItem(value);
            } else if (item.component instanceof JCheckBox) {
                ((JCheckBox)item.component).setSelected(value.equals("on"));
            } else if (item.component instanceof JToggleButton) {
                ((JToggleButton)item.component).setSelected(value.equals("on"));
            } else if (item.component instanceof SpinnerInteger) {
                ((SpinnerInteger)item.component).set(Math.round(new Double(value).intValue()));
            } else if (item.component instanceof SpinnerDouble) {
                ((SpinnerDouble)item.component).set(new Double(value));
            } else if (item.component instanceof SpinnerFloat) {
                ((SpinnerFloat)item.component).set(new Float(value).floatValue());
            } else if (item.component instanceof JSlider) {
                ((JSlider)item.component).setValue(new Integer(value));
            }
            ++i;
        }
    }

    public void storeRecordedItems() {
        this.storeRecordedItems(this.filename);
    }

    public void storeRecordedItems(String fname) {
        int i = 0;
        while (i < this.items.size()) {
            String value;
            Item item = this.items.get(i);
            if (item.component instanceof JTextField) {
                value = ((JTextField)item.component).getText();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JComboBox) {
                value = (String)((JComboBox)item.component).getSelectedItem();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JCheckBox) {
                value = ((JCheckBox)item.component).isSelected() ? "on" : "off";
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JToggleButton) {
                value = ((JToggleButton)item.component).isSelected() ? "on" : "off";
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JSpinner) {
                value = "" + ((JSpinner)item.component).getValue();
                this.props.setProperty(item.key, value);
            } else if (item.component instanceof JSlider) {
                value = "" + ((JSlider)item.component).getValue();
                this.props.setProperty(item.key, value);
            }
            ++i;
        }
        try {
            FileOutputStream out = new FileOutputStream(fname);
            this.props.store(out, this.project);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.project) + ": Impossible to store settings in (" + fname + ")");
        }
    }

    private class Item {
        public Object component;
        public String defaultValue;
        public String key;

        public Item(String key, Object component, String defaultValue) {
            this.component = component;
            this.defaultValue = defaultValue;
            this.key = key;
        }
    }
}

