/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job;

import bilib.commons.job.MonitorAbstract;
import java.text.DecimalFormat;
import javax.swing.JProgressBar;

public class MonitorTimedProgressBar
extends JProgressBar
implements MonitorAbstract {
    private double chrono = System.nanoTime();
    private double percentage = 0.0;

    public MonitorTimedProgressBar() {
        this.setStringPainted(true);
        this.setMaximum(100);
        this.setPercentage(0.0);
    }

    @Override
    public void rewind() {
        this.setPercentage(0.0);
        this.chrono = System.nanoTime();
        this.setText("");
    }

    @Override
    public void print(String message) {
        this.setText(message);
    }

    @Override
    public void progress(double percentage) {
        this.setPercentage(percentage);
    }

    @Override
    public void progress(double percentage, String message) {
        this.setPercentage(percentage);
        this.setText(message);
    }

    @Override
    public void increment(double percentageIncrement) {
        this.setPercentage(percentageIncrement + this.percentage);
    }

    @Override
    public void increment(double percentageIncrement, String message) {
        this.setPercentage(percentageIncrement + this.percentage);
        this.setText(message);
    }

    @Override
    public void error(String message) {
        this.setText("Error:" + message);
    }

    @Override
    public void warning(String message) {
        this.setText("Warning:" + message);
    }

    private void setText(String message) {
        this.setString(String.valueOf(this.toc()) + " - " + message);
    }

    private String toc() {
        double te = (double)System.nanoTime() - this.chrono;
        String s = " ";
        DecimalFormat df = new DecimalFormat("####.##");
        if (te < 1000.0) {
            return String.valueOf(s) + df.format(te) + " ns";
        }
        if ((te /= 1000.0) < 1000.0) {
            return String.valueOf(s) + df.format(te) + " us";
        }
        if ((te /= 1000.0) < 3000.0) {
            return String.valueOf(s) + df.format(te) + " ms";
        }
        if ((te /= 1000.0) < 600.1) {
            return String.valueOf(s) + df.format(te) + " s";
        }
        if ((te /= 60.0) < 600.1) {
            return String.valueOf(s) + df.format(te) + " min.";
        }
        return String.valueOf(s) + df.format(te /= 60.0) + " h.";
    }

    private void setPercentage(double percentage) {
        this.percentage = percentage;
        this.setValue((int)Math.max(0.0, Math.min(100.0, percentage)));
    }
}

