/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartTable;
import bilib.commons.smarttable.SmartTableColumn;
import bilib.commons.smarttable.SmartTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class SmartTableListener
extends MouseAdapter {
    private JTableHeader header;
    private SmartTableColumn[] columns;

    public SmartTableListener(JTableHeader header, SmartTableColumn[] columns) {
        this.header = header;
        this.columns = columns;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int col = this.header.columnAtPoint(e.getPoint());
        if (!this.columns[col].isSortable()) {
            return;
        }
        int sortCol = this.header.getTable().convertColumnIndexToModel(col);
        this.header.repaint();
        if (this.header.getTable().isEditing()) {
            this.header.getTable().getCellEditor().stopCellEditing();
        }
        int c = 0;
        while (c < this.columns.length) {
            if (c == col) {
                this.columns[c].nextSorter();
            } else {
                this.columns[c].setSorter(SmartTable.Sorter.NONE);
            }
            ++c;
        }
        ((SmartTableModel)this.header.getTable().getModel()).sortByColumn(sortCol, this.columns[col].isAscent());
        c = 0;
        while (c < this.columns.length) {
            TableColumn tc = this.header.getTable().getColumnModel().getColumn(c);
            tc.setHeaderValue(this.columns[c].getSortedHeader());
            ++c;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.header.repaint();
    }
}

