/*
 * Decompiled with CFR 0.152.
 */
package psf.defocusplane;

public class ZFunction {
    public static final int ZFUNC_LINEAR = 0;
    public static final int ZFUNC_EXPO = 1;
    public static final int ZFUNC_PARABOLIC = 2;
    public static final int ZFUNC_CONSTANT = 3;
    public static String[] names = new String[]{"Linear", "Exponential", "Parabolic", "Constant"};
    private int func1D = 1;
    private double zdefocus = 1.0;
    private double zfocal = 1.0;

    public ZFunction(int func1D, double zdefocus, double zfocal) {
        this.func1D = func1D;
        this.zdefocus = zdefocus;
        this.zfocal = zfocal;
    }

    public double getDefocusFactor(double z) {
        double zf = z - this.zfocal;
        double za = zf < 0.0 ? -zf : zf;
        switch (this.func1D) {
            case 1: {
                double K = 0.69314718056;
                return Math.exp(-za * K / (this.zdefocus - this.zfocal));
            }
            case 2: {
                return 1.0 + za * za / ((this.zdefocus - this.zfocal) * (this.zdefocus - this.zfocal));
            }
            case 3: {
                return 1.0;
            }
            case 0: {
                return 1.0 + za / Math.abs(this.zdefocus - this.zfocal);
            }
        }
        return 1.0;
    }

    public String getName() {
        return names[this.func1D];
    }

    public String toString() {
        return String.valueOf(names[this.func1D]) + " " + this.zfocal + " " + this.zdefocus;
    }
}

