/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.random;

import bilib.commons.gui.GridPanel;
import bilib.commons.gui.SpinnerDouble;
import bilib.commons.random.Noise;
import bilib.commons.settings.Settings;
import javax.swing.JPanel;

public class NoiseUniform
extends Noise {
    private double lower = 0.0;
    private double upper = 1.0;
    private SpinnerDouble spnLower = new SpinnerDouble(0.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0, "0.000");
    private SpinnerDouble spnUpper = new SpinnerDouble(1.0, -1.7976931348623157E308, Double.MAX_VALUE, 1.0, "0.000");

    public NoiseUniform(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public String getName() {
        return "Uniform";
    }

    @Override
    public void fetchParameters() {
        this.lower = this.spnLower.get();
        this.upper = this.spnUpper.get();
    }

    @Override
    public double nextValue() {
        return (this.upper - this.lower) * this.random.nextDouble() + this.upper;
    }

    @Override
    public JPanel buildPanel(Settings settings) {
        GridPanel panel = new GridPanel(false);
        panel.place(1, 0, "Lower value");
        panel.place(1, 1, this.spnLower);
        panel.place(2, 0, "Upper value");
        panel.place(2, 1, this.spnUpper);
        settings.record("random-" + this.getName() + "-lower", this.spnLower, "0");
        settings.record("random-" + this.getName() + "-upper", this.spnUpper, "1");
        settings.loadRecordedItems();
        return panel;
    }
}

