/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartTableModel;

public class SmartTableSorter {
    private SmartTableModel model;

    public SmartTableSorter(SmartTableModel model) {
        this.model = model;
    }

    public void sort(int column, boolean isAscent) {
        int n = this.model.getRowCount();
        int[] indexes = this.model.getIndexes();
        int i = this.model.top;
        while (i < n - 1) {
            int k = i;
            int j = i + 1;
            while (j < n) {
                if (isAscent) {
                    if (this.compare(column, j, k) < 0) {
                        k = j;
                    }
                } else if (this.compare(column, j, k) > 0) {
                    k = j;
                }
                ++j;
            }
            int tmp = indexes[i];
            indexes[i] = indexes[k];
            indexes[k] = tmp;
            ++i;
        }
    }

    public int compare(int column, int row1, int row2) {
        Object o1 = this.model.getValueAt(row1, column);
        Object o2 = this.model.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == Double.class && o2.getClass() == Double.class) {
            return ((Double)o1).compareTo((Double)o2);
        }
        if (o1.getClass() == Boolean.class && o2.getClass() == Boolean.class) {
            return ((Boolean)o1).compareTo((Boolean)o2);
        }
        if (o1.getClass() == String.class && o2.getClass() == String.class) {
            return ((String)o1).compareTo((String)o2);
        }
        return 0;
    }
}

