/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.permuteaxis;

import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import icy.main.Icy;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarSequence;
import plugins.sage.permuteaxis.Processing;

public class PermuteAxisBlock
implements Block,
PoolResponder {
    private VarSequence inSequenceVar = new VarSequence("Input Sequence", null);
    private VarSequence outSequenceVar = new VarSequence("Output Sequence", null);
    private VarEnum<Axis> axisT = new VarEnum("Axis T to", (Enum)Axis.AXIS_T);
    private VarEnum<Axis> axisZ = new VarEnum("Axis Z to", (Enum)Axis.AXIS_Z);
    private VarEnum<Axis> axisC = new VarEnum("Axis C to", (Enum)Axis.AXIS_C);
    private VarEnum<Axis> axisY = new VarEnum("Axis Y to", (Enum)Axis.AXIS_Y);
    private VarEnum<Axis> axisX = new VarEnum("Axis X to", (Enum)Axis.AXIS_X);
    private boolean protocol = false;

    public void run() {
        Sequence in = this.protocol ? (Sequence)this.inSequenceVar.getValue() : Icy.getMainInterface().getActiveSequence();
        int[] swap = new int[]{((Axis)((Object)this.axisT.getValue())).ordinal(), ((Axis)((Object)this.axisZ.getValue())).ordinal(), ((Axis)((Object)this.axisC.getValue())).ordinal(), ((Axis)((Object)this.axisY.getValue())).ordinal(), ((Axis)((Object)this.axisX.getValue())).ordinal()};
        Processing processor = new Processing(in, swap);
        new Pool(processor, (PoolResponder)this).execute(ExecutionMode.MULTITHREAD_ASYNCHRONIZED);
    }

    public void declareInput(VarList inputMap) {
        this.protocol = true;
        inputMap.add((Var)this.inSequenceVar);
        inputMap.add(this.axisT);
        inputMap.add(this.axisZ);
        inputMap.add(this.axisC);
        inputMap.add(this.axisY);
        inputMap.add(this.axisX);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add((Var)this.outSequenceVar);
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        Processing processor = (Processing)event.getSource();
        Sequence out = processor.getOutputSequence();
        this.outSequenceVar.setValue(out);
    }

    private static enum Axis {
        AXIS_T,
        AXIS_Z,
        AXIS_C,
        AXIS_Y,
        AXIS_X;

    }
}

