/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.job;

import bilib.commons.job.JobAbstract;
import java.util.EventObject;

public class JobEvent
extends EventObject {
    public static byte VOID = 0;
    public static byte STARTED = 1;
    public static byte COMPLETED = (byte)2;
    public static byte ABORTED = (byte)3;
    public static byte TIMEOUT = (byte)4;
    public static byte EXCEPTION = (byte)5;
    public static byte INTERRUPTED = (byte)6;
    private byte typeEvent = VOID;
    private String message = "";
    private Exception exception;
    private JobAbstract job;

    public JobEvent(JobAbstract source, byte typeEvent, String message) {
        super(source);
        this.job = source;
        this.typeEvent = typeEvent;
        this.exception = null;
        this.message = message;
    }

    public JobEvent(JobAbstract source, Exception exception, String message) {
        super(source);
        this.job = source;
        this.typeEvent = EXCEPTION;
        this.exception = exception;
        this.message = message;
    }

    public JobEvent(JobAbstract source, byte typeEvent) {
        super(source);
        this.job = source;
        this.typeEvent = typeEvent;
        this.message = "";
    }

    public JobAbstract getJob() {
        return this.job;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public byte getTypeEvent() {
        return this.typeEvent;
    }

    public String getEventString() {
        if (this.typeEvent == VOID) {
            return "VOID";
        }
        if (this.typeEvent == STARTED) {
            return "STARTED";
        }
        if (this.typeEvent == COMPLETED) {
            return "COMPLETED";
        }
        if (this.typeEvent == ABORTED) {
            return "ABORTED";
        }
        if (this.typeEvent == TIMEOUT) {
            return "TIMEOUT";
        }
        if (this.typeEvent == EXCEPTION) {
            return "EXCEPTION";
        }
        if (this.typeEvent == INTERRUPTED) {
            return "INTERRUPTED";
        }
        return "UNDEFINED";
    }

    @Override
    public String toString() {
        return "JobEvent, type=(" + this.getEventString() + "), source=(" + this.source.toString() + "), message=(" + this.message + ") " + this.source.getClass().getName();
    }
}

