/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.math.bessel;

public class Bessel {
    private static double[] tJ0 = new double[]{1.0, -2.2499997, 1.2656208, -0.3163866, 0.0444479, -0.0039444, 2.1E-4};
    private static double[] pJ0 = new double[]{-0.78539816, -0.04166397, -3.954E-5, 0.00262573, -5.4125E-4, -2.9333E-4, 1.3558E-4};
    private static double[] fJ0 = new double[]{0.79788456, -7.7E-7, -0.0055274, -9.512E-5, 0.00137237, -7.2805E-4, 1.4476E-4};
    private static double[] tJ1 = new double[]{0.5, -0.56249985, 0.21093573, -0.03954289, 0.0443319, -3.1761E-4, 1.109E-4};
    private static double[] pJ1 = new double[]{-2.35619449, 0.12499612, 5.65E-5, -0.00637879, 7.4348E-4, 7.9824E-4, -2.9166E-4};
    private static double[] fJ1 = new double[]{0.79788456, 1.56E-6, 0.01689667, 1.7105E-4, -0.00249511, 0.00113653, -2.0033E-4};

    public static double J0(double x) {
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            return tJ0[0] + y * (tJ0[1] + y * (tJ0[2] + y * (tJ0[3] + y * (tJ0[4] + y * (tJ0[5] + y * tJ0[6])))));
        }
        double y = 3.0 / x;
        double theta0 = x + pJ0[0] + y * (pJ0[1] + y * (pJ0[2] + y * (pJ0[3] + y * (pJ0[4] + y * (pJ0[5] + y * pJ0[6])))));
        double f0 = fJ0[0] + y * (fJ0[1] + y * (fJ0[2] + y * (fJ0[3] + y * (fJ0[4] + y * (fJ0[5] + y * fJ0[6])))));
        return Math.sqrt(1.0 / x) * f0 * Math.cos(theta0);
    }

    public static double J1(double x) {
        int sign = 1;
        if (x < 0.0) {
            x *= -1.0;
            sign = -1;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            return (double)sign * x * (tJ1[0] + y * (tJ1[1] + y * (tJ1[2] + y * (tJ1[3] + y * (tJ1[4] + y * (tJ1[5] + y * tJ1[6]))))));
        }
        double y = 3.0 / x;
        double theta1 = x + pJ1[0] + y * (pJ1[1] + y * (pJ1[2] + y * (pJ1[3] + y * (pJ1[4] + y * (pJ1[5] + y * pJ1[6])))));
        double f1 = fJ1[0] + y * (fJ1[1] + y * (fJ1[2] + y * (fJ1[3] + y * (fJ1[4] + y * (fJ1[5] + y * fJ1[6])))));
        return (double)sign * Math.sqrt(1.0 / x) * f1 * Math.cos(theta1);
    }

    public static double J2(double x) {
        double value0 = Bessel.J0(x);
        double value1 = Bessel.J1(x);
        if (x == 0.0) {
            return 0.0;
        }
        return 2.0 * value1 / x + value0;
    }
}

