/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartFormat;
import bilib.commons.smarttable.SmartTableColumn;
import bilib.commons.smarttable.SmartTableSorter;
import javax.swing.table.DefaultTableModel;

public class SmartTableModel
extends DefaultTableModel {
    private int[] indexes;
    private SmartTableSorter sorter;
    private SmartTableColumn[] columns;
    public int top;

    public SmartTableModel(SmartTableColumn[] columns) {
        this.columns = columns;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.columns[col].editable;
    }

    public SmartFormat getNumericalFormat(int col) {
        return this.columns[col].numformat;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowIndex = row;
        if (this.indexes != null) {
            rowIndex = this.indexes[row];
        }
        return super.getValueAt(rowIndex, col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int rowIndex = row;
        if (this.indexes != null) {
            rowIndex = this.indexes[row];
        }
        super.setValueAt(value, rowIndex, col);
    }

    public void sortByColumn(int column, boolean isAscent) {
        if (this.sorter == null) {
            this.sorter = new SmartTableSorter(this);
        }
        this.sorter.sort(column, isAscent);
        this.fireTableDataChanged();
    }

    public int[] getIndexes() {
        int n = this.getRowCount();
        if (this.indexes != null && this.indexes.length == n) {
            return this.indexes;
        }
        this.indexes = new int[n];
        int i = 0;
        while (i < n) {
            this.indexes[i] = i;
            ++i;
        }
        return this.indexes;
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        super.insertRow(row, rowData);
        ++this.top;
    }
}

