/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.permuteaxis;

import bilib.commons.buttons.ButtonFactory;
import bilib.commons.gui.GridPanel;
import bilib.commons.gui.GridToolbar;
import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.MonitorTimedProgressBar;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import bilib.commons.settings.SettingsFileDialog;
import icy.file.FileUtil;
import icy.gui.component.PopupPanel;
import icy.gui.frame.IcyFrame;
import icy.gui.main.GlobalSequenceListener;
import icy.gui.main.MainInterface;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.sequence.Sequence;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.sage.permuteaxis.About;
import plugins.sage.permuteaxis.Processing;

public class PermuteAxisIcyPanel
extends JPanel
implements ActionListener,
ItemListener,
ComponentListener,
GlobalSequenceListener,
PoolResponder {
    private MainInterface icy = Icy.getMainInterface();
    private String path = String.valueOf(FileUtil.getApplicationDirectory()) + File.separator + "plugins" + File.separator + "sage" + File.separator + "permuteaxis" + File.separator;
    private Settings settings = new Settings("Permuate Axis", String.valueOf(this.path) + "config.txt");
    private String[] list = new String[]{"Axis T", "Axis Z", "Axis C", "Axis Y", "Axis X"};
    private String[] unit = new String[]{"frames", "planes", "channels", "pixels", "pixels"};
    private JLabel[] lblDim = new JLabel[5];
    private JComboBox[] cmbAxis = new JComboBox[5];
    private JCheckBox[] chkFlip = new JCheckBox[5];
    private JButton bnRun = ButtonFactory.run(true);
    private JButton bnStop = ButtonFactory.stop(true);
    private JButton bnHelp = ButtonFactory.help(true);
    private JButton bnClose = ButtonFactory.close(false);
    private JButton bnPrefs = ButtonFactory.prefs(true);
    private JButton bnAbout = ButtonFactory.about(false);
    private JButton bnXT = new JButton("Permute T and X");
    private JButton bnYT = new JButton("Permute T and Y");
    private JButton bnZX = new JButton("Permute Z and X");
    private JButton bnZY = new JButton("Permute Z and Y");
    private JButton bnZT = new JButton("Swap Z and T");
    private JButton bnXY = new JButton("Swap X and Y");
    private JButton bnFlipX = new JButton("Flip Horizontal (X)");
    private JButton bnFlipY = new JButton("Flip Vertical   (Y)");
    private ArrayList<Sequence> sequences = new ArrayList();
    private JComboBox cmbSequences = new JComboBox();
    private Processing processor = null;
    private MonitorTimedProgressBar progress = new MonitorTimedProgressBar();
    private IcyFrame parent;
    private JPanel pnApplication;

    public PermuteAxisIcyPanel(IcyFrame parent) {
        this.parent = parent;
        this.progress.setString(About.copyright());
        GridPanel pn1 = new GridPanel("Bijective Permutation");
        int i = 0;
        while (i < 5) {
            this.cmbAxis[i] = new JComboBox<String>(this.list);
            this.chkFlip[i] = new JCheckBox("Reverse");
            this.lblDim[i] = new JLabel(this.unit[i]);
            pn1.place(2 + i, 0, "Axis " + this.last(this.list[i]) + " to");
            pn1.place(2 + i, 1, this.lblDim[i]);
            pn1.place(2 + i, 2, this.cmbAxis[i]);
            pn1.place(2 + i, 3, this.chkFlip[i]);
            this.cmbAxis[i].setSelectedIndex(i);
            this.cmbAxis[i].addItemListener(this);
            this.settings.record("axis-" + this.last(this.list[i]), this.cmbAxis[i], i == 3 ? this.list[4] : (i == 4 ? this.list[3] : this.list[i]));
            this.settings.record("flip-" + this.last(this.list[i]), this.chkFlip[i], false);
            ++i;
        }
        JPanel pn2 = new JPanel(new GridLayout(4, 2));
        pn2.add(this.bnXT);
        pn2.add(this.bnYT);
        pn2.add(this.bnZX);
        pn2.add(this.bnZY);
        pn2.add(this.bnFlipX);
        pn2.add(this.bnFlipY);
        pn2.add(this.bnZT);
        pn2.add(this.bnXY);
        PopupPanel pp2 = new PopupPanel("Predefined Permutations");
        pp2.addComponentListener((ComponentListener)this);
        pp2.setExpanded(false);
        pp2.getMainPanel().add(pn2);
        JPanel pnButtons = new JPanel(new GridLayout(1, 4));
        pnButtons.add(this.bnRun);
        pnButtons.add(this.bnStop);
        pnButtons.add(this.bnPrefs);
        pnButtons.add(this.bnHelp);
        GridPanel pnMain = new GridPanel(false, 5);
        pnMain.place(1, 1, this.cmbSequences);
        pnMain.place(2, 1, pn1);
        pnMain.place(3, 1, (JComponent)pp2);
        pnMain.place(4, 1, pnButtons);
        this.add(pnMain);
        GridToolbar pnBase = new GridToolbar(false, 0);
        pnBase.setLayout(new BoxLayout(pnBase, 0));
        pnBase.place(0, 0, this.bnAbout);
        pnBase.place(0, 1, this.progress);
        pnBase.place(0, 2, this.bnClose);
        this.pnApplication = new JPanel(new CardLayout());
        this.pnApplication.add((Component)pnMain, "Back");
        this.pnApplication.add((Component)About.getPanel(pnMain.getWidth(), pnMain.getHeight()), "About");
        pnBase.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.progress.getBackground()));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.pnApplication);
        this.add(pnBase);
        this.cmbSequences.addItemListener(this);
        this.bnRun.addActionListener(this);
        this.bnClose.addActionListener(this);
        this.bnStop.addActionListener(this);
        this.bnHelp.addActionListener(this);
        this.bnPrefs.addActionListener(this);
        this.bnAbout.addActionListener(this);
        this.bnYT.addActionListener(this);
        this.bnZY.addActionListener(this);
        this.bnXT.addActionListener(this);
        this.bnZX.addActionListener(this);
        this.bnZT.addActionListener(this);
        this.bnXY.addActionListener(this);
        this.bnFlipX.addActionListener(this);
        this.bnFlipY.addActionListener(this);
        this.icy.addGlobalSequenceListener((GlobalSequenceListener)this);
        this.settings.loadRecordedItems();
        this.setEnabledRunStop(true);
        this.updateSequence();
    }

    public void sequenceClosed(Sequence sequence) {
        this.updateSequence();
    }

    public void sequenceOpened(Sequence sequence) {
        this.updateSequence();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int i = 0;
        while (i < 5) {
            this.cmbAxis[i].removeItemListener(this);
            ++i;
        }
        if (e.getSource() == this.cmbSequences) {
            this.updateSequenceInfo();
        }
        i = 0;
        while (i < 5) {
            if (e.getSource() == this.cmbAxis[i]) {
                this.avoidDoublon(i);
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.cmbAxis[i].addItemListener(this);
            ++i;
        }
    }

    private void avoidDoublon(int fix) {
        int[] swap = new int[5];
        int i = 0;
        while (i < 5) {
            swap[i] = this.cmbAxis[i].getSelectedIndex();
            ++i;
        }
        int choice = this.cmbAxis[fix].getSelectedIndex();
        int[] count = new int[5];
        int doublon = -1;
        int j = 0;
        while (j < 5) {
            int n = swap[j];
            count[n] = count[n] + 1;
            if (j != fix && swap[j] == choice) {
                doublon = j;
            }
            ++j;
        }
        int none = -1;
        int i2 = 0;
        while (i2 < 5) {
            if (count[i2] == 0) {
                none = i2;
            }
            ++i2;
        }
        if (doublon != -1 && none != -1) {
            this.cmbAxis[doublon].setSelectedIndex(none);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnClose) {
            if (this.processor != null) {
                this.processor.abort();
            }
            this.settings.storeRecordedItems();
            this.parent.onClosed();
        }
        if (e.getSource() == this.bnHelp) {
            NetworkUtil.openBrowser((String)"http://icy.bioimageanalysis.org/");
        } else if (e.getSource() == this.bnXT) {
            int[] nArray = new int[5];
            nArray[0] = 4;
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnZX) {
            int[] nArray = new int[5];
            nArray[1] = 4;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 1;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnYT) {
            int[] nArray = new int[5];
            nArray[0] = 3;
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[4] = 4;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnZY) {
            int[] nArray = new int[5];
            nArray[1] = 3;
            nArray[2] = 2;
            nArray[3] = 1;
            nArray[4] = 4;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnZT) {
            int[] nArray = new int[5];
            nArray[0] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnXY) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 4;
            nArray[4] = 3;
            this.setPermutation(nArray, new boolean[5]);
        } else if (e.getSource() == this.bnFlipX) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            boolean[] blArray = new boolean[5];
            blArray[4] = true;
            this.setPermutation(nArray, blArray);
        } else if (e.getSource() == this.bnFlipY) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            boolean[] blArray = new boolean[5];
            blArray[3] = true;
            this.setPermutation(nArray, blArray);
        } else if (e.getSource() == this.bnPrefs) {
            new SettingsFileDialog(this.settings);
        } else if (e.getSource() == this.bnStop) {
            if (this.processor != null) {
                this.processor.abort();
            }
            this.setEnabledRunStop(true);
        } else if (e.getSource() == this.bnRun) {
            Sequence seq = this.getSourceSequence();
            if (seq != null) {
                this.processor = new Processing(seq, this.getPermutation(), this.getFlip());
                this.processor.addMonitor(this.progress);
                new Pool(this.processor, (PoolResponder)this).execute(ExecutionMode.MULTITHREAD_ASYNCHRONIZED);
                this.setEnabledRunStop(false);
            }
        } else if (e.getSource() == this.bnAbout) {
            CardLayout cl = (CardLayout)this.pnApplication.getLayout();
            cl.show(this.pnApplication, this.bnAbout.getText());
            if (this.bnAbout.getText().equals("About")) {
                this.bnAbout.setText("Back");
                this.bnAbout.setToolTipText("Back to " + About.title());
            } else {
                this.bnAbout.setText("About");
                this.bnAbout.setToolTipText("Back to the application");
            }
        }
    }

    private boolean[] getFlip() {
        boolean[] vector = new boolean[5];
        int i = 0;
        while (i < 5) {
            vector[i] = this.chkFlip[i].isSelected();
            ++i;
        }
        return vector;
    }

    private int[] getPermutation() {
        int[] vector = new int[5];
        int i = 0;
        while (i < 5) {
            vector[i] = this.cmbAxis[i].getSelectedIndex();
            ++i;
        }
        return vector;
    }

    private void setPermutation(int[] vector, boolean[] flip) {
        int i = 0;
        while (i < 5) {
            this.cmbAxis[i].setSelectedIndex(vector[i]);
            this.chkFlip[i].setSelected(flip[i]);
            ++i;
        }
    }

    private String last(String text) {
        return text.substring(text.length() - 1, text.length());
    }

    private void updateSequence() {
        this.cmbSequences.removeItemListener(this);
        this.sequences = Icy.getMainInterface().getSequences();
        this.cmbSequences.removeAllItems();
        this.cmbSequences.addItem(this.setNumberOfChar("Active Sequence", 30));
        for (Sequence sequence : this.sequences) {
            this.cmbSequences.addItem(this.setNumberOfChar(sequence.getName(), 30));
        }
        this.cmbSequences.addItemListener(this);
        this.updateSequenceInfo();
    }

    private void updateSequenceInfo() {
        int i = 0;
        while (i < 5) {
            this.lblDim[i].setText("(" + this.unit[i] + ")");
            ++i;
        }
        if (this.cmbSequences.getSelectedIndex() < 1) {
            return;
        }
        Sequence seq = this.getSourceSequence();
        if (seq == null) {
            return;
        }
        int[] dim = new int[]{seq.getSizeT(), seq.getSizeZ(), seq.getSizeC(), seq.getSizeY(), seq.getSizeX()};
        int i2 = 0;
        while (i2 < 5) {
            this.lblDim[i2].setText("(" + dim[i2] + " " + this.unit[i2] + ")");
            ++i2;
        }
    }

    private Sequence getSourceSequence() {
        int i = this.cmbSequences.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        Sequence seq = this.icy.getActiveSequence();
        if (i != 0) {
            seq = this.sequences.get(i - 1);
        }
        return seq;
    }

    private String setNumberOfChar(String text, int len) {
        String out = "";
        int diff = text.length() - len;
        if (diff <= 0) {
            char[] chars = text.toCharArray();
            int i = 0;
            while (i < chars.length) {
                out = String.valueOf(out) + chars[i];
                ++i;
            }
            i = 0;
            while (i < -diff) {
                out = String.valueOf(out) + ' ';
                ++i;
            }
        } else {
            char[] chars = text.toCharArray();
            int i = 0;
            while (i < (len - 5) / 2) {
                out = String.valueOf(out) + chars[i];
                ++i;
            }
            out = String.valueOf(out) + " ... ";
            i = chars.length - (len - 5) / 2;
            while (i < chars.length) {
                out = String.valueOf(out) + chars[i];
                ++i;
            }
        }
        return out;
    }

    public void setEnabledRunStop(boolean b) {
        this.bnRun.setEnabled(b);
        this.bnStop.setEnabled(!b);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.parent.pack();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        this.setEnabledRunStop(true);
        Exception ex = event.getException();
        if (ex != null) {
            ex.printStackTrace();
            this.progress.error(ex.getMessage());
        }
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        Processing process = (Processing)event.getSource();
        Icy.getMainInterface().addSequence(process.getOutputSequence());
        this.setEnabledRunStop(true);
    }
}

