/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.permuteaxis;

import bilib.commons.job.ExecutionMode;
import bilib.commons.job.JobEvent;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.sage.permuteaxis.Processing;
import plugins.sage.permuteaxis.ProgressBar;

public abstract class PermuteOperator
extends PluginActionable
implements Block,
PoolResponder {
    private VarSequence inSequenceVar = new VarSequence("Input Sequence", null);
    private VarSequence outSequenceVar = new VarSequence("Output Sequence", null);
    private boolean protocol = false;
    private ProgressBar progress;

    public abstract int[] getSwapVector();

    public abstract boolean[] getFlipVector();

    public void run() {
        Sequence in = this.protocol ? (Sequence)this.inSequenceVar.getValue() : Icy.getMainInterface().getActiveSequence();
        Processing permute = new Processing(in, this.getSwapVector(), this.getFlipVector());
        this.progress = new ProgressBar("Permute XT", permute);
        permute.addMonitor(this.progress);
        new Pool(permute, (PoolResponder)this).execute(ExecutionMode.MULTITHREAD_ASYNCHRONIZED);
    }

    public void declareInput(VarList inputMap) {
        this.protocol = true;
        inputMap.add((Var)this.inSequenceVar);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add((Var)this.outSequenceVar);
    }

    @Override
    public void onSuccess(Pool pool, JobEvent event) {
        Processing process = (Processing)event.getSource();
        if (this.protocol) {
            this.outSequenceVar.setValue(process.getOutputSequence());
        } else {
            Icy.getMainInterface().addSequence(process.getOutputSequence());
        }
        if (this.progress != null) {
            this.progress.close();
        }
    }

    @Override
    public void onFailure(Pool pool, JobEvent event) {
        Exception ex = event.getException();
        if (ex != null) {
            ex.printStackTrace();
        }
        if (this.progress != null) {
            this.progress.close();
        }
    }

    @Override
    public void onEvent(Pool pool, JobEvent event) {
    }
}

