/*
 * Decompiled with CFR 0.152.
 */
package plugins.sage.permuteaxis;

import bilib.commons.job.runnable.Job;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.awt.image.BufferedImage;

public class Processing
extends Job {
    private String[] axis = new String[]{"T", "Z", "C", "Y", "X"};
    private int[] swapToOut;
    private boolean[] flip;
    private Sequence out = new Sequence();
    private Sequence in;

    public Processing(Sequence in, int[] swapToOut) {
        this.in = in;
        this.swapToOut = swapToOut;
        this.flip = new boolean[5];
    }

    public Processing(Sequence in, int[] swapToOut, boolean[] flip) {
        this.in = in;
        this.swapToOut = swapToOut;
        this.flip = flip;
    }

    public Sequence getInputSequence() {
        return this.in;
    }

    public Sequence getOutputSequence() {
        return this.out;
    }

    @Override
    public void process() {
        if (this.in == null) {
            this.out = new Sequence();
            this.error("Unvalid input sequence");
            return;
        }
        if (!this.isBijection(this.swapToOut)) {
            this.out = new Sequence();
            this.error("Not bijective permutation");
            return;
        }
        int[] swapToIn = this.inverse(this.swapToOut);
        int[] dim = new int[]{this.in.getSizeT(), this.in.getSizeZ(), this.in.getSizeC(), this.in.getSizeY(), this.in.getSizeX()};
        int mt = dim[this.swapToOut[0]];
        int mz = dim[this.swapToOut[1]];
        int mc = dim[this.swapToOut[2]];
        int my = dim[this.swapToOut[3]];
        int mx = dim[this.swapToOut[4]];
        double[] data = new double[mx * my];
        String swappedAxis = "";
        int i = 0;
        while (i < 5) {
            swappedAxis = String.valueOf(swappedAxis) + this.axis[this.swapToOut[i]];
            ++i;
        }
        this.out.setName(String.valueOf(this.in.getName()) + " (" + swappedAxis + ")");
        this.out.beginUpdate();
        int nb = mt * mz * mc;
        double percentage = 100.0 / (double)nb;
        int total = mt * mz * my * mx * mc;
        int count = 0;
        int x = 0;
        int y = 0;
        this.rewind();
        dim[0] = 0;
        while (dim[0] < mt) {
            dim[1] = 0;
            while (dim[1] < mz) {
                IcyBufferedImage image = new IcyBufferedImage(mx, my, mc, this.in.getDataType_());
                dim[2] = 0;
                while (dim[2] < mc) {
                    String msg = count++ + " / " + nb + " images";
                    this.progress(Math.round((double)count * percentage), msg);
                    x = 0;
                    while (x < mx) {
                        y = 0;
                        while (y < my) {
                            dim[3] = this.flip[3] ? my - 1 - y : y;
                            dim[4] = this.flip[4] ? mx - 1 - x : x;
                            data[x + mx * y] = this.in.getData(dim[swapToIn[0]], dim[swapToIn[1]], dim[swapToIn[2]], dim[swapToIn[3]], dim[swapToIn[4]]);
                            ++y;
                        }
                        if (!this.live) {
                            return;
                        }
                        ++x;
                    }
                    int a2 = this.flip[2] ? mc - 1 - dim[2] : dim[2];
                    Array1DUtil.doubleArrayToSafeArray((double[])data, (Object)image.getDataXY(a2), (boolean)image.isSignedDataType());
                    dim[2] = dim[2] + 1;
                }
                int a0 = this.flip[0] ? mt - 1 - dim[0] : dim[0];
                int a1 = this.flip[1] ? mz - 1 - dim[1] : dim[1];
                this.out.setImage(a0, a1, (BufferedImage)image);
                dim[1] = dim[1] + 1;
            }
            dim[0] = dim[0] + 1;
        }
        this.out.endUpdate();
        this.progress(100.0, total + " pixels");
    }

    public boolean isBijection(int[] vector) {
        int n = vector.length;
        int[] count = new int[n];
        int i = 0;
        while (i < n) {
            if (vector[i] >= 0 && vector[i] < n) {
                int n2 = vector[i];
                count[n2] = count[n2] + 1;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            if (count[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] inverse(int[] a) {
        int n = a.length;
        int[] b = new int[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (a[j] == i) {
                    b[i] = j;
                }
                ++j;
            }
            ++i;
        }
        return b;
    }
}

