package plugins.worm.bandpassfilter;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JScrollPane;
import javax.swing.JTextPane;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;
import plugins.oeway.featureExtraction.featureExtractionPlugin;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.GenericFrame;
import icy.plugin.abstract_.PluginActionable;
import icy.type.point.Point5D;

public class BandpassFilter extends featureExtractionPlugin  {

	private EzVarInteger			    HighLevel  		;
	private EzVarInteger				LowLevel   		;
	private EzVarInteger				SampleRate		;
	private EzButton 					DetailsButton	;
	private EzVarText					SampleRateSetting;
	
	private int							rate;
	private int							_w;
	private int							HighFreq;
	private int							LowFreq;
	String[] outputGroup = new String[] {"FFTResult","FilterResult"};
	@Override
	public void initialize(HashMap<String,Object> options,ArrayList<Object> optionUI) {
		
	
		LowLevel	= new EzVarInteger("Low Level (KHz)");    
		HighLevel	= new EzVarInteger("High Level (KHz)");	
		SampleRate	= new EzVarInteger("Sample Rate (KHz)");
		
		 DetailsButton= new EzButton("Help on using the Filter",new ActionListener()
		 {
			
			public void actionPerformed(ActionEvent e)
			{
				onDetailsClicked();
			}
		});
//		 VarListener<Integer> listener = new VarListener<Integer>()
//					{
//
//						@Override
//						public void valueChanged(Var<Integer> source, Integer oldValue,
//								Integer newValue) {
//							HighFreq = HighLevel.getValue();
//							LowFreq	 = LowLevel.getValue();
//							rate	 = SampleRate.getValue();
//						}
//
//						@Override
//						public void referenceChanged(Var<Integer> source,
//								Var<? extends Integer> oldReference,
//								Var<? extends Integer> newReference) {
//							// TODO Auto-generated method stub
//							
//						}
//				
//					};
//			
//						
//
//		HighLevel.getVariable().addListener(listener);
//		LowLevel.getVariable().addListener(listener);
//		SampleRate.getVariable().addListener(listener);
		 
		optionUI.add(LowLevel);
		optionUI.add(HighLevel);
		optionUI.add(SampleRateSetting);
		optionUI.add(SampleRate);
		optionUI.add(DetailsButton);

		//options.put(FEATURE_GROUPS, outputGroup);
	}
	@Override
	public double[] process(double[] input,double[] position) {
		DoubleFFT_1D fft =null;
		DoubleFFT_1D fftInverse =null;
		double fftResultArray[]=null;
		double FilterResultArray[]=null;
		if((fft==null) && (fftInverse == null)){
			_w = input.length;
			fft = new DoubleFFT_1D(_w);
			fftInverse =new DoubleFFT_1D(_w);
			fftResultArray = new double[_w*2];
			FilterResultArray = new double[_w*2];	
		}
		
		LowFreq	 = LowLevel.getValue();
		HighFreq = HighLevel.getValue();
		
		rate	 = SampleRate.getValue();
		fftResultArray = AddArrayBefore(input,fftResultArray);	
		fft.realForwardFull(fftResultArray);
		fftResultArray = FilterMethod(LowFreq,HighFreq,rate,fftResultArray);
		FilterResultArray = ArrayValueCopy(fftResultArray);
		fftInverse.complexInverse(FilterResultArray, true);
		double [] output = new double [_w];
		double [] outputfft = new double [_w];
		double [] outputInverse = new double [_w];
		outputfft[0]=0;
		outputfft[1]=0;
		
		outputInverse[0] = FilterResultArray[0];
		for(int i=1;i<_w;i++)
		{
			outputfft[i] = Math.sqrt(Math.pow(fftResultArray[2*i],2))+Math.pow(fftResultArray[2*i+1],2);
			outputInverse [i]= FilterResultArray[i*2];
		}
		output=ArrayValueCopy(outputInverse);
	
	
		return output;
	}
	private double[] AddArrayBefore(double[] front,double[] sum ){
		int FrontLength = front.length;	
		for(int i=0;i<FrontLength;i++)
		{
			sum[i]=front[i];
		}
		return sum;
	}
	private double[] AddArrayAfter(double[] after,double[] sum){
		int AfterLength = after.length;
		int SumLength = sum.length;
		for(int i=AfterLength;i<SumLength;i++)
		{
			sum[i] = after[i-AfterLength];
		}
		return sum;
	}
	private double[] ArrayValueCopy(double[] origin){
		
		int length = origin.length;
		double copy[]=new double[length];
		for(int i=0;i<length;i++){
			copy[i]=origin[i];
		}
		return copy;
	}
	private double[] FilterMethod(int low,int high,int rate,double[] origin){
		double[] FilteredArray = new double [2*_w];
		FilteredArray = origin ;
		int LowPoint1 = _w*LowFreq/rate;
		int HighPoint1 = _w*HighFreq/rate;
		int LowPoint2 = 2*_w-LowPoint1;
		int HighPoint2 = 2*_w-HighPoint1;
		
		for(int i =0;i<LowPoint1;i++)
		{
			FilteredArray[i] = 0;
			
		}
		for(int j = HighPoint1;j<HighPoint2;j++)
		{
			FilteredArray[j] = 0;
		}
		for(int k = LowPoint2;k<2*_w;k++)
		{
			FilteredArray[k] = 0;
		}
		
		return FilteredArray;
	}
	private void onDetailsClicked()
	{
		String title = "Filter introduction";
		JTextPane message = new JTextPane();
		message.setEditable(false);
		message.setContentType("text/html");
		message.setText(
				"<h1> BandpassFilter Documents</h1>"+
				"<p>"+"This documents used to introduce the BandpassFilter based on FFT"+"<p>"	
				+"<h2>Signal Processing</h2>"+"<p>"
				+"1. Get the 1D singal along X or Y or Z"+"<p>"
				+"2. Change the sigal from time domain to frequence domain"+"<p>"
				+"3. Remove the freq<Low Level and freq>High Level part by set to ZERO"+"<p>"
				+"4. Reconstruct the sigal"+"<p>"
				+"<h2>Attention"+"<p>"
				+"1. The Low Level must be no more than the High Level"+"<p>"
				+"2. The High Level must be no more than the Sample Rate"+"<p>"
				);
		Dimension dim = message.getPreferredSize();
		dim.setSize(600, dim.getHeight()+100);
		message.setPreferredSize(dim);
		JScrollPane scroll = new JScrollPane(message);
		dim = scroll.getPreferredSize();
		dim.setSize(600,500);
		scroll.setPreferredSize(dim);
		GenericFrame infoFrame = new GenericFrame(title, scroll);
		infoFrame.addToMainDesktopPane();
		infoFrame.setVisible(true);
		infoFrame.requestFocus();

	}
}
