package plugins.worm.mbnfeatureextraction;



import java.util.ArrayList;
import java.util.HashMap;
import java.awt.*;
import java.awt.event.*;

import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.oeway.featureExtraction.featureExtractionPlugin;
import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.PluginActionable;
import icy.type.point.Point5D;

public class MBNFeatureExtraction extends featureExtractionPlugin  {
	private EzVarInteger			StartPoint ;
	private EzVarInteger			EndPoint   ;
	private EzVarBoolean			EnableMax;
	private EzVarBoolean			EnableAverage;
	private EzVarBoolean			EnableRMS;
	private EzVarBoolean			EnableRing;
	private EzVarDouble				GateValue;
	
	int start;
	int end;
	int processNum;
	double Gate;

	@Override
	public void initialize(HashMap<String,Object> options,ArrayList<Object> optionUI){
		StartPoint = new EzVarInteger("Start Point ");
		EndPoint   = new EzVarInteger("End Point");
		EnableMax  = new EzVarBoolean("Max",false);
		EnableAverage = new EzVarBoolean("Average",false);
		EnableRMS	  = new EzVarBoolean("RMS",false);
		EnableRing	  = new EzVarBoolean("Ring",false);
		GateValue	  = new EzVarDouble("Gate Vaule");
		optionUI.add(StartPoint);
		optionUI.add(EndPoint);
		optionUI.add(EnableMax);
		optionUI.add(EnableAverage);
		optionUI.add(EnableRMS);
		optionUI.add(EnableRing);
		optionUI.add(GateValue);
		EnableRing.addVisibilityTriggerTo(GateValue, true);
		
	}

	@Override
	public double[] process(double[] input, double[] position) {
		start = StartPoint.getValue();
		end	  = EndPoint.getValue();
		Gate  = GateValue.getValue();
		processNum =  FeatureNum(EnableMax.getValue(),EnableAverage.getValue(),EnableRMS.getValue(),EnableRing.getValue());
		double output[] = new double[processNum];
		double ResultArray[] = new double[4];
		double SelectedArray[] = new double[end-start];
		for(int i = start;i<end;i++)
		{
			SelectedArray[i-start]=input[i];
		}
		ResultArray[0] = MaxValue(SelectedArray);
		ResultArray[1] = AverageValue(SelectedArray);
		ResultArray[2] = RMSValue(SelectedArray);
		ResultArray[3] = RingValue(SelectedArray,Gate);
		output = FeatureArraySelect(ResultArray,EnableMax.getValue(),EnableAverage.getValue(),EnableRMS.getValue(),EnableRing.getValue());
		return output;
	}
	private int FeatureNum(boolean a,boolean b,boolean c,boolean d)
	{
		int num = 0;
		boolean condition[]={a,b,c,d};
		for(int i = 0;i<4;i++)
		{
			if(condition[i])
			{
				num = num+1;
			}
		}
		return num;
	}
	private double[] FeatureArraySelect(double[] origin,boolean a,boolean b,boolean c,boolean d)
	{
		int num = 0;
		double result[]= new double[processNum];
		boolean condition[]={a,b,c,d};
		for(int i = 0;i<4;i++)
		{
			if(condition[i])
			{
				result[num] = origin[i];
				num = num+1;
			}
		}
		return result;
		
	}
	private double MaxValue(double[] MeasureArray)
	{
		double result = 0;
		for(int i = 0;i<MeasureArray.length;i++)
		{
			if(MeasureArray[i]>result){
				result = MeasureArray[i];
			}
		}
		return result;
	}
	private double AverageValue(double[] MeasureArray)
	{
		double result = 0;
		for(int i = 0;i<MeasureArray.length;i++)
		{
			result =result + MeasureArray[i];
	}
		result = result/MeasureArray.length;
	return result;
	}
	private double RMSValue(double[] MeasureArray)
	{
		double result = 0;
		for(int i = 0;i<MeasureArray.length;i++)
		{
			result =result + Math.pow(MeasureArray[i],2);
	}
		result = Math.sqrt(result/MeasureArray.length);
	return result;
	}
	private double RingValue(double[] MeasureArray,double gate)
	{
		double result = 0;
		int j = 0;
		for(int i = 0;i<MeasureArray.length-1;i++)
		{
			j=i+1;
			if((MeasureArray[i]<gate)&&(MeasureArray[j]>gate)){
				
					result = result + 1.0;
			
			}
					
			
		}
		
		return result;
	}
}
