package plugins.worm.fft1d;

import java.util.ArrayList;
import java.util.HashMap;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import plugins.oeway.featureExtraction.featureExtractionPlugin;
import icy.gui.dialog.MessageDialog;
import icy.plugin.abstract_.PluginActionable;

public class FFT1D extends featureExtractionPlugin {
	private int _w;
	
	@Override
	public void initialize(HashMap<String,Object> options,ArrayList<Object> optionUI) {
		
	}

	@Override
	public double[] process(double[] input, double[] position) {
		_w=input.length;
		DoubleFFT_1D fft = new DoubleFFT_1D(_w);
		
		double[] fftResultArray = new double[_w*2];
		
		double[] output = new double[_w];
		fftResultArray = AddArrayBefore(input,fftResultArray);
		fft.realForwardFull(fftResultArray);
		
//		fftResultArray[0] = 0;
//		fftResultArray[1] = 0;
//		fftResultArray[_w*2-2] = 0;
//		fftResultArray[_w*2-1] = 0;
		for(int i=1;i<_w;i++)
		{
			
			output[i] =Math.sqrt(Math.pow(fftResultArray[2*i],2)+Math.pow(fftResultArray[2*i+1],2));
		}
		
		return output;
	}
	private double[] AddArrayBefore(double[] front,double[] sum ){
		int FrontLength = front.length;	
		for(int i=0;i<FrontLength;i++)
		{
			sum[i]=front[i];
		}
		return sum;
	}

}
