package plugins.worm.sequence2csv;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;

public class Sequence2CSV  extends EzPlug  implements IOBlock {
	EzVarSequence input = new EzVarSequence("Input sequence");
	VarSequence BlockInputSequence = input.getVariable();
	EzVarFile		File		= new EzVarFile("Select the path",null);
	VarFile			BlockFile	= new VarFile("Select the path",null);
	String path = new String();
	
	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add(BlockInputSequence);
		inputMap.add(BlockFile);
	}

	@Override
	public void declareOutput(VarList outputMap) {
		
		
	}

	@Override
	public void clean() {
	
		
	}

	@Override
	protected void execute() {
		 if (super.isHeadLess())
		  {
				if(BlockFile.getValue() ==null)
				{
					return;
				}
				else{
					path = BlockFile.getValue().getAbsolutePath();
					
				}
				if(path.length()>0)
				{
					saveAllData(input.getValue());
				}
		  }
		 else
		 {
			 if(File.getValue()==null){
				 return;
			}
			 else
			{
				path = File.getValue().getAbsolutePath();

			}
			
		
			 if(path.length()>0)
			 {
				 saveAllData(input.getValue());
			 }		
		 }
	}

	@Override
	protected void initialize() {
		super.addEzComponent(input);
		super.addEzComponent(File);
		
	}
	public void saveAllData(Sequence sequence)
    {
    	String pathchanged;
    	if(FileUtil.exist(path))
    	{
    		MessageDialog.showDialog("File is already exist,select another path");
    		return;
    	}
    	
    	FileUtil.createDir(path);
    	path = path+ FileUtil.separator+ sequence.getName().toString();
    	
    	for(int T =0;T<sequence.getSizeT();T++)
    	{
    		for(int Z =0;Z<sequence.getSizeZ();Z++)
    		{
    			
                if (!(path.contains(".csv")))
                {
                	path = path.concat(".csv");
                }
                
                	
                	pathchanged=path.replace(".csv", '_'+"t"+new Integer(T).toString()
	    	        			+'_'+"z"+new Integer(Z).toString()+".csv");
	        			saveImageData(pathchanged,sequence,T,Z);
                
                
    		}
    	}
    }
	 public void saveImageData(String path,Sequence sequence,int t,int z){
	     	

         if (path == null) return;
         if (!(path.contains(".csv")))
         {
         	path = path.concat(".csv");
         }
     	for(int channel = 0;channel<sequence.getSizeC();channel++)
	        {
	        	IcyBufferedImage im = sequence.getImage(t, z, channel);
	        	
             
             try
             {
             	FileWriter fw = new FileWriter(path.replace(".csv", '_'+"channel"+new Integer(channel).toString()+".csv"),false);
             	
                 BufferedWriter bw = new BufferedWriter(fw);
             	for(int y=0;y<im.getSizeY();y++)
             	{
             		
	                    for(int x=0;x<im.getSizeX()-1;x++)
	                    {
	                    	bw.write(new Double(im.getData(x, y, 0)).toString());
	                    	bw.write(',');
	                    }
	                    bw.write(new Double(im.getData(im.getSizeX()-1,y,0)).toString());
	                    bw.write('\n');
	                    bw.flush();
             	}
                bw.close();
                fw.close();
             }
             catch (IOException e1)
             {
                 MessageDialog.showDialog(e1.getMessage(), MessageDialog.ERROR_MESSAGE);
             }
	        }
     	
     }
}