package plugins.lagache.colocSimulator;
import flanagan.math.PsRandom;
import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.roi.ROI2DRectangle;
import icy.sequence.Sequence;
import icy.system.profile.Chronometer;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.TypeUtil;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.nchenouard.particleTracking.sequenceGenerator.Profile;
import plugins.nchenouard.particleTracking.sequenceGenerator.ProfileSpot;
import plugins.nchenouard.particleTracking.sequenceGenerator.TrackGeneratorWithProfiles;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Point3D;
import plugins.nchenouard.spot.Spot;


public class ColocalizationSimulator extends EzPlug{
	
	
	private EzVarInteger	seq_width = new EzVarInteger("Sequence width",256,1,100000,1);
	private EzVarInteger	seq_height = new EzVarInteger("Sequence height",256,1,100000,1);
	private EzVarInteger	frames = new EzVarInteger("Number of frames",10,1,100000,1);
	private EzVarInteger	seq_length = new EzVarInteger("Sequence length",1,0,1000,1);
	private EzVarBoolean  seq_3d = new EzVarBoolean("3D sequence", false);
	private EzVarInteger num_spots_1 = new EzVarInteger("Number of Spots 1",100,0,100000,1);
	private EzVarInteger num_spots_2 = new EzVarInteger("Number of Spots 2",100,0,100000,1);
	private EzVarBoolean  points = new EzVarBoolean("points", false);
	private EzVarDouble minIntensity = new EzVarDouble("Min. Spot intensity",10,0,100,1);
	private EzVarDouble maxIntensity = new EzVarDouble("Max. Spot intensity",30,0,100,1);
	private EzVarDouble meanGaussian = new EzVarDouble("Mean Gaussian noise",5,0,100,1);
	private EzVarDouble stdGaussian = new EzVarDouble("Std Gaussian noise",3,0,100,1);
	private EzVarDouble PoissonNoise = new EzVarDouble("Poisson noise",5,0,100,1);
	
	private EzVarDouble colocPercentage = new EzVarDouble("Percentage of colocalization",0.2,0,1,0.01);
	private EzVarDouble meanPercentage = new EzVarDouble("Mean distance of colocalization",1,0,10,0.1);
	private EzVarDouble stdPercentage = new EzVarDouble("Std distance of colocalization",0.3,0,3,0.01);
		
		@Override
	public void clean() {
		// TODO Auto-generated method stub

	}

	@Override
	protected void execute() {
		// double pas = 0.05;
		// int N = 5;
				
		//on va ajouter les spots
		//on cre le tableau de profiles
		int numParticles1 = num_spots_1.getValue();
		//les spots 2 sont soit random soit coloc
		int numParticles2 = num_spots_2.getValue();
		int numParticles2_coloc = Math.min((int)(colocPercentage.getValue()*numParticles2),numParticles1);
		int numParticles2_random = Math.max(numParticles2-numParticles2_coloc,0);
		
		
		double iMin=minIntensity.getValue();
		double iMax=maxIntensity.getValue();
		Sequence newSeq1 = new Sequence();
		Sequence newSeq2 = new Sequence();
		
		
		if (seq_3d.getValue()==false){
		generator2d.main(newSeq1,newSeq2,iMin,iMax,numParticles1,numParticles2,numParticles2_coloc,numParticles2_random,seq_width,seq_height,seq_length,meanPercentage,stdPercentage,meanGaussian,stdGaussian,PoissonNoise,points);
		}
		else
		{generator3d.main(newSeq1,newSeq2,iMin,iMax,numParticles1,numParticles2,numParticles2_coloc,numParticles2_random,seq_width,seq_height,seq_length,frames,meanPercentage,stdPercentage,meanGaussian,stdGaussian,PoissonNoise,points);}
		newSeq1.setName("Sequence 1");
		addSequence(newSeq1);
		newSeq2.setName("Sequence 2");
		addSequence(newSeq2);		
		

	}

	@Override
	protected void initialize() {

		super.addEzComponent(seq_height);
		super.addEzComponent(seq_width);
		super.addEzComponent(seq_length);
		super.addEzComponent(seq_3d);
		super.addEzComponent(frames);
		super.addEzComponent(num_spots_1);
		super.addEzComponent(num_spots_2);
		super.addEzComponent(points);
		super.addEzComponent(minIntensity);
		super.addEzComponent(maxIntensity);
		super.addEzComponent(meanGaussian);
		super.addEzComponent(stdGaussian);
		super.addEzComponent(PoissonNoise);
		super.addEzComponent(colocPercentage);
		super.addEzComponent(meanPercentage);
		super.addEzComponent(stdPercentage);
		
		

}}