package plugins.lagache.colocSimulator;

import flanagan.math.PsRandom;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.TypeUtil;

import java.awt.Point;
import java.util.ArrayList;

import plugins.adufour.ezplug.*;
import plugins.nchenouard.particleTracking.sequenceGenerator.Profile;
import plugins.nchenouard.particleTracking.sequenceGenerator.ProfileSpot;
import plugins.nchenouard.particleTracking.sequenceGenerator.TrackGeneratorWithProfiles;
import plugins.nchenouard.spot.Point3D;

public class generator2d {
	
	public static void main(Sequence newSeq1,Sequence newSeq2,double iMin,double iMax,int numParticles1,int numParticles2,int numParticles2_coloc,int numParticles2_random,EzVarInteger seq_width,EzVarInteger seq_height,EzVarInteger seq_length,EzVarDouble meanPercentage,EzVarDouble stdPercentage, EzVarDouble meanGaussian,EzVarDouble stdGaussian, EzVarDouble PoissonNoise,EzVarBoolean points){
	
		int T = seq_length.getValue();
		for (int t=0;t<T;t++){
	if (points.getValue()){
		ArrayList<Point3D> positions1 = new ArrayList<Point3D>();
		ArrayList<Point3D> positions2_random = new ArrayList<Point3D>();
		ArrayList<Point3D> positions2_coloc = new ArrayList<Point3D>();
		int cnt=0;
		PsRandom rr = new PsRandom();
		for (int i=0;i<numParticles1;i++)
		{			
			double x = Math.random()*seq_width.getValue();
			double y = Math.random()*seq_height.getValue();
			Point3D p = new Point3D(x, y);
			positions1.add(p);
			//gestion de la colocalisation
			if (cnt<numParticles2_coloc)
			{
				//coordonnes des points qui colocalisent en polaire 
				double r = rr.nextGaussian(meanPercentage.getValue(), stdPercentage.getValue());
				double theta = Math.random()*2*Math.PI;
				double x_coloc=x+r*Math.cos(theta);
				double y_coloc=y+r*Math.sin(theta);
				//gestion des frontires (reflexion)
				if (x_coloc>seq_width.getValue()||x_coloc<0)
				{
					x_coloc=x-r*Math.cos(theta);
				}
				if (y_coloc>seq_height.getValue()||y_coloc<0)
				{
					y_coloc=y-r*Math.sin(theta);
				}
				Point3D p2 = new Point3D(x_coloc,y_coloc);
				positions2_coloc.add(p2);
				cnt++;				
			}
		}
		for (int i=0;i<numParticles2_random;i++)
		{			
			double x = Math.random()*seq_width.getValue();
			double y = Math.random()*seq_height.getValue();
			Point3D p = new Point3D(x, y);
			positions2_random.add(p);
		}
		//display les spots sur la sequence
		int[] dims=new int[2];
		dims[0]=seq_width.getValue();
		dims[1]=seq_height.getValue();
		
		double[] array1 =  new double[dims[0]*dims[1]];
		double[] array2 =  new double[dims[0]*dims[1]];

		for (int j = 0; j < numParticles1; j++)
			{
			Point3D p= positions1.get(j);
			array1[(int)(p.x)+(int)(p.y)*dims[0]] = 255;
			}
		
		for (int j = 0; j < numParticles2_random; j++)
		{
			Point3D p2_r= positions2_random.get(j);
			array2[(int)(p2_r.x)+(int)(p2_r.y)*dims[0]] =  255;
		}
		for (int j = 0; j < numParticles2_coloc; j++)			
		{
			Point3D p2_c= positions2_coloc.get(j);
			array2[(int)(p2_c.x)+(int)(p2_c.y)*dims[0]] = 255;
		}
		IcyBufferedImage img1 = new IcyBufferedImage(dims[0], dims[1], 1, TypeUtil.TYPE_DOUBLE);
		IcyBufferedImage img2 = new IcyBufferedImage(dims[0], dims[1], 1, TypeUtil.TYPE_DOUBLE);
		img1.setDataXYAsDouble(0, array1);
		img2.setDataXYAsDouble(0, array2);
		//img = img.convertToType(dataType, false, false);
		img1.dataChanged();
		img2.dataChanged();
		newSeq1.setImage(t,0,img1);
		newSeq2.setImage(t,0,img2);
		}
	else{		
		ArrayList<Profile> tmpProfiles1 = TrackGeneratorWithProfiles.createCLSM05Profiles_2d(numParticles1, iMin, iMax, 0, 0);		
	ArrayList<Profile> tmpProfiles2_coloc = TrackGeneratorWithProfiles.createCLSM05Profiles_2d(numParticles2_coloc, iMin, iMax, 0, 0);
	ArrayList<Profile> tmpProfiles2_random = TrackGeneratorWithProfiles.createCLSM05Profiles_2d(numParticles2_random, iMin, iMax, 0, 0);		
	//on cre ensuite une liste de positions
	ArrayList<Point3D> positions1 = new ArrayList<Point3D>();
	ArrayList<Point3D> positions2_random = new ArrayList<Point3D>();
	ArrayList<Point3D> positions2_coloc = new ArrayList<Point3D>();
	
	ArrayList<ProfileSpot> tmpProfileSpots1 = new ArrayList<ProfileSpot>();
	ArrayList<ProfileSpot> tmpProfileSpots2 = new ArrayList<ProfileSpot>();
	
	int cnt=0;
	PsRandom rr = new PsRandom();
	for (int i=0;i<numParticles1;i++)
	{			
		double x = Math.random()*seq_width.getValue();
		double y = Math.random()*seq_height.getValue();
		Point3D p = new Point3D(x, y);
		positions1.add(p);
		ProfileSpot ps = new ProfileSpot(tmpProfiles1.get(i), p);
		tmpProfileSpots1.add(ps);
		//gestion de la colocalisation
		if (cnt<numParticles2_coloc)
		{
			//coordonnes des points qui colocalisent en polaire 
			double r = rr.nextGaussian(meanPercentage.getValue(), stdPercentage.getValue());
			double theta = Math.random()*2*Math.PI;
			double x_coloc=x+r*Math.cos(theta);
			double y_coloc=y+r*Math.sin(theta);
			//gestion des frontires (reflexion)
			if (x_coloc>seq_width.getValue()||x_coloc<0)
			{
				x_coloc=x-r*Math.cos(theta);
			}
			if (y_coloc>seq_height.getValue()||y_coloc<0)
			{
				y_coloc=y-r*Math.sin(theta);
			}
			Point3D p2 = new Point3D(x_coloc,y_coloc);
			positions2_coloc.add(p2);
			ProfileSpot ps2 = new ProfileSpot(tmpProfiles2_coloc.get(cnt), p2);
			tmpProfileSpots2.add(ps2);
			cnt++;				
		}
	}
	for (int i=0;i<numParticles2_random;i++)
	{			
		double x = Math.random()*seq_width.getValue();
		double y = Math.random()*seq_height.getValue();
		Point3D p = new Point3D(x, y);
		positions2_random.add(p);
		ProfileSpot ps = new ProfileSpot(tmpProfiles2_random.get(i), p);
		tmpProfileSpots2.add(ps);			
	}
	
	
	//display les spots sur la sequence
	
	double backMean=meanGaussian.getValue();
	double noiseSig=stdGaussian.getValue();
	double darkNoise=PoissonNoise.getValue();
	
	double gain =1;
	
	int[] dims=new int[2];
	dims[0]=seq_width.getValue();
	dims[1]=seq_height.getValue();
	
	PsRandom ran = new PsRandom();
		
	
	double[] array1 =  new double[dims[0]*dims[1]];
	double[] array2 =  new double[dims[0]*dims[1]];

	for (int j = 0; j < numParticles1; j++)
		{
							
		int[] maxDist = new int []{20,20};
		Profile p = tmpProfileSpots1.get(j).profile;
		Point3D d = tmpProfileSpots1.get(j).mass_center;					
		int minX = Math.max((int)(d.x - maxDist[0]), 0);
		int minY = Math.max((int)(d.y - maxDist[1]), 0);
		int maxX = Math.min((int)(d.x + maxDist[0]), dims[0]-1);
		int maxY = Math.min((int)(d.y + maxDist[1]), dims[1]-1);			
		for (int y0 = minY; y0<= maxY; y0++)
			for (int x0 = minX; x0<= maxX; x0++)
				array1[x0+y0*dims[0]] = array1[x0+y0*dims[0]] + p.getValue(new double[]{x0, y0, d.x, d.y});
		}
	
	for (int j = 0; j < numParticles2; j++)
	{
						
	int[] maxDist = new int []{20,20};
	Profile p = tmpProfileSpots2.get(j).profile;
	Point3D d = tmpProfileSpots2.get(j).mass_center;					
	int minX = Math.max((int)(d.x - maxDist[0]), 0);
	int minY = Math.max((int)(d.y - maxDist[1]), 0);
	int maxX = Math.min((int)(d.x + maxDist[0]), dims[0]-1);
	int maxY = Math.min((int)(d.y + maxDist[1]), dims[1]-1);			
	for (int y0 = minY; y0<= maxY; y0++)
		for (int x0 = minX; x0<= maxX; x0++)
			array2[x0+y0*dims[0]] = array2[x0+y0*dims[0]] + p.getValue(new double[]{x0, y0, d.x, d.y});
	}
	
	for(int i =0; i < array1.length; i++)
	{
	array1[i] = ran.nextGaussian(backMean, noiseSig) + gain*(ran.nextPoissonian(array1[i]) + ran.nextPoissonian(darkNoise));
	array2[i] = ran.nextGaussian(backMean, noiseSig) + gain*(ran.nextPoissonian(array2[i]) + ran.nextPoissonian(darkNoise));
	}
	
	
	IcyBufferedImage img1 = new IcyBufferedImage(dims[0], dims[1], 1, TypeUtil.TYPE_DOUBLE);
	IcyBufferedImage img2 = new IcyBufferedImage(dims[0], dims[1], 1, TypeUtil.TYPE_DOUBLE);
	img1.setDataXYAsDouble(0, array1);
	img2.setDataXYAsDouble(0, array2);
	//img = img.convertToType(dataType, false, false);
	img1.dataChanged();
	img2.dataChanged();
	newSeq1.setImage(t,0,img1);
	newSeq2.setImage(t,0,img2);
	}
	}
}
}
