/*
 * Decompiled with CFR 0.152.
 */
package plugins.tpecot.ccraft;

import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.BooleanMask4D;
import icy.roi.BooleanMask5D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROI4D;
import icy.roi.ROI5D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.DataType;
import icy.type.collection.array.Array2DUtil;
import icy.type.point.Point3D;
import icy.type.point.Point4D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import icy.type.rectangle.Rectangle5D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarFloat;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi4d.ROI4DArea;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;
import plugins.tpecot.ccraft.Terminal;

public class CCRAFT
extends EzPlug
implements EzStoppable,
Block {
    String[] interpolationPossibilities = new String[]{"Spatial", "Temporal"};
    EzVarInteger inPlanePatchSize = new EzVarInteger("XY patch size", 3, 15, 2);
    EzVarInteger inPlaneNeighborhoodSize = new EzVarInteger("XY patch neighborhood size", 9, 27, 6);
    EzVarInteger axialPatchSize = new EzVarInteger("Z patch size", 1, 15, 2);
    EzVarInteger axialNeighborhoodSize = new EzVarInteger("Z patch neighborhood size", 1, 15, 2);
    EzVarInteger nbTemporalIterations = new EzVarInteger("Number of iterations", 2, 10, 1);
    EzVarFloat pval = new EzVarFloat("p-value", 0.01f, 0.0f, 1.0f, 0.01f);
    EzVarFloat sReg = new EzVarFloat("Spatial regularization weight", 0.15f, 0.0f, 1.0f, 0.01f);
    EzVarFloat backgroundReg = new EzVarFloat("Background potential weight", 0.15f, 0.0f, 1.0f, 0.01f);
    EzVarText interpolationMethod = new EzVarText("Interpolation method", this.interpolationPossibilities, Boolean.valueOf(false));
    EzVarSequence inputSequence = new EzVarSequence("Input image");
    EzVarBoolean objectComponentOut = new EzVarBoolean("Object component", true);
    EzVarBoolean backgroundComponentOut = new EzVarBoolean("Background component", true);
    EzVarBoolean ROIsOut = new EzVarBoolean("Segmented object ROIs", true);
    EzVarBoolean energyAdvancedParameters = new EzVarBoolean("Advanced energy parameters", false);
    EzVarBoolean patchParameters = new EzVarBoolean("Patch parameters", false);
    EzVarBoolean particleCentersToSwimmingPool = new EzVarBoolean("Pool particle centers", true);
    Semaphore detectionSemaphore = new Semaphore();
    Semaphore optimizationSemaphore = new Semaphore();
    boolean stopRunningBgProcess = false;
    int[][][] detectionData;
    float[][][] objectData;
    float[][][] backgroundData;
    VarSequence objectComponent = new VarSequence("objectComponent", null);
    VarSequence backgroundComponent = new VarSequence("backgroundComponent", null);
    VarROIArray outputROIs = new VarROIArray("outputROIs");

    float SigmaLTS(float[] tab, int N) {
        float sigma;
        int k = 0;
        float[] I = new float[N];
        int j = 0;
        while (j < N) {
            if (tab[j] > 0.0f) {
                I[k] = (float)Math.pow(tab[j], 2.0);
                ++k;
            }
            ++j;
        }
        N = k - 1;
        if (N <= 0) {
            sigma = 0.1f;
        } else {
            Arrays.sort(I);
            sigma = 0.0f;
            int Nmed = (int)(0.5 * (double)N);
            int i = 0;
            while (i < Nmed) {
                sigma += I[i];
                ++i;
            }
            sigma = (float)Math.max(0.1, 2.6477 * Math.sqrt(sigma / (float)Nmed));
        }
        return sigma;
    }

    float[] PseudoResidu(float[][] inputData, int w, int h, int currentFrame) {
        float[] residu = new float[w * h];
        int i = 0;
        while (i < w - 1) {
            int j = 0;
            while (j < h - 1) {
                residu[j * w + i] = (float)((double)(2.0f * inputData[0][j * w + i] - inputData[0][j * w + i + 1] - inputData[0][(j + 1) * w + i]) / Math.sqrt(6.0));
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < h - 1) {
            residu[j * w + w - 1] = (float)((double)(2.0f * inputData[0][j * w + w - 1] - inputData[0][j * w + w - 2] - inputData[0][(j + 1) * w + w - 1]) / Math.sqrt(6.0));
            ++j;
        }
        i = 0;
        while (i < w - 1) {
            residu[(h - 1) * w + i] = (float)((double)(2.0f * inputData[0][(h - 1) * w + i] - inputData[0][(h - 1) * w + i + 1] - inputData[0][(h - 2) * w + i]) / Math.sqrt(6.0));
            ++i;
        }
        residu[(h - 1) * w + w - 1] = (float)((double)(2.0f * inputData[0][(h - 1) * w + w - 1] - inputData[0][(h - 1) * w + w - 2] - inputData[0][(h - 2) * w + w - 1]) / Math.sqrt(6.0));
        return residu;
    }

    void detectionMeasureComputation(float[][] inputData, float[][][] output, int currentFrame, int n, int m, int l, int inPlanePatchSize, int axialPatchSize, int inPlaneNeighborhoodSize, int axialNeighborhoodSize, float sigma) {
        int x;
        int y;
        int inPlaneNeighborhoodOffset = (inPlaneNeighborhoodSize - inPlanePatchSize) / 2;
        int halfInPlanePatchSize = (inPlanePatchSize - 1) / 2;
        int axialNeighborhoodOffset = (axialNeighborhoodSize - axialPatchSize) / 2;
        int halfAxialPatchSize = (axialPatchSize - 1) / 2;
        float[][][] euclideanDistances = new float[l][n * m][inPlaneNeighborhoodSize * inPlaneNeighborhoodSize * axialNeighborhoodSize / (inPlanePatchSize * inPlanePatchSize * axialPatchSize)];
        int tabShift = inPlaneNeighborhoodSize * inPlaneNeighborhoodSize * axialNeighborhoodSize / (inPlanePatchSize * inPlanePatchSize * axialPatchSize) / 2;
        int yShift = inPlaneNeighborhoodSize / inPlanePatchSize;
        int zShift = inPlaneNeighborhoodSize * inPlaneNeighborhoodSize / (inPlanePatchSize * inPlanePatchSize);
        int[][] indexTab = new int[tabShift][3];
        int index = 0;
        while (index < tabShift) {
            int zCoder = index / zShift;
            int yCoder = (index - zCoder * zShift) / yShift;
            int xCoder = index - zCoder * zShift - yCoder * yShift;
            indexTab[index][0] = xCoder * inPlanePatchSize - inPlaneNeighborhoodOffset;
            indexTab[index][1] = yCoder * inPlanePatchSize - inPlaneNeighborhoodOffset;
            indexTab[index][2] = zCoder * axialPatchSize - axialNeighborhoodOffset;
            ++index;
        }
        int z = 0;
        while (z < l) {
            y = 0;
            while (y < m) {
                x = 0;
                while (x < n) {
                    int index2 = 0;
                    while (index2 < tabShift) {
                        int xIndex = Math.max(Math.min(x + indexTab[index2][0], n - 1), 0);
                        int yIndex = Math.max(Math.min(y + indexTab[index2][1], m - 1), 0);
                        int zIndex = Math.max(Math.min(z + indexTab[index2][2], l - 1), 0);
                        euclideanDistances[z][y * n + x][indexTab[index2][2] / axialPatchSize * zShift + indexTab[index2][1] / inPlanePatchSize * yShift + indexTab[index2][0] / inPlanePatchSize + tabShift] = (float)Math.pow(inputData[zIndex][yIndex * n + xIndex] - inputData[z][y * n + x], 2.0);
                        euclideanDistances[zIndex][yIndex * n + xIndex][tabShift - (indexTab[index2][2] / axialPatchSize * zShift + indexTab[index2][1] / inPlanePatchSize * yShift + indexTab[index2][0] / inPlanePatchSize)] = (float)Math.pow(inputData[zIndex][yIndex * n + xIndex] - inputData[z][y * n + x], 2.0);
                        ++index2;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        z = 0;
        while (z < l) {
            y = 0;
            while (y < m) {
                x = 0;
                while (x < n) {
                    float distance = 0.0f;
                    int t = -halfAxialPatchSize;
                    while (t <= halfAxialPatchSize) {
                        int u = -halfInPlanePatchSize;
                        while (u <= halfInPlanePatchSize) {
                            int v = -halfInPlanePatchSize;
                            while (v <= halfInPlanePatchSize) {
                                int xIndex = Math.max(Math.min(x + v, n - 1), 0);
                                int yIndex = Math.max(Math.min(y + u, m - 1), 0);
                                int zIndex = Math.max(Math.min(z + t, l - 1), 0);
                                int p = 0;
                                while (p < inPlaneNeighborhoodSize * inPlaneNeighborhoodSize * axialNeighborhoodSize / (inPlanePatchSize * inPlanePatchSize * axialPatchSize)) {
                                    distance += euclideanDistances[zIndex][yIndex * n + xIndex][p];
                                    ++p;
                                }
                                ++v;
                            }
                            ++u;
                        }
                        ++t;
                    }
                    if ((double)distance > 1.0E-4) {
                        output[currentFrame][z][y * n + x] = (float)Math.max((double)distance / (4.0 * Math.pow(sigma, 2.0)) - (double)(inPlanePatchSize * inPlanePatchSize / 2 - 1) * Math.log(distance), 0.0);
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    float getTrimmedMean(float[] pixIntensities, int nbPixelsToRemoveOnEachSide) {
        float trimmedMean = 0.0f;
        int i = nbPixelsToRemoveOnEachSide;
        while (i < pixIntensities.length - nbPixelsToRemoveOnEachSide) {
            trimmedMean += pixIntensities[i];
            ++i;
        }
        return trimmedMean /= (float)(pixIntensities.length - 2 * nbPixelsToRemoveOnEachSide);
    }

    float getWinsorizedVar(float[] pixIntensities, int nbPixelsToRemoveOnEachSide) {
        float trimmedMean = this.getTrimmedMean(pixIntensities, nbPixelsToRemoveOnEachSide);
        float windsorizedMean = (trimmedMean * (float)(pixIntensities.length - 2 * nbPixelsToRemoveOnEachSide) + (float)nbPixelsToRemoveOnEachSide * pixIntensities[nbPixelsToRemoveOnEachSide - 1] + (float)nbPixelsToRemoveOnEachSide * pixIntensities[pixIntensities.length - nbPixelsToRemoveOnEachSide + 1]) / (float)pixIntensities.length;
        float windsorizedVar = 0.0f;
        int i = nbPixelsToRemoveOnEachSide;
        while (i < pixIntensities.length - nbPixelsToRemoveOnEachSide) {
            windsorizedVar = (float)((double)windsorizedVar + Math.pow(pixIntensities[i] - windsorizedMean, 2.0));
            ++i;
        }
        windsorizedVar = (float)((double)windsorizedVar + (double)nbPixelsToRemoveOnEachSide * (Math.pow(pixIntensities[nbPixelsToRemoveOnEachSide - 1] - windsorizedMean, 2.0) + Math.pow(pixIntensities[pixIntensities.length - nbPixelsToRemoveOnEachSide + 1] - windsorizedMean, 2.0))) / (float)pixIntensities.length;
        return windsorizedVar;
    }

    float chebyshevThresholdingMethod(float[][][] detectionMeasure, int currentFrame, float pval, int nbSlices, int arraySize) {
        float[] pixelIntensities = new float[nbSlices * arraySize];
        int z = 0;
        while (z < nbSlices) {
            int i = 0;
            while (i < arraySize) {
                pixelIntensities[z * arraySize + i] = detectionMeasure[currentFrame][z][i];
                ++i;
            }
            ++z;
        }
        Arrays.sort(pixelIntensities);
        int nbPixelsToRemoveOnEachSideForTrimmedMean = (int)((double)pixelIntensities.length * 0.25);
        float trimmedMean = this.getTrimmedMean(pixelIntensities, nbPixelsToRemoveOnEachSideForTrimmedMean);
        int nbPixelsToRemoveOnEachSideForWindsorizedVar = (int)((double)pixelIntensities.length * 0.1);
        float winsorizedVar = this.getWinsorizedVar(pixelIntensities, nbPixelsToRemoveOnEachSideForWindsorizedVar);
        return (float)((double)trimmedMean + Math.sqrt(winsorizedVar) / Math.sqrt(pval));
    }

    int[][] makeStrElt(int radiusXY, int radiusZ) {
        int StrEltDimXY = 2 * radiusXY + 1;
        int StrEltDimZ = 2 * radiusZ + 1;
        int[][] StrElt = new int[StrEltDimZ][StrEltDimXY * StrEltDimXY];
        int dz = -radiusZ;
        while (dz <= radiusZ) {
            int dy = -radiusXY;
            while (dy <= radiusXY) {
                int dx = -radiusXY;
                while (dx <= radiusXY) {
                    if (Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0)) < (double)radiusXY) {
                        StrElt[dz + radiusZ][(dy + radiusXY) * StrEltDimXY + dx + radiusXY] = 1;
                    }
                    ++dx;
                }
                ++dy;
            }
            ++dz;
        }
        return StrElt;
    }

    int[][] dilate(int[][] data, int[][] StrElt, int radiusXY, int radiusZ, int dimX, int dimY, int dimZ) {
        int[][] result = new int[dimZ][dimX * dimY];
        int StrEltDimXY = 2 * radiusXY + 1;
        int StrEltDimZ = 2 * radiusZ + 1;
        int z = 0;
        while (z < dimZ) {
            int y = 0;
            while (y < dimY) {
                int x = 0;
                while (x < dimX) {
                    if (data[z][y * dimX + x] > 0) {
                        int w = 0;
                        while (w < StrEltDimZ) {
                            int v = 0;
                            while (v < StrEltDimXY) {
                                int u = 0;
                                while (u < StrEltDimXY) {
                                    if (x + u - radiusXY >= 0 && x + u - radiusXY < dimX && y + v - radiusXY >= 0 && y + v - radiusXY < dimY && z + w - radiusZ >= 0 && z + w - radiusZ < dimZ && (double)StrElt[w][v * StrEltDimXY + u] > 1.0E-4) {
                                        result[z + w - radiusZ][(y + v - radiusXY) * dimX + x + u - radiusXY] = 1;
                                    }
                                    ++u;
                                }
                                ++v;
                            }
                            ++w;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return result;
    }

    int[][] erode(int[][] data, int[][] StrElt, int radiusXY, int radiusZ, int dimX, int dimY, int dimZ) {
        int[][] result = new int[dimZ][dimX * dimY];
        int StrEltDimXY = 2 * radiusXY + 1;
        int StrEltDimZ = 2 * radiusZ + 1;
        int z = 0;
        while (z < dimZ) {
            int y = 0;
            while (y < dimY) {
                int x = 0;
                while (x < dimX) {
                    if (data[z][y * dimX + x] > 0) {
                        result[z][y * dimX + x] = 1;
                        int w = 0;
                        while (w < StrEltDimZ) {
                            int v = 0;
                            while (v < StrEltDimXY) {
                                int u = 0;
                                while (u < StrEltDimXY) {
                                    if (x + u - radiusXY >= 0 && x + u - radiusXY < dimX && y + v - radiusXY >= 0 && y + v - radiusXY < dimY && z + w - radiusZ >= 0 && z + w - radiusZ < dimZ && (double)StrElt[w][v * StrEltDimXY + u] > 1.0E-4 && data[z + w - radiusZ][(y + v - radiusXY) * dimX + x + u - radiusXY] == 0) {
                                        result[z][y * dimX + x] = 0;
                                    }
                                    ++u;
                                }
                                ++v;
                            }
                            ++w;
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return result;
    }

    void spatialInterpolation(int[][][] detection, float[][] sequence, float[][][] object, float[][][] background, int width, int height, int depth, int currentFrame) {
        int i;
        int structuringElementZdim = 0;
        if (depth > 1) {
            structuringElementZdim = 1;
        }
        int[][] structuringElement = this.makeStrElt(2, structuringElementZdim);
        int[][] labelledDetection = new int[depth][width * height];
        int z = 0;
        while (z < depth) {
            int i2 = 0;
            while (i2 < width * height) {
                if (detection[currentFrame][z][i2] > 0 && (double)background[currentFrame][z][i2] < 1.0E-4) {
                    labelledDetection[z][i2] = detection[currentFrame][z][i2];
                }
                ++i2;
            }
            ++z;
        }
        int currentLabel = 1;
        int z2 = 0;
        while (z2 < depth) {
            int y = 1;
            while (y < height - 1) {
                int x = 1;
                while (x < width - 1) {
                    if (detection[currentFrame][z2][y * width + x] > 0) {
                        if (labelledDetection[z2][y * width + x] == detection[currentFrame][z2][y * width + x]) {
                            labelledDetection[z2][y * width + x] = ++currentLabel;
                            if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                            }
                            if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                            }
                            if (labelledDetection[z2][y * width + x + 1] == 1) {
                                labelledDetection[z2][y * width + x + 1] = currentLabel;
                            }
                            if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                            }
                        } else {
                            if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                            }
                            if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                            }
                            if (labelledDetection[z2][y * width + x + 1] == 1) {
                                labelledDetection[z2][y * width + x + 1] = currentLabel;
                            }
                            if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                            }
                        }
                    }
                    ++x;
                }
                ++y;
            }
            ++z2;
        }
        boolean change = true;
        while (change) {
            change = false;
            int z3 = 0;
            while (z3 < depth) {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        if (labelledDetection[z3][y * width + x] > 0) {
                            int w = -1;
                            while (w <= 1) {
                                int v = -1;
                                while (v <= 1) {
                                    int u = -1;
                                    while (u <= 1) {
                                        if (x + u >= 0 && x + u < width && y + v >= 0 && y + v < height && z3 + w >= 0 && z3 + w < depth && labelledDetection[z3 + w][(y + v) * width + x + u] > 0 && labelledDetection[z3 + w][(y + v) * width + x + u] != labelledDetection[z3][y * width + x]) {
                                            int minLabel;
                                            change = true;
                                            labelledDetection[z3 + w][(y + v) * width + x + u] = minLabel = Math.min(labelledDetection[z3 + w][(y + v) * width + x + u], labelledDetection[z3][y * width + x]);
                                            labelledDetection[z3][y * width + x] = minLabel;
                                        }
                                        ++u;
                                    }
                                    ++v;
                                }
                                ++w;
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z3;
            }
        }
        int[] labelTable = new int[currentLabel + 1];
        int z4 = 0;
        while (z4 < depth) {
            i = 0;
            while (i < width * height) {
                if (labelledDetection[z4][i] > 0) {
                    labelTable[labelledDetection[z4][i]] = 1;
                }
                ++i;
            }
            ++z4;
        }
        int newLabel = 1;
        i = 0;
        while (i < currentLabel + 1) {
            if (labelTable[i] > 0) {
                labelTable[i] = newLabel++;
            }
            ++i;
        }
        int z5 = 0;
        while (z5 < depth) {
            int i3 = 0;
            while (i3 < width * height) {
                if (labelledDetection[z5][i3] > 0) {
                    labelledDetection[z5][i3] = labelTable[labelledDetection[z5][i3]];
                }
                ++i3;
            }
            ++z5;
        }
        i = 1;
        while (i < newLabel) {
            int[][] region = new int[depth][width * height];
            int[][] maskC = new int[depth][width * height];
            ArrayList<Integer> xCurrentRegionList = new ArrayList<Integer>();
            ArrayList<Integer> yCurrentRegionList = new ArrayList<Integer>();
            ArrayList<Integer> zCurrentRegionList = new ArrayList<Integer>();
            ArrayList<Integer> xCurrentRegionContourList = new ArrayList<Integer>();
            ArrayList<Integer> yCurrentRegionContourList = new ArrayList<Integer>();
            ArrayList<Integer> zCurrentRegionContourList = new ArrayList<Integer>();
            int z6 = 0;
            while (z6 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (labelledDetection[z6][y * width + x] == i) {
                            region[z6][y * width + x] = 1;
                            xCurrentRegionList.add(x);
                            yCurrentRegionList.add(y);
                            zCurrentRegionList.add(z6);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z6;
            }
            int radiusZ = 0;
            if (depth > 1) {
                radiusZ = 1;
            }
            int[][] maskD = this.dilate(region, structuringElement, 2, radiusZ, width, height, depth);
            int z7 = 0;
            while (z7 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        maskC[z7][y * width + x] = maskD[z7][y * width + x] - region[z7][y * width + x];
                        if (maskC[z7][y * width + x] == 1) {
                            xCurrentRegionContourList.add(x);
                            yCurrentRegionContourList.add(y);
                            zCurrentRegionContourList.add(z7);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z7;
            }
            int v = 0;
            while (v < xCurrentRegionList.size()) {
                int currentX = (Integer)xCurrentRegionList.get(v);
                int currentY = (Integer)yCurrentRegionList.get(v);
                int currentZ = (Integer)zCurrentRegionList.get(v);
                float distanceSum = 0.0f;
                background[currentFrame][currentZ][currentY * width + currentX] = 0.0f;
                int w = 0;
                while (w < xCurrentRegionContourList.size()) {
                    float[] fArray = background[currentFrame][currentZ];
                    int n = currentY * width + currentX;
                    fArray[n] = (float)((double)fArray[n] + (double)background[currentFrame][(Integer)zCurrentRegionContourList.get(w)][(Integer)yCurrentRegionContourList.get(w) * width + (Integer)xCurrentRegionContourList.get(w)] / Math.sqrt(Math.pow((Integer)xCurrentRegionContourList.get(w) - currentX, 2.0) + Math.pow((Integer)yCurrentRegionContourList.get(w) - currentY, 2.0) + Math.pow((Integer)zCurrentRegionContourList.get(w) - currentZ, 2.0)));
                    distanceSum = (float)((double)distanceSum + 1.0 / Math.sqrt(Math.pow((Integer)xCurrentRegionContourList.get(w) - currentX, 2.0) + Math.pow((Integer)yCurrentRegionContourList.get(w) - currentY, 2.0) + Math.pow((Integer)zCurrentRegionContourList.get(w) - currentZ, 2.0)));
                    ++w;
                }
                float[] fArray = background[currentFrame][currentZ];
                int n = currentY * width + currentX;
                fArray[n] = fArray[n] / distanceSum;
                if (background[currentFrame][currentZ][currentY * width + currentX] > sequence[currentZ][currentY * width + currentX]) {
                    background[currentFrame][currentZ][currentY * width + currentX] = sequence[currentZ][currentY * width + currentX];
                }
                ++v;
            }
            ++i;
        }
        z5 = 0;
        while (z5 < depth) {
            int i4 = 0;
            while (i4 < width * height) {
                if ((double)(sequence[z5][i4] - background[currentFrame][z5][i4]) > 0.001) {
                    object[currentFrame][z5][i4] = sequence[z5][i4] - background[currentFrame][z5][i4];
                }
                ++i4;
            }
            ++z5;
        }
    }

    void temporalInterpolation(int[][][] detection, float[][] sequence, float[][][] object, float[][][] background, int arraySize, int depth, int nbFrames, int currentFrame) {
        int i;
        int z = 0;
        while (z < depth) {
            i = 0;
            while (i < arraySize) {
                if (detection[currentFrame][z][i] > 0) {
                    int nbPreviousBackgrounds = 0;
                    float interpolation = 0.0f;
                    float den = 0.0f;
                    int t = 0;
                    while (t < nbFrames) {
                        if (t != currentFrame && (double)background[t][z][i] > 0.0) {
                            ++nbPreviousBackgrounds;
                            interpolation = (float)((double)interpolation + (double)background[t][z][i] * Math.pow(currentFrame - t, 2.0));
                            den = (float)((double)den + Math.pow(currentFrame - t, 2.0));
                        }
                        ++t;
                    }
                    background[currentFrame][z][i] = nbPreviousBackgrounds > 0 ? interpolation / den : -1.0f;
                } else {
                    background[currentFrame][z][i] = sequence[z][i];
                }
                ++i;
            }
            ++z;
        }
        z = 0;
        while (z < depth) {
            i = 0;
            while (i < arraySize) {
                if ((double)background[currentFrame][z][i] > 0.0) {
                    if ((double)(sequence[z][i] - background[currentFrame][z][i]) > 0.0) {
                        object[currentFrame][z][i] = sequence[z][i] - background[currentFrame][z][i];
                    }
                } else {
                    object[currentFrame][z][i] = -1.0f;
                }
                ++i;
            }
            ++z;
        }
    }

    void segmentedVesiclesROIs4D(Sequence seq, int[][][] detection, int width, int height, int depth, int nbFrames) {
        int currentFrame = 0;
        while (currentFrame < nbFrames) {
            int i;
            int[][] labelledDetection = new int[depth][width * height];
            int[][] vesicleContour = new int[depth][width * height];
            int z = 0;
            while (z < depth) {
                int i2 = 0;
                while (i2 < width * height) {
                    if (detection[currentFrame][z][i2] > 0) {
                        labelledDetection[z][i2] = detection[currentFrame][z][i2];
                    }
                    ++i2;
                }
                ++z;
            }
            int currentLabel = 1;
            int z2 = 0;
            while (z2 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (detection[currentFrame][z2][y * width + x] > 0) {
                            if (labelledDetection[z2][y * width + x] == detection[currentFrame][z2][y * width + x]) {
                                labelledDetection[z2][y * width + x] = ++currentLabel;
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            } else {
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            boolean change = true;
            while (change) {
                change = false;
                int z3 = 0;
                while (z3 < depth) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            if (labelledDetection[z3][y * width + x] > 0) {
                                int w = -1;
                                while (w <= 1) {
                                    int v = -1;
                                    while (v <= 1) {
                                        int u = -1;
                                        while (u <= 1) {
                                            if (x + u >= 0 && x + u < width && y + v >= 0 && y + v < height && z3 + w >= 0 && z3 + w < depth && labelledDetection[z3 + w][(y + v) * width + x + u] > 0 && labelledDetection[z3 + w][(y + v) * width + x + u] != labelledDetection[z3][y * width + x]) {
                                                int minLabel;
                                                change = true;
                                                labelledDetection[z3 + w][(y + v) * width + x + u] = minLabel = Math.min(labelledDetection[z3 + w][(y + v) * width + x + u], labelledDetection[z3][y * width + x]);
                                                labelledDetection[z3][y * width + x] = minLabel;
                                            }
                                            ++u;
                                        }
                                        ++v;
                                    }
                                    ++w;
                                }
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z3;
                }
            }
            int[] labelTable = new int[currentLabel + 1];
            int z4 = 0;
            while (z4 < depth) {
                i = 0;
                while (i < width * height) {
                    if (labelledDetection[z4][i] > 0) {
                        labelTable[labelledDetection[z4][i]] = 1;
                    }
                    ++i;
                }
                ++z4;
            }
            int newLabel = 1;
            i = 0;
            while (i < currentLabel + 1) {
                if (labelTable[i] > 0) {
                    labelTable[i] = newLabel++;
                }
                ++i;
            }
            int z5 = 0;
            while (z5 < depth) {
                int i3 = 0;
                while (i3 < width * height) {
                    if (labelledDetection[z5][i3] > 0) {
                        labelledDetection[z5][i3] = labelTable[labelledDetection[z5][i3]];
                    }
                    ++i3;
                }
                ++z5;
            }
            i = 1;
            while (i < newLabel) {
                int[][] region = new int[depth][width * height];
                int[][] maskC = new int[depth][width * height];
                ArrayList<Integer> xCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> yCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> zCurrentRegionList = new ArrayList<Integer>();
                int z6 = 0;
                while (z6 < depth) {
                    int y = 1;
                    while (y < height - 1) {
                        int x = 1;
                        while (x < width - 1) {
                            if (labelledDetection[z6][y * width + x] == i) {
                                region[z6][y * width + x] = 1;
                                xCurrentRegionList.add(x);
                                yCurrentRegionList.add(y);
                                zCurrentRegionList.add(z6);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z6;
                }
                Point4D[] ptList = new Point4D[xCurrentRegionList.size()];
                int p = 0;
                while (p < xCurrentRegionList.size()) {
                    Point4D.Integer pt = new Point4D.Integer(((Integer)xCurrentRegionList.get(p)).intValue(), ((Integer)yCurrentRegionList.get(p)).intValue(), ((Integer)zCurrentRegionList.get(p)).intValue(), currentFrame);
                    ptList[p] = pt;
                    ++p;
                }
                BooleanMask4D currentRegion = new BooleanMask4D(ptList);
                ROI4DArea currentRoi = new ROI4DArea(currentRegion);
                seq.addROI((ROI)currentRoi);
                ++i;
            }
            ++currentFrame;
        }
    }

    void segmentedVesiclesROIs3D(Sequence seq, int[][][] detection, int width, int height, int depth, int nbFrames) {
        int currentFrame = 0;
        while (currentFrame < nbFrames) {
            int i;
            int[][] labelledDetection = new int[depth][width * height];
            int[][] vesicleContour = new int[depth][width * height];
            int z = 0;
            while (z < depth) {
                int i2 = 0;
                while (i2 < width * height) {
                    if (detection[currentFrame][z][i2] > 0) {
                        labelledDetection[z][i2] = detection[currentFrame][z][i2];
                    }
                    ++i2;
                }
                ++z;
            }
            int currentLabel = 1;
            int z2 = 0;
            while (z2 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (detection[currentFrame][z2][y * width + x] > 0) {
                            if (labelledDetection[z2][y * width + x] == detection[currentFrame][z2][y * width + x]) {
                                labelledDetection[z2][y * width + x] = ++currentLabel;
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            } else {
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            boolean change = true;
            while (change) {
                change = false;
                int z3 = 0;
                while (z3 < depth) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            if (labelledDetection[z3][y * width + x] > 0) {
                                int w = -1;
                                while (w <= 1) {
                                    int v = -1;
                                    while (v <= 1) {
                                        int u = -1;
                                        while (u <= 1) {
                                            if (x + u >= 0 && x + u < width && y + v >= 0 && y + v < height && z3 + w >= 0 && z3 + w < depth && labelledDetection[z3 + w][(y + v) * width + x + u] > 0 && labelledDetection[z3 + w][(y + v) * width + x + u] != labelledDetection[z3][y * width + x]) {
                                                int minLabel;
                                                change = true;
                                                labelledDetection[z3 + w][(y + v) * width + x + u] = minLabel = Math.min(labelledDetection[z3 + w][(y + v) * width + x + u], labelledDetection[z3][y * width + x]);
                                                labelledDetection[z3][y * width + x] = minLabel;
                                            }
                                            ++u;
                                        }
                                        ++v;
                                    }
                                    ++w;
                                }
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z3;
                }
            }
            int[] labelTable = new int[currentLabel + 1];
            int z4 = 0;
            while (z4 < depth) {
                i = 0;
                while (i < width * height) {
                    if (labelledDetection[z4][i] > 0) {
                        labelTable[labelledDetection[z4][i]] = 1;
                    }
                    ++i;
                }
                ++z4;
            }
            int newLabel = 1;
            i = 0;
            while (i < currentLabel + 1) {
                if (labelTable[i] > 0) {
                    labelTable[i] = newLabel++;
                }
                ++i;
            }
            int z5 = 0;
            while (z5 < depth) {
                int i3 = 0;
                while (i3 < width * height) {
                    if (labelledDetection[z5][i3] > 0) {
                        labelledDetection[z5][i3] = labelTable[labelledDetection[z5][i3]];
                    }
                    ++i3;
                }
                ++z5;
            }
            i = 1;
            while (i < newLabel) {
                int[][] region = new int[depth][width * height];
                int[][] maskC = new int[depth][width * height];
                ArrayList<Integer> xCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> yCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> zCurrentRegionList = new ArrayList<Integer>();
                int z6 = 0;
                while (z6 < depth) {
                    int y = 1;
                    while (y < height - 1) {
                        int x = 1;
                        while (x < width - 1) {
                            if (labelledDetection[z6][y * width + x] == i) {
                                region[z6][y * width + x] = 1;
                                xCurrentRegionList.add(x);
                                yCurrentRegionList.add(y);
                                zCurrentRegionList.add(z6);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z6;
                }
                Point3D[] ptList = new Point3D[xCurrentRegionList.size()];
                int p = 0;
                while (p < xCurrentRegionList.size()) {
                    Point3D.Integer pt = new Point3D.Integer(((Integer)xCurrentRegionList.get(p)).intValue(), ((Integer)yCurrentRegionList.get(p)).intValue(), ((Integer)zCurrentRegionList.get(p)).intValue());
                    ptList[p] = pt;
                    ++p;
                }
                BooleanMask3D currentRegion = new BooleanMask3D(ptList);
                ROI3DArea currentRoi = new ROI3DArea(currentRegion);
                seq.addROI((ROI)currentRoi);
                ++i;
            }
            ++currentFrame;
        }
    }

    void segmentedVesiclesROIs4D(int[][][] detection, VarROIArray objectROIs, int width, int height, int depth, int nbFrames) {
        int currentFrame = 0;
        while (currentFrame < nbFrames) {
            int i;
            int[][] labelledDetection = new int[depth][width * height];
            int[][] vesicleContour = new int[depth][width * height];
            int z = 0;
            while (z < depth) {
                int i2 = 0;
                while (i2 < width * height) {
                    if (detection[currentFrame][z][i2] > 0) {
                        labelledDetection[z][i2] = detection[currentFrame][z][i2];
                    }
                    ++i2;
                }
                ++z;
            }
            int currentLabel = 1;
            int z2 = 0;
            while (z2 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (detection[currentFrame][z2][y * width + x] > 0) {
                            if (labelledDetection[z2][y * width + x] == detection[currentFrame][z2][y * width + x]) {
                                labelledDetection[z2][y * width + x] = ++currentLabel;
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            } else {
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            boolean change = true;
            while (change) {
                change = false;
                int z3 = 0;
                while (z3 < depth) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            if (labelledDetection[z3][y * width + x] > 0) {
                                int w = -1;
                                while (w <= 1) {
                                    int v = -1;
                                    while (v <= 1) {
                                        int u = -1;
                                        while (u <= 1) {
                                            if (x + u >= 0 && x + u < width && y + v >= 0 && y + v < height && z3 + w >= 0 && z3 + w < depth && labelledDetection[z3 + w][(y + v) * width + x + u] > 0 && labelledDetection[z3 + w][(y + v) * width + x + u] != labelledDetection[z3][y * width + x]) {
                                                int minLabel;
                                                change = true;
                                                labelledDetection[z3 + w][(y + v) * width + x + u] = minLabel = Math.min(labelledDetection[z3 + w][(y + v) * width + x + u], labelledDetection[z3][y * width + x]);
                                                labelledDetection[z3][y * width + x] = minLabel;
                                            }
                                            ++u;
                                        }
                                        ++v;
                                    }
                                    ++w;
                                }
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z3;
                }
            }
            int[] labelTable = new int[currentLabel + 1];
            int z4 = 0;
            while (z4 < depth) {
                i = 0;
                while (i < width * height) {
                    if (labelledDetection[z4][i] > 0) {
                        labelTable[labelledDetection[z4][i]] = 1;
                    }
                    ++i;
                }
                ++z4;
            }
            int newLabel = 1;
            i = 0;
            while (i < currentLabel + 1) {
                if (labelTable[i] > 0) {
                    labelTable[i] = newLabel++;
                }
                ++i;
            }
            int z5 = 0;
            while (z5 < depth) {
                int i3 = 0;
                while (i3 < width * height) {
                    if (labelledDetection[z5][i3] > 0) {
                        labelledDetection[z5][i3] = labelTable[labelledDetection[z5][i3]];
                    }
                    ++i3;
                }
                ++z5;
            }
            i = 1;
            while (i < newLabel) {
                int[][] region = new int[depth][width * height];
                int[][] maskC = new int[depth][width * height];
                ArrayList<Integer> xCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> yCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> zCurrentRegionList = new ArrayList<Integer>();
                int z6 = 0;
                while (z6 < depth) {
                    int y = 1;
                    while (y < height - 1) {
                        int x = 1;
                        while (x < width - 1) {
                            if (labelledDetection[z6][y * width + x] == i) {
                                region[z6][y * width + x] = 1;
                                xCurrentRegionList.add(x);
                                yCurrentRegionList.add(y);
                                zCurrentRegionList.add(z6);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z6;
                }
                Point4D[] ptList = new Point4D[xCurrentRegionList.size()];
                int p = 0;
                while (p < xCurrentRegionList.size()) {
                    Point4D.Integer pt = new Point4D.Integer(((Integer)xCurrentRegionList.get(p)).intValue(), ((Integer)yCurrentRegionList.get(p)).intValue(), ((Integer)zCurrentRegionList.get(p)).intValue(), currentFrame);
                    ptList[p] = pt;
                    ++p;
                }
                BooleanMask4D currentRegion = new BooleanMask4D(ptList);
                ROI4DArea currentRoi = new ROI4DArea(currentRegion);
                objectROIs.add((Object[])new ROI[]{currentRoi});
                ++i;
            }
            ++currentFrame;
        }
    }

    void segmentedVesiclesROIs3D(int[][][] detection, VarROIArray objectROIs, int width, int height, int depth, int nbFrames) {
        int currentFrame = 0;
        while (currentFrame < nbFrames) {
            int i;
            int[][] labelledDetection = new int[depth][width * height];
            int[][] vesicleContour = new int[depth][width * height];
            int z = 0;
            while (z < depth) {
                int i2 = 0;
                while (i2 < width * height) {
                    if (detection[currentFrame][z][i2] > 0) {
                        labelledDetection[z][i2] = detection[currentFrame][z][i2];
                    }
                    ++i2;
                }
                ++z;
            }
            int currentLabel = 1;
            int z2 = 0;
            while (z2 < depth) {
                int y = 1;
                while (y < height - 1) {
                    int x = 1;
                    while (x < width - 1) {
                        if (detection[currentFrame][z2][y * width + x] > 0) {
                            if (labelledDetection[z2][y * width + x] == detection[currentFrame][z2][y * width + x]) {
                                labelledDetection[z2][y * width + x] = ++currentLabel;
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            } else {
                                if (labelledDetection[z2][(y - 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y - 1) * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x] = currentLabel;
                                }
                                if (labelledDetection[z2][y * width + x + 1] == 1) {
                                    labelledDetection[z2][y * width + x + 1] = currentLabel;
                                }
                                if (labelledDetection[z2][(y + 1) * width + x + 1] == 1) {
                                    labelledDetection[z2][(y + 1) * width + x + 1] = currentLabel;
                                }
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            boolean change = true;
            while (change) {
                change = false;
                int z3 = 0;
                while (z3 < depth) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            if (labelledDetection[z3][y * width + x] > 0) {
                                int w = -1;
                                while (w <= 1) {
                                    int v = -1;
                                    while (v <= 1) {
                                        int u = -1;
                                        while (u <= 1) {
                                            if (x + u >= 0 && x + u < width && y + v >= 0 && y + v < height && z3 + w >= 0 && z3 + w < depth && labelledDetection[z3 + w][(y + v) * width + x + u] > 0 && labelledDetection[z3 + w][(y + v) * width + x + u] != labelledDetection[z3][y * width + x]) {
                                                int minLabel;
                                                change = true;
                                                labelledDetection[z3 + w][(y + v) * width + x + u] = minLabel = Math.min(labelledDetection[z3 + w][(y + v) * width + x + u], labelledDetection[z3][y * width + x]);
                                                labelledDetection[z3][y * width + x] = minLabel;
                                            }
                                            ++u;
                                        }
                                        ++v;
                                    }
                                    ++w;
                                }
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z3;
                }
            }
            int[] labelTable = new int[currentLabel + 1];
            int z4 = 0;
            while (z4 < depth) {
                i = 0;
                while (i < width * height) {
                    if (labelledDetection[z4][i] > 0) {
                        labelTable[labelledDetection[z4][i]] = 1;
                    }
                    ++i;
                }
                ++z4;
            }
            int newLabel = 1;
            i = 0;
            while (i < currentLabel + 1) {
                if (labelTable[i] > 0) {
                    labelTable[i] = newLabel++;
                }
                ++i;
            }
            int z5 = 0;
            while (z5 < depth) {
                int i3 = 0;
                while (i3 < width * height) {
                    if (labelledDetection[z5][i3] > 0) {
                        labelledDetection[z5][i3] = labelTable[labelledDetection[z5][i3]];
                    }
                    ++i3;
                }
                ++z5;
            }
            i = 1;
            while (i < newLabel) {
                int[][] region = new int[depth][width * height];
                int[][] maskC = new int[depth][width * height];
                ArrayList<Integer> xCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> yCurrentRegionList = new ArrayList<Integer>();
                ArrayList<Integer> zCurrentRegionList = new ArrayList<Integer>();
                int z6 = 0;
                while (z6 < depth) {
                    int y = 1;
                    while (y < height - 1) {
                        int x = 1;
                        while (x < width - 1) {
                            if (labelledDetection[z6][y * width + x] == i) {
                                region[z6][y * width + x] = 1;
                                xCurrentRegionList.add(x);
                                yCurrentRegionList.add(y);
                                zCurrentRegionList.add(z6);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z6;
                }
                Point3D[] ptList = new Point3D[xCurrentRegionList.size()];
                int p = 0;
                while (p < xCurrentRegionList.size()) {
                    Point3D.Integer pt = new Point3D.Integer(((Integer)xCurrentRegionList.get(p)).intValue(), ((Integer)yCurrentRegionList.get(p)).intValue(), ((Integer)zCurrentRegionList.get(p)).intValue());
                    ptList[p] = pt;
                    ++p;
                }
                BooleanMask3D currentRegion = new BooleanMask3D(ptList);
                ROI3DArea currentRoi = new ROI3DArea(currentRegion);
                currentRoi.setT(currentFrame);
                objectROIs.add((Object[])new ROI[]{currentRoi});
                ++i;
            }
            ++currentFrame;
        }
    }

    public static Point5D getMassCenter(ROI roi) {
        switch (roi.getDimension()) {
            case 2: {
                ROI2D roi2d = (ROI2D)roi;
                Point2D pt2d = CCRAFT.getMassCenter(roi2d);
                return new Point5D.Double(pt2d.getX(), pt2d.getY(), (double)roi2d.getZ(), (double)roi2d.getT(), (double)roi2d.getC());
            }
            case 3: {
                ROI3D roi3d = (ROI3D)roi;
                Point3D pt3d = CCRAFT.getMassCenter(roi3d);
                return new Point5D.Double(pt3d.getX(), pt3d.getY(), pt3d.getZ(), (double)roi3d.getT(), (double)roi3d.getC());
            }
            case 4: {
                ROI4D roi4d = (ROI4D)roi;
                Point4D pt4d = CCRAFT.getMassCenter(roi4d);
                return new Point5D.Double(pt4d.getX(), pt4d.getY(), pt4d.getZ(), pt4d.getT(), (double)roi4d.getC());
            }
            case 5: {
                return CCRAFT.getMassCenter((ROI5D)roi);
            }
        }
        return null;
    }

    public static Point2D getMassCenter(ROI2D roi) {
        double x = 0.0;
        double y = 0.0;
        long len = 0L;
        BooleanMask2D mask = roi.getBooleanMask(true);
        boolean[] m = mask.mask;
        int h = mask.bounds.height;
        int w = mask.bounds.width;
        int off = 0;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (m[off++]) {
                    x += (double)i;
                    y += (double)j;
                    ++len;
                }
                ++i;
            }
            ++j;
        }
        Rectangle2D bounds2D = roi.getBounds2D();
        if (len == 0L) {
            return new Point2D.Double(bounds2D.getCenterX(), bounds2D.getCenterY());
        }
        return new Point2D.Double(bounds2D.getX() + x / (double)len, bounds2D.getY() + y / (double)len);
    }

    public static Point3D getMassCenter(ROI3D roi) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        long len = 0L;
        BooleanMask3D mask3d = roi.getBooleanMask(true);
        for (Integer zSlice : mask3d.mask.keySet()) {
            int zi = zSlice;
            double zd = zi;
            BooleanMask2D mask = mask3d.getMask2D(zi);
            boolean[] m = mask.mask;
            double bx = mask.bounds.x;
            double by = mask.bounds.y;
            int h = mask.bounds.height;
            int w = mask.bounds.width;
            int off = 0;
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    if (m[off++]) {
                        x += bx + (double)i;
                        y += by + (double)j;
                        z += zd;
                        ++len;
                    }
                    ++i;
                }
                ++j;
            }
        }
        Rectangle3D bounds3D = roi.getBounds3D();
        if (len == 0L) {
            return new Point3D.Double(bounds3D.getCenterX(), bounds3D.getCenterY(), bounds3D.getCenterZ());
        }
        return new Point3D.Double(x / (double)len, y / (double)len, z / (double)len);
    }

    public static Point4D getMassCenter(ROI4D roi) {
        BooleanMask4D mask4d = roi.getBooleanMask(true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        long len = 0L;
        for (Integer tFrame : mask4d.mask.keySet()) {
            int ti = tFrame;
            double td = ti;
            BooleanMask3D mask3d = mask4d.getMask3D(ti);
            for (Integer zSlice : mask3d.mask.keySet()) {
                int zi = zSlice;
                double zd = zi;
                BooleanMask2D mask = mask3d.getMask2D(zi);
                boolean[] m = mask.mask;
                double bx = mask.bounds.x;
                double by = mask.bounds.y;
                int h = mask.bounds.height;
                int w = mask.bounds.width;
                int off = 0;
                int j = 0;
                while (j < h) {
                    int i = 0;
                    while (i < w) {
                        if (m[off++]) {
                            x += bx + (double)i;
                            y += by + (double)j;
                            z += zd;
                            t += td;
                            ++len;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        Rectangle4D bounds4D = roi.getBounds4D();
        if (len == 0L) {
            return new Point4D.Double(bounds4D.getCenterX(), bounds4D.getCenterY(), bounds4D.getCenterZ(), bounds4D.getCenterT());
        }
        return new Point4D.Double(x / (double)len, y / (double)len, z / (double)len, t / (double)len);
    }

    public static Point5D getMassCenter(ROI5D roi) {
        BooleanMask5D mask5d = roi.getBooleanMask(true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        double c = 0.0;
        long len = 0L;
        for (Integer cChannel : mask5d.mask.keySet()) {
            int ci = cChannel;
            double cd = ci;
            BooleanMask4D mask4d = mask5d.getMask4D(ci);
            for (Integer tFrame : mask4d.mask.keySet()) {
                int ti = tFrame;
                double td = ti;
                BooleanMask3D mask3d = mask4d.getMask3D(ti);
                for (Integer zSlice : mask3d.mask.keySet()) {
                    int zi = zSlice;
                    double zd = zi;
                    BooleanMask2D mask = mask3d.getMask2D(zi);
                    boolean[] m = mask.mask;
                    double bx = mask.bounds.x;
                    double by = mask.bounds.y;
                    int h = mask.bounds.height;
                    int w = mask.bounds.width;
                    int off = 0;
                    int j = 0;
                    while (j < h) {
                        int i = 0;
                        while (i < w) {
                            if (m[off++]) {
                                x += bx + (double)i;
                                y += by + (double)j;
                                z += zd;
                                t += td;
                                c += cd;
                                ++len;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        Rectangle5D bounds5D = roi.getBounds5D();
        if (len == 0L) {
            return new Point5D.Double(bounds5D.getCenterX(), bounds5D.getCenterY(), bounds5D.getCenterZ(), bounds5D.getCenterT(), bounds5D.getCenterC());
        }
        return new Point5D.Double(x / (double)len, y / (double)len, z / (double)len, t / (double)len, c / (double)len);
    }

    void addSegmentedParticlesToSwimmingPool(VarROIArray outputROIs, VarSequence objectComponent) {
        DetectionResult dr = new DetectionResult();
        int i = 0;
        while (i < outputROIs.size()) {
            Spot spot = new Spot();
            Point5D pt = CCRAFT.getMassCenter(((ROI[])outputROIs.getValue())[i]);
            spot.mass_center.x = pt.getX();
            spot.mass_center.y = pt.getY();
            spot.mass_center.z = pt.getZ();
            spot.meanIntensity = ROIUtil.getMeanIntensity((Sequence)((Sequence)objectComponent.getValue()), (ROI)((ROI[])outputROIs.getValue())[i]);
            spot.minIntensity = ROIUtil.getMinIntensity((Sequence)((Sequence)objectComponent.getValue()), (ROI)((ROI[])outputROIs.getValue())[i]);
            spot.maxIntensity = ROIUtil.getMaxIntensity((Sequence)((Sequence)objectComponent.getValue()), (ROI)((ROI[])outputROIs.getValue())[i]);
            dr.addDetection((int)((ROI[])outputROIs.getValue())[i].getPosition5D().getT(), spot);
            ++i;
        }
        Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)dr, "Detection results from C-CRAFT"));
    }

    void visualizeImage(float[][][] input, int width, int height, int depth, int currentFrame, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int z = 0;
            while (z < depth) {
                IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.FLOAT);
                float[] outputData = outputImage.getDataXYAsFloat(0);
                int i = 0;
                while (i < width * height) {
                    outputData[i] = input[currentFrame][z][i];
                    ++i;
                }
                outputImage.dataChanged();
                test.setImage(currentFrame, z, (BufferedImage)outputImage);
                ++z;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void visualizeImage(int[][][] input, int width, int height, int depth, int currentFrame, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int z = 0;
            while (z < depth) {
                IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.INT);
                int[] outputData = outputImage.getDataXYAsInt(0);
                int i = 0;
                while (i < width * height) {
                    outputData[i] = input[currentFrame][z][i];
                    ++i;
                }
                outputImage.dataChanged();
                test.setImage(currentFrame, z, (BufferedImage)outputImage);
                ++z;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void visualizeImage(float[][] input, int width, int height, int depth, int currentFrame, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int z = 0;
            while (z < depth) {
                IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.FLOAT);
                float[] outputData = outputImage.getDataXYAsFloat(0);
                int i = 0;
                while (i < width * height) {
                    outputData[i] = input[z][i];
                    ++i;
                }
                outputImage.dataChanged();
                test.setImage(currentFrame, z, (BufferedImage)outputImage);
                ++z;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void visualizeImage(int[][] input, int width, int height, int depth, int currentFrame, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int z = 0;
            while (z < depth) {
                IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.INT);
                int[] outputData = outputImage.getDataXYAsInt(0);
                int i = 0;
                while (i < width * height) {
                    outputData[i] = input[z][i];
                    ++i;
                }
                outputImage.dataChanged();
                test.setImage(currentFrame, z, (BufferedImage)outputImage);
                ++z;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void visualizeSequence(float[][][] input, int width, int height, int depth, int nbFrames, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int t = 0;
            while (t < nbFrames) {
                int z = 0;
                while (z < depth) {
                    IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.FLOAT);
                    float[] outputData = outputImage.getDataXYAsFloat(0);
                    int i = 0;
                    while (i < width * height) {
                        outputData[i] = input[t][z][i];
                        ++i;
                    }
                    outputImage.dataChanged();
                    test.setImage(t, z, (BufferedImage)outputImage);
                    ++z;
                }
                ++t;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void visualizeSequence(int[][][] input, int width, int height, int depth, int nbFrames, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int t = 0;
            while (t < nbFrames) {
                int z = 0;
                while (z < depth) {
                    IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.INT);
                    int[] outputData = outputImage.getDataXYAsInt(0);
                    int i = 0;
                    while (i < width * height) {
                        outputData[i] = input[t][z][i];
                        ++i;
                    }
                    outputImage.dataChanged();
                    test.setImage(t, z, (BufferedImage)outputImage);
                    ++z;
                }
                ++t;
            }
        }
        finally {
            test.endUpdate();
        }
        this.addSequence(test);
    }

    void writeImage(float[][][] input, VarSequence output, int width, int height, int depth, int nbFrames, String name) {
        Sequence test = new Sequence(name);
        test.beginUpdate();
        try {
            int t = 0;
            while (t < nbFrames) {
                int z = 0;
                while (z < depth) {
                    IcyBufferedImage outputImage = new IcyBufferedImage(width, height, 1, DataType.FLOAT);
                    float[] outputData = outputImage.getDataXYAsFloat(0);
                    int i = 0;
                    while (i < width * height) {
                        outputData[i] = input[t][z][i];
                        ++i;
                    }
                    outputImage.dataChanged();
                    test.setImage(t, z, (BufferedImage)outputImage);
                    ++z;
                }
                ++t;
            }
        }
        finally {
            test.endUpdate();
        }
        output.setValue(test);
    }

    protected void initialize() {
        this.getUI().setParametersIOVisible(false);
        this.inPlaneNeighborhoodSize.setToolTipText("Related to PSNR, must be an odd multiple of XY patch side length");
        this.inPlanePatchSize.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                int i = newValue;
                CCRAFT.this.inPlaneNeighborhoodSize.setMinValue((Comparable)new Integer(i * i));
                CCRAFT.this.inPlaneNeighborhoodSize.setMaxValue((Comparable)new Integer(i * i * i));
                CCRAFT.this.inPlaneNeighborhoodSize.setValue((Object)new Integer(i * i));
                CCRAFT.this.inPlaneNeighborhoodSize.setStep((Number)new Integer(2 * i));
            }
        });
        this.inPlanePatchSize.setToolTipText("Related to the object size, must be an odd number");
        this.axialNeighborhoodSize.setValue((Object)new Integer(3));
        this.axialNeighborhoodSize.setToolTipText("Same parameter than \"XY patch neighborhood size\" in the Z direction");
        this.axialPatchSize.addVarChangeListener((EzVarListener)new EzVarListener<Integer>(){

            public void variableChanged(EzVar<Integer> source, Integer newValue) {
                int i = newValue;
                if (i == 1) {
                    CCRAFT.this.axialNeighborhoodSize.setMinValue((Comparable)new Integer(1));
                    CCRAFT.this.axialNeighborhoodSize.setMaxValue((Comparable)new Integer(15));
                    CCRAFT.this.axialNeighborhoodSize.setValue((Object)new Integer(3));
                    CCRAFT.this.axialNeighborhoodSize.setStep((Number)new Integer(2));
                } else {
                    CCRAFT.this.axialNeighborhoodSize.setMinValue((Comparable)new Integer(i * i));
                    CCRAFT.this.axialNeighborhoodSize.setMaxValue((Comparable)new Integer(i * i * i));
                    CCRAFT.this.axialNeighborhoodSize.setValue((Object)new Integer(i * i));
                    CCRAFT.this.axialNeighborhoodSize.setStep((Number)new Integer(2 * i));
                }
            }
        });
        this.axialPatchSize.setToolTipText("Same parameter than \"XY patch size\" in the Z direction");
        this.inputSequence.setToolTipText("Input image");
        this.pval.setToolTipText("p-value used for thresholding in the detection discriminative potential, the higher the p-value is, the more objects are segmented (defined between 0 and 1)");
        this.patchParameters.setToolTipText("Show/hide patch parameters");
        this.sReg.setToolTipText("Coefficient value for spatial regularization potential, the higher this value is, the smoother the segmented objects are (defined between 0 and 1)");
        this.backgroundReg.setToolTipText("Importance of the difference between the estimated background and the image in the segmentation process");
        this.interpolationMethod.setToolTipText("Interpolation method for background estimation, if the photobleaching is barely noticeable, choose temporal interpolation");
        this.energyAdvancedParameters.setToolTipText("Show/hide advanced energy parameters");
        this.energyAdvancedParameters.addVisibilityTriggerTo((EzComponent)this.sReg, (Object[])new Boolean[]{true});
        this.energyAdvancedParameters.addVisibilityTriggerTo((EzComponent)this.backgroundReg, (Object[])new Boolean[]{true});
        this.energyAdvancedParameters.addVisibilityTriggerTo((EzComponent)this.interpolationMethod, (Object[])new Boolean[]{true});
        this.patchParameters.addVisibilityTriggerTo((EzComponent)this.inPlanePatchSize, (Object[])new Boolean[]{true});
        this.patchParameters.addVisibilityTriggerTo((EzComponent)this.inPlaneNeighborhoodSize, (Object[])new Boolean[]{true});
        this.patchParameters.addVisibilityTriggerTo((EzComponent)this.axialPatchSize, (Object[])new Boolean[]{true});
        this.patchParameters.addVisibilityTriggerTo((EzComponent)this.axialNeighborhoodSize, (Object[])new Boolean[]{true});
        this.interpolationMethod.addVisibilityTriggerTo((EzComponent)this.nbTemporalIterations, (Object[])new String[]{"Temporal"});
        this.objectComponentOut.setToolTipText("Export object component image in Icy");
        this.backgroundComponentOut.setToolTipText("Export background component image in Icy");
        this.ROIsOut.setToolTipText("Add object segmented ROIs on the input image");
        this.particleCentersToSwimmingPool.setToolTipText("Export particle mass centers to the swimming-pool (to apply tracking for example)");
        EzGroup energyRelatedParameters = new EzGroup("Energy parameters", new EzComponent[]{this.pval, this.energyAdvancedParameters, this.backgroundReg, this.sReg, this.interpolationMethod, this.nbTemporalIterations});
        EzGroup patchRelatedParameters = new EzGroup("Patch parameters", new EzComponent[]{this.patchParameters, this.inPlanePatchSize, this.inPlaneNeighborhoodSize, this.axialPatchSize, this.axialNeighborhoodSize});
        EzGroup outputParameters = new EzGroup("Output", new EzComponent[]{this.objectComponentOut, this.backgroundComponentOut, this.ROIsOut, this.particleCentersToSwimmingPool});
        this.addEzComponent((EzComponent)this.inputSequence);
        super.addEzComponent((EzComponent)energyRelatedParameters);
        super.addEzComponent((EzComponent)patchRelatedParameters);
        super.addEzComponent((EzComponent)outputParameters);
    }

    protected void execute() {
        int z;
        Sequence input = (Sequence)this.inputSequence.getValue();
        if (input == null) {
            MessageDialog.showDialog((String)"This plugin needs an input sequence");
            return;
        }
        if (((Float)this.pval.getValue()).floatValue() < 0.0f || ((Float)this.pval.getValue()).floatValue() > 1.0f) {
            MessageDialog.showDialog((String)"The p-value must be defined between 0 and 1");
            return;
        }
        if (((Float)this.sReg.getValue()).floatValue() < 0.0f || ((Float)this.sReg.getValue()).floatValue() > 1.0f) {
            MessageDialog.showDialog((String)"The coefficient value for spatial regularization potential must be defined between 0 and 1");
            return;
        }
        if (((Float)this.backgroundReg.getValue()).floatValue() < 0.0f || ((Float)this.backgroundReg.getValue()).floatValue() > 1.0f) {
            MessageDialog.showDialog((String)"The coefficient value for background potential must be defined between 0 and 1");
            return;
        }
        if ((Integer)this.nbTemporalIterations.getValue() < 2 || (Integer)this.nbTemporalIterations.getValue() > 10) {
            MessageDialog.showDialog((String)"The number of temporal iterations must be defined between 2 and 10");
            return;
        }
        if ((Integer)this.inPlanePatchSize.getValue() % 2 == 0) {
            MessageDialog.showDialog((String)"XY patch size must be an odd number");
            return;
        }
        if ((Integer)this.inPlaneNeighborhoodSize.getValue() % (Integer)this.inPlanePatchSize.getValue() != 0) {
            MessageDialog.showDialog((String)"XY patch neighborhood size must be a multiple of XY patch size");
            return;
        }
        if ((Integer)this.inPlaneNeighborhoodSize.getValue() % 2 == 0) {
            MessageDialog.showDialog((String)"XY patch neighborhood size must be an odd number");
            return;
        }
        if (input.getSizeZ() > 0) {
            if ((Integer)this.axialPatchSize.getValue() % 2 == 0) {
                MessageDialog.showDialog((String)"Z patch size must be an odd number");
                return;
            }
            if ((Integer)this.axialNeighborhoodSize.getValue() % (Integer)this.axialPatchSize.getValue() != 0) {
                MessageDialog.showDialog((String)"Z patch neighborhood size must be a multiple of Z patch side length");
                return;
            }
            if ((Integer)this.axialNeighborhoodSize.getValue() % 2 == 0) {
                MessageDialog.showDialog((String)"Z patch neighborhood size must be an odd number");
                return;
            }
        }
        if (!super.isHeadLess()) {
            super.getUI().setProgressBarMessage("Detection measure computation");
            this.detectionSemaphore.init(0, input.getSizeT());
            super.getUI().setProgressBarValue((double)this.detectionSemaphore.getProgress());
            Thread.yield();
        }
        this.objectComponent = new VarSequence("objectComponent", null);
        this.backgroundComponent = new VarSequence("backgroundComponent", null);
        this.outputROIs = new VarROIArray("outputROIs");
        if (((Boolean)this.ROIsOut.getValue()).booleanValue()) {
            input.removeAllROI();
        }
        float[] threshold = new float[input.getSizeT()];
        int arraySize = input.getSizeX() * input.getSizeY();
        float[][][] detectionMeasure = new float[input.getSizeT()][input.getSizeZ()][arraySize];
        int t = 0;
        while (t < input.getSizeT()) {
            if (this.stopRunningBgProcess) {
                this.stopRunningBgProcess = false;
                return;
            }
            float[][] inputData = Array2DUtil.arrayToFloatArray((Object)input.getDataXYZ(t, 0), (boolean)input.isSignedDataType());
            if (input.getSizeZ() == 1) {
                float[] residuG = this.PseudoResidu(inputData, input.getSizeX(), input.getSizeY(), t);
                float sig = this.SigmaLTS(residuG, input.getSizeX() * input.getSizeY());
                this.detectionMeasureComputation(inputData, detectionMeasure, t, input.getSizeX(), input.getSizeY(), input.getSizeZ(), (Integer)this.inPlanePatchSize.getValue(), 1, (Integer)this.inPlaneNeighborhoodSize.getValue(), 1, sig);
            } else {
                this.detectionMeasureComputation(inputData, detectionMeasure, t, input.getSizeX(), input.getSizeY(), input.getSizeZ(), (Integer)this.inPlanePatchSize.getValue(), (Integer)this.axialPatchSize.getValue(), (Integer)this.inPlaneNeighborhoodSize.getValue(), (Integer)this.axialNeighborhoodSize.getValue(), 1.0f);
            }
            threshold[t] = this.chebyshevThresholdingMethod(detectionMeasure, t, ((Float)this.pval.getValue()).floatValue(), input.getSizeZ(), arraySize);
            if (!super.isHeadLess()) {
                this.detectionSemaphore.progress();
                super.getUI().setProgressBarValue((double)this.detectionSemaphore.getProgress());
            }
            Thread.yield();
            ++t;
        }
        float[][][] class1 = new float[input.getSizeT()][input.getSizeZ()][arraySize];
        float[][][] class2 = new float[input.getSizeT()][input.getSizeZ()][arraySize];
        int t2 = 0;
        while (t2 < input.getSizeT()) {
            int z2 = 0;
            while (z2 < input.getSizeZ()) {
                int i = 0;
                while (i < arraySize) {
                    class1[t2][z2][i] = (float)(1.0 / (1.0 + Math.exp((threshold[t2] - detectionMeasure[t2][z2][i]) / threshold[t2])));
                    class2[t2][z2][i] = (float)(1.0 / (1.0 + Math.exp((detectionMeasure[t2][z2][i] - threshold[t2]) / threshold[t2])));
                    ++i;
                }
                ++z2;
            }
            ++t2;
        }
        threshold = null;
        detectionMeasure = null;
        this.detectionData = new int[input.getSizeT()][input.getSizeZ()][arraySize];
        this.objectData = new float[input.getSizeT()][input.getSizeZ()][arraySize];
        this.backgroundData = new float[input.getSizeT()][input.getSizeZ()][arraySize];
        if (!super.isHeadLess()) {
            if (this.interpolationMethod.getValue() == "Spatial") {
                this.optimizationSemaphore.init(0, 2 * input.getSizeT());
            } else {
                this.optimizationSemaphore.init(0, (Integer)this.nbTemporalIterations.getValue() * input.getSizeT());
            }
            super.getUI().setProgressBarValue((double)this.optimizationSemaphore.getProgress());
            Thread.yield();
            super.getUI().setProgressBarMessage("Energy minimization and interpolation");
        }
        if (this.interpolationMethod.getValue() == "Spatial") {
            int i;
            int v;
            int x;
            int y;
            int z3;
            float sRegReal;
            GraphCut graphCut;
            int nbEdges;
            int nbNodes;
            int[][] detectionMemory;
            float[][] inputData;
            int iteration;
            float detectionDifference;
            t2 = 0;
            while (t2 < input.getSizeT()) {
                if (this.stopRunningBgProcess) {
                    this.stopRunningBgProcess = false;
                    return;
                }
                detectionDifference = 1.0f;
                iteration = 0;
                inputData = Array2DUtil.arrayToFloatArray((Object)input.getDataXYZ(t2, 0), (boolean)input.isSignedDataType());
                detectionMemory = new int[input.getSizeZ()][input.getSizeX() * input.getSizeY()];
                while ((double)detectionDifference > 0.01 && iteration <= 0) {
                    nbNodes = input.getSizeX() * input.getSizeY() * input.getSizeZ();
                    nbEdges = 0;
                    nbEdges = input.getSizeZ() == 1 ? 4 * input.getSizeX() * input.getSizeY() - 2 * (input.getSizeX() + input.getSizeY()) : 13 * input.getSizeX() * input.getSizeY() * input.getSizeZ() - 2 * (input.getSizeX() + input.getSizeY() + input.getSizeZ());
                    graphCut = new GraphCut(nbNodes, nbEdges);
                    sRegReal = 0.0f;
                    sRegReal = input.getSizeZ() == 1 ? ((Float)this.sReg.getValue()).floatValue() / 8.0f : ((Float)this.sReg.getValue()).floatValue() / 26.0f;
                    z3 = 0;
                    while (z3 < input.getSizeZ()) {
                        y = 1;
                        while (y < input.getSizeY() - 1) {
                            x = 1;
                            while (x < input.getSizeX() - 1) {
                                graphCut.setTerminalWeights(z3 * input.getSizeX() * input.getSizeY() + y * input.getSizeX() + x, (float)((double)class1[t2][z3][y * input.getSizeX() + x] + (double)((Float)this.backgroundReg.getValue()).floatValue() * 2.0 * (1.0 / (1.0 + Math.exp(-Math.pow(inputData[z3][y * input.getSizeX() + x] - this.backgroundData[t2][z3][y * input.getSizeX() + x], 2.0))) - 0.5)), class2[t2][z3][y * input.getSizeX() + x]);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                if (z3 < input.getSizeZ() - 1) {
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x - 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z3;
                    }
                    graphCut.computeMaximumFlow(false, null);
                    v = 0;
                    while (v < nbNodes - 2) {
                        z = v / arraySize;
                        if (graphCut.getTerminal(v) == Terminal.FOREGROUND) {
                            this.detectionData[t2][z][v - z * arraySize] = 1;
                            if (t2 > 0 && this.detectionData[t2 - 1][z][v - z * arraySize] == 0) {
                                this.backgroundData[t2][z][v - z * arraySize] = this.backgroundData[t2 - 1][z][v - z * arraySize];
                            }
                        } else {
                            this.detectionData[t2][z][v - z * arraySize] = 0;
                            this.backgroundData[t2][z][v - z * arraySize] = inputData[z][v - z * arraySize];
                        }
                        ++v;
                    }
                    graphCut = null;
                    this.spatialInterpolation(this.detectionData, inputData, this.objectData, this.backgroundData, input.getSizeX(), input.getSizeY(), input.getSizeZ(), t2);
                    if (iteration > 0) {
                        detectionDifference = 0.0f;
                        z3 = 0;
                        while (z3 < input.getSizeZ()) {
                            i = 0;
                            while (i < arraySize) {
                                detectionDifference += (float)Math.abs(this.detectionData[t2][z3][i] - detectionMemory[z3][i]);
                                detectionMemory[z3][i] = this.detectionData[t2][z3][i];
                                ++i;
                            }
                            ++z3;
                        }
                    }
                    ++iteration;
                }
                if (!super.isHeadLess()) {
                    this.optimizationSemaphore.progress();
                    super.getUI().setProgressBarValue((double)this.optimizationSemaphore.getProgress());
                    Thread.yield();
                }
                detectionMemory = null;
                ++t2;
            }
            t2 = input.getSizeT() - 1;
            while (t2 >= 0) {
                if (this.stopRunningBgProcess) {
                    this.stopRunningBgProcess = false;
                    return;
                }
                detectionDifference = 1.0f;
                iteration = 0;
                inputData = Array2DUtil.arrayToFloatArray((Object)input.getDataXYZ(t2, 0), (boolean)input.isSignedDataType());
                detectionMemory = new int[input.getSizeZ()][input.getSizeX() * input.getSizeY()];
                while ((double)detectionDifference > 0.01 && iteration <= 0) {
                    nbNodes = input.getSizeX() * input.getSizeY() * input.getSizeZ();
                    nbEdges = 0;
                    nbEdges = input.getSizeZ() == 1 ? 4 * input.getSizeX() * input.getSizeY() - 2 * (input.getSizeX() + input.getSizeY()) : 13 * input.getSizeX() * input.getSizeY() * input.getSizeZ() - 2 * (input.getSizeX() + input.getSizeY() + input.getSizeZ());
                    graphCut = new GraphCut(nbNodes, nbEdges);
                    sRegReal = 0.0f;
                    sRegReal = input.getSizeZ() == 1 ? ((Float)this.sReg.getValue()).floatValue() / 8.0f : ((Float)this.sReg.getValue()).floatValue() / 26.0f;
                    z3 = 0;
                    while (z3 < input.getSizeZ()) {
                        y = 1;
                        while (y < input.getSizeY() - 1) {
                            x = 1;
                            while (x < input.getSizeX() - 1) {
                                graphCut.setTerminalWeights(z3 * input.getSizeX() * input.getSizeY() + y * input.getSizeX() + x, (float)((double)class1[t2][z3][y * input.getSizeX() + x] + (double)((Float)this.backgroundReg.getValue()).floatValue() * 2.0 * (1.0 / (1.0 + Math.exp(-Math.pow(inputData[z3][y * input.getSizeX() + x] - this.backgroundData[t2][z3][y * input.getSizeX() + x], 2.0))) - 0.5)), class2[t2][z3][y * input.getSizeX() + x]);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, z3 * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                if (z3 < input.getSizeZ() - 1) {
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + y * input.getSizeX() + x - 1, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                    graphCut.setEdgeWeight(z3 * arraySize + y * input.getSizeX() + x, (z3 + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++z3;
                    }
                    graphCut.computeMaximumFlow(false, null);
                    v = 0;
                    while (v < nbNodes - 2) {
                        z = v / arraySize;
                        if (graphCut.getTerminal(v) == Terminal.FOREGROUND) {
                            this.detectionData[t2][z][v - z * arraySize] = 1;
                            if (t2 > 0 && this.detectionData[t2 - 1][z][v - z * arraySize] == 0) {
                                this.backgroundData[t2][z][v - z * arraySize] = this.backgroundData[t2 - 1][z][v - z * arraySize];
                            }
                        } else {
                            this.detectionData[t2][z][v - z * arraySize] = 0;
                            this.backgroundData[t2][z][v - z * arraySize] = inputData[z][v - z * arraySize];
                        }
                        ++v;
                    }
                    graphCut = null;
                    this.spatialInterpolation(this.detectionData, inputData, this.objectData, this.backgroundData, input.getSizeX(), input.getSizeY(), input.getSizeZ(), t2);
                    if (iteration > 0) {
                        detectionDifference = 0.0f;
                        z3 = 0;
                        while (z3 < input.getSizeZ()) {
                            i = 0;
                            while (i < arraySize) {
                                detectionDifference += (float)Math.abs(this.detectionData[t2][z3][i] - detectionMemory[z3][i]);
                                detectionMemory[z3][i] = this.detectionData[t2][z3][i];
                                ++i;
                            }
                            ++z3;
                        }
                    }
                    ++iteration;
                }
                if (!super.isHeadLess()) {
                    this.optimizationSemaphore.progress();
                    super.getUI().setProgressBarValue((double)this.optimizationSemaphore.getProgress());
                    Thread.yield();
                }
                detectionMemory = null;
                --t2;
            }
        } else {
            int temporalIteration = 0;
            while (temporalIteration < (Integer)this.nbTemporalIterations.getValue()) {
                int t3 = 0;
                while (t3 < input.getSizeT()) {
                    if (this.stopRunningBgProcess) {
                        this.stopRunningBgProcess = false;
                        return;
                    }
                    float detectionDifference = 1.0f;
                    int iteration = 0;
                    float[][] inputData = Array2DUtil.arrayToFloatArray((Object)input.getDataXYZ(t3, 0), (boolean)input.isSignedDataType());
                    int[][] detectionMemory = new int[input.getSizeZ()][input.getSizeX() * input.getSizeY()];
                    while ((double)detectionDifference > 0.01 && iteration <= 0) {
                        int nbNodes = input.getSizeX() * input.getSizeY() * input.getSizeZ();
                        int nbEdges = 0;
                        nbEdges = input.getSizeZ() == 1 ? 4 * input.getSizeX() * input.getSizeY() - 2 * (input.getSizeX() + input.getSizeY()) : 13 * input.getSizeX() * input.getSizeY() * input.getSizeZ() - 2 * (input.getSizeX() + input.getSizeY() + input.getSizeZ());
                        GraphCut graphCut = new GraphCut(nbNodes, nbEdges);
                        float sRegReal = 0.0f;
                        sRegReal = input.getSizeZ() == 1 ? ((Float)this.sReg.getValue()).floatValue() / 8.0f : ((Float)this.sReg.getValue()).floatValue() / 26.0f;
                        z = 0;
                        while (z < input.getSizeZ()) {
                            int y = 1;
                            while (y < input.getSizeY() - 1) {
                                int x = 1;
                                while (x < input.getSizeX() - 1) {
                                    graphCut.setTerminalWeights(z * input.getSizeX() * input.getSizeY() + y * input.getSizeX() + x, (float)((double)class1[t3][z][y * input.getSizeX() + x] + (double)((Float)this.backgroundReg.getValue()).floatValue() * 2.0 * (1.0 / (1.0 + Math.exp(-Math.pow(inputData[z][y * input.getSizeX() + x] - this.backgroundData[t3][z][y * input.getSizeX() + x], 2.0))) - 0.5)), class2[t3][z][y * input.getSizeX() + x]);
                                    graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, z * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, z * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, z * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                    graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, z * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                    if (z < input.getSizeZ() - 1) {
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + y * input.getSizeX() + x + 1, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y - 1) * input.getSizeX() + x + 1, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y + 1) * input.getSizeX() + x + 1, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + y * input.getSizeX() + x, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + y * input.getSizeX() + x - 1, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y + 1) * input.getSizeX() + x, sRegReal);
                                        graphCut.setEdgeWeight(z * arraySize + y * input.getSizeX() + x, (z + 1) * arraySize + (y - 1) * input.getSizeX() + x, sRegReal);
                                    }
                                    ++x;
                                }
                                ++y;
                            }
                            ++z;
                        }
                        graphCut.computeMaximumFlow(false, null);
                        int v = 0;
                        while (v < nbNodes - 2) {
                            int z4 = v / arraySize;
                            if (graphCut.getTerminal(v) == Terminal.FOREGROUND) {
                                this.detectionData[t3][z4][v - z4 * arraySize] = 1;
                                if (t3 > 0 && this.detectionData[t3 - 1][z4][v - z4 * arraySize] == 0) {
                                    this.backgroundData[t3][z4][v - z4 * arraySize] = this.backgroundData[t3 - 1][z4][v - z4 * arraySize];
                                }
                            } else {
                                this.detectionData[t3][z4][v - z4 * arraySize] = 0;
                                this.backgroundData[t3][z4][v - z4 * arraySize] = inputData[z4][v - z4 * arraySize];
                            }
                            ++v;
                        }
                        graphCut = null;
                        this.temporalInterpolation(this.detectionData, inputData, this.objectData, this.backgroundData, arraySize, input.getSizeZ(), input.getSizeT(), t3);
                        if (iteration > 0) {
                            detectionDifference = 0.0f;
                            z = 0;
                            while (z < input.getSizeZ()) {
                                int i = 0;
                                while (i < arraySize) {
                                    detectionDifference += (float)Math.abs(this.detectionData[t3][z][i] - detectionMemory[z][i]);
                                    detectionMemory[z][i] = this.detectionData[t3][z][i];
                                    ++i;
                                }
                                ++z;
                            }
                        }
                        ++iteration;
                    }
                    if (!super.isHeadLess()) {
                        this.optimizationSemaphore.progress();
                        super.getUI().setProgressBarValue((double)this.optimizationSemaphore.getProgress());
                        Thread.yield();
                    }
                    detectionMemory = null;
                    ++t3;
                }
                ++temporalIteration;
            }
        }
        this.writeImage(this.objectData, this.objectComponent, input.getSizeX(), input.getSizeY(), input.getSizeZ(), input.getSizeT(), "Object component");
        this.writeImage(this.backgroundData, this.backgroundComponent, input.getSizeX(), input.getSizeY(), input.getSizeZ(), input.getSizeT(), "Background component");
        this.segmentedVesiclesROIs3D(this.detectionData, this.outputROIs, input.getSizeX(), input.getSizeY(), input.getSizeZ(), input.getSizeT());
        if (((Boolean)this.objectComponentOut.getValue()).booleanValue() && !super.isHeadLess()) {
            this.addSequence((Sequence)this.objectComponent.getValue());
        }
        if (((Boolean)this.backgroundComponentOut.getValue()).booleanValue() && !super.isHeadLess()) {
            this.addSequence((Sequence)this.backgroundComponent.getValue());
        }
        if (((Boolean)this.ROIsOut.getValue()).booleanValue() && !super.isHeadLess()) {
            int i = 0;
            while (i < this.outputROIs.size()) {
                ((Sequence)this.inputSequence.getValue()).addROI(((ROI[])this.outputROIs.getValue())[i]);
                ++i;
            }
        }
        if (((Boolean)this.particleCentersToSwimmingPool.getValue()).booleanValue() && !super.isHeadLess()) {
            this.addSegmentedParticlesToSwimmingPool(this.outputROIs, this.objectComponent);
        }
        class1 = null;
        class2 = null;
        this.detectionData = null;
        this.objectData = null;
        this.backgroundData = null;
    }

    public void stopExecution() {
        this.stopRunningBgProcess = true;
    }

    public void clean() {
        if (!super.isHeadLess()) {
            this.detectionSemaphore = new Semaphore();
            this.optimizationSemaphore = new Semaphore();
        }
        this.stopRunningBgProcess = false;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("inputSequence", (Var)this.inputSequence.getVariable());
        inputMap.add("p-value", this.pval.getVariable());
        inputMap.add("spatialRegularizationTerm", this.sReg.getVariable());
        inputMap.add("backgroundPotentialTerm", this.backgroundReg.getVariable());
        inputMap.add("interpolationMethod", this.interpolationMethod.getVariable());
        inputMap.add("numberOfTemporalIterations", this.nbTemporalIterations.getVariable());
        inputMap.add("inPlanePatchSize", this.inPlanePatchSize.getVariable());
        inputMap.add("inPlanePatchNeighborhood", this.inPlaneNeighborhoodSize.getVariable());
        inputMap.add("axialPatchSize", this.axialPatchSize.getVariable());
        inputMap.add("axialPatchNeighborhood", this.axialNeighborhoodSize.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("objectComponent", (Var)this.objectComponent);
        outputMap.add("backgroundComponent", (Var)this.backgroundComponent);
        outputMap.add("outputROIs", (Var)this.outputROIs);
    }

    public class Graph {
        private int numNodes;
        private int numEdges;
        public static final int NONE = -1;
        public static final int TERMINAL = -2;
        public static final int ORPHAN = -3;
        private int[] firstOutgoings;
        private int[] parents;
        private int[] nextNodes;
        private int[] timestamps;
        private int[] distances;
        private boolean[] inSink;
        private boolean[] marked;
        private boolean[] inChangedList;
        private float[] residualNodeCapacities;
        private int[] heads;
        private int[] nextEdges;
        private int[] sisters;
        private float[] residualEdgeCapacities;

        public Graph(int numNodes, int numEdges) {
            this.numNodes = numNodes;
            this.numEdges = numEdges;
            this.firstOutgoings = new int[numNodes];
            this.parents = new int[numNodes];
            this.nextNodes = new int[numNodes];
            this.timestamps = new int[numNodes];
            this.distances = new int[numNodes];
            this.inSink = new boolean[numNodes];
            this.marked = new boolean[numNodes];
            this.inChangedList = new boolean[numNodes];
            this.residualNodeCapacities = new float[2 * numEdges];
            this.heads = new int[2 * numEdges];
            this.nextEdges = new int[2 * numEdges];
            this.sisters = new int[2 * numEdges];
            this.residualEdgeCapacities = new float[2 * numEdges];
            int i = 0;
            while (i < numNodes) {
                this.firstOutgoings[i] = -1;
                this.parents[i] = -1;
                this.nextNodes[i] = -1;
                this.timestamps[i] = 0;
                this.distances[i] = 0;
                this.inSink[i] = false;
                this.marked[i] = false;
                this.residualNodeCapacities[i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < 2 * numEdges) {
                this.heads[i] = -1;
                this.nextEdges[i] = -1;
                this.sisters[i] = -1;
                this.residualEdgeCapacities[i] = 0.0f;
                ++i;
            }
        }

        public final float getResidualNodeCapacity(int node) {
            return this.residualNodeCapacities[node];
        }

        public final void setResidualNodeCapacity(int node, float capacity) {
            this.residualNodeCapacities[node] = capacity;
        }

        public final float getResidualEdgeCapacity(int edge) {
            return this.residualEdgeCapacities[edge];
        }

        public final void setResidualEdgeCapacity(int edge, float capacity) {
            this.residualEdgeCapacities[edge] = capacity;
        }

        public final int getParent(int node) {
            return this.parents[node];
        }

        public final void setParent(int node, int edge) {
            this.parents[node] = edge;
        }

        public final int getSister(int edge) {
            return this.sisters[edge];
        }

        public final void setSister(int edge, int sister) {
            this.sisters[edge] = sister;
        }

        public final int getNextNode(int node) {
            return this.nextNodes[node];
        }

        public final void setNextNode(int node, int next) {
            this.nextNodes[node] = next;
        }

        public final int getNextEdge(int edge) {
            return this.nextEdges[edge];
        }

        public final void setNextEdge(int edge, int next) {
            this.nextEdges[edge] = next;
        }

        public final int getFirstOutgoing(int node) {
            return this.firstOutgoings[node];
        }

        public final void setFirstOutgoing(int node, int edge) {
            this.firstOutgoings[node] = edge;
        }

        public final int getHead(int edge) {
            return this.heads[edge];
        }

        public final void setHead(int edge, int head) {
            this.heads[edge] = head;
        }

        public final boolean isInSink(int node) {
            return this.inSink[node];
        }

        public final void isInSink(int node, boolean isIn) {
            this.inSink[node] = isIn;
        }

        public final int getTimestamp(int node) {
            return this.timestamps[node];
        }

        public final void setTimestamp(int node, int time) {
            this.timestamps[node] = time;
        }

        public final int getDistance(int node) {
            return this.distances[node];
        }

        public final void setDistance(int node, int distance) {
            this.distances[node] = distance;
        }

        public final boolean isInChangedList(int node) {
            return this.inChangedList[node];
        }

        public final void isInChangedList(int node, boolean isIn) {
            this.inChangedList[node] = isIn;
        }

        public final int getNumNodes() {
            return this.numNodes;
        }

        public final int getNumEdges() {
            return this.numEdges;
        }

        public final boolean isMarked(int node) {
            return this.marked[node];
        }

        public final void isMarked(int node, boolean is) {
            this.marked[node] = is;
        }
    }

    public class GraphCut {
        private Graph graph;
        private int edgeNum;
        private float totalFlow;
        private int maxflowIteration;
        private int[] activeQueueFirst;
        private int[] activeQueueLast;
        private LinkedList<Integer> orphans;
        private int time;

        public GraphCut(int numNodes, int numEdges) {
            this.graph = new Graph(numNodes, numEdges);
            this.edgeNum = 0;
            this.totalFlow = 0.0f;
            this.maxflowIteration = 0;
            this.activeQueueFirst = new int[2];
            this.activeQueueLast = new int[2];
            this.orphans = new LinkedList();
        }

        public void setTerminalWeights(int node, float source, float sink) {
            float delta = this.graph.getResidualNodeCapacity(node);
            if (delta > 0.0f) {
                source += delta;
            } else {
                sink -= delta;
            }
            this.totalFlow += source < sink ? source : sink;
            this.graph.setResidualNodeCapacity(node, source - sink);
        }

        public void setEdgeWeight(int node1, int node2, float weight) {
            this.setEdgeWeight(node1, node2, weight, weight);
        }

        public void setEdgeWeight(int node1, int node2, float weight1to2, float weight2to1) {
            int edge = this.edgeNum++;
            int reverseEdge = this.edgeNum++;
            this.graph.setSister(edge, reverseEdge);
            this.graph.setSister(reverseEdge, edge);
            this.graph.setNextEdge(edge, this.graph.getFirstOutgoing(node1));
            this.graph.setFirstOutgoing(node1, edge);
            this.graph.setNextEdge(reverseEdge, this.graph.getFirstOutgoing(node2));
            this.graph.setFirstOutgoing(node2, reverseEdge);
            this.graph.setHead(edge, node2);
            this.graph.setHead(reverseEdge, node1);
            this.graph.setResidualEdgeCapacity(edge, weight1to2);
            this.graph.setResidualEdgeCapacity(reverseEdge, weight2to1);
        }

        public float computeMaximumFlow(boolean reuseTrees, List<Integer> changedNodes) {
            if (this.maxflowIteration == 0) {
                reuseTrees = false;
            }
            if (reuseTrees) {
                this.maxflowReuseTreesInit();
            } else {
                this.maxflowInit();
            }
            int currentNode = -1;
            int edge = -1;
            block0: while (true) {
                int headNode;
                int activeNode;
                if ((activeNode = currentNode) != -1) {
                    this.graph.setNextNode(activeNode, -1);
                    if (this.graph.getParent(activeNode) == -1) {
                        activeNode = -1;
                    }
                }
                if (activeNode == -1 && (activeNode = this.getNextActiveNode()) == -1) break;
                if (!this.graph.isInSink(activeNode)) {
                    edge = this.graph.getFirstOutgoing(activeNode);
                    while (edge != -1) {
                        if (this.graph.getResidualEdgeCapacity(edge) != 0.0f) {
                            headNode = this.graph.getHead(edge);
                            if (this.graph.getParent(headNode) == -1) {
                                this.graph.isInSink(headNode, false);
                                this.graph.setParent(headNode, this.graph.getSister(edge));
                                this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                                this.setNodeActive(headNode);
                                this.addToChangedList(headNode);
                            } else {
                                if (this.graph.isInSink(headNode)) break;
                                if (this.graph.getTimestamp(headNode) <= this.graph.getTimestamp(activeNode) && this.graph.getDistance(headNode) > this.graph.getDistance(activeNode)) {
                                    this.graph.setParent(headNode, this.graph.getSister(edge));
                                    this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                    this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                                }
                            }
                        }
                        edge = this.graph.getNextEdge(edge);
                    }
                } else {
                    edge = this.graph.getFirstOutgoing(activeNode);
                    while (edge != -1) {
                        if (this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) != 0.0f) {
                            headNode = this.graph.getHead(edge);
                            if (this.graph.getParent(headNode) == -1) {
                                this.graph.isInSink(headNode, true);
                                this.graph.setParent(headNode, this.graph.getSister(edge));
                                this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                                this.setNodeActive(headNode);
                                this.addToChangedList(headNode);
                            } else {
                                if (!this.graph.isInSink(headNode)) {
                                    edge = this.graph.getSister(edge);
                                    break;
                                }
                                if (this.graph.getTimestamp(headNode) <= this.graph.getTimestamp(activeNode) && this.graph.getDistance(headNode) > this.graph.getDistance(activeNode)) {
                                    this.graph.setParent(headNode, this.graph.getSister(edge));
                                    this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                    this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                                }
                            }
                        }
                        edge = this.graph.getNextEdge(edge);
                    }
                }
                ++this.time;
                if (edge != -1) {
                    this.graph.setNextNode(activeNode, activeNode);
                    currentNode = activeNode;
                    this.augment(edge);
                    while (true) {
                        if (this.orphans.size() <= 0) continue block0;
                        int orphan = this.orphans.poll();
                        if (this.graph.isInSink(orphan)) {
                            this.processSinkOrphan(orphan);
                            continue;
                        }
                        this.processSourceOrphan(orphan);
                    }
                }
                currentNode = -1;
            }
            ++this.maxflowIteration;
            if (changedNodes != null) {
                changedNodes.clear();
                int i = 0;
                while (i < this.graph.getNumNodes()) {
                    if (this.graph.isInChangedList(i)) {
                        changedNodes.add(i);
                    }
                    ++i;
                }
            }
            return this.totalFlow;
        }

        public Terminal getTerminal(int node) {
            if (this.graph.getParent(node) != -1) {
                return this.graph.isInSink(node) ? Terminal.BACKGROUND : Terminal.FOREGROUND;
            }
            return Terminal.BACKGROUND;
        }

        public int getNumNodes() {
            return this.graph.getNumNodes();
        }

        public int getNumEdges() {
            return this.graph.getNumEdges();
        }

        public void markNode(int node) {
            if (this.graph.getNextNode(node) == -1) {
                if (this.activeQueueLast[1] != -1) {
                    this.graph.setNextNode(this.activeQueueLast[1], node);
                } else {
                    this.activeQueueFirst[1] = node;
                }
                this.activeQueueLast[1] = node;
                this.graph.setNextNode(node, node);
            }
            this.graph.isMarked(node, true);
        }

        private void setNodeActive(int node) {
            if (this.graph.getNextNode(node) == -1) {
                if (this.activeQueueLast[1] != -1) {
                    this.graph.setNextNode(this.activeQueueLast[1], node);
                } else {
                    this.activeQueueFirst[1] = node;
                }
                this.activeQueueLast[1] = node;
                this.graph.setNextNode(node, node);
            }
        }

        private int getNextActiveNode() {
            int node;
            do {
                if ((node = this.activeQueueFirst[0]) == -1) {
                    node = this.activeQueueFirst[1];
                    this.activeQueueFirst[0] = this.activeQueueFirst[1];
                    this.activeQueueLast[0] = this.activeQueueLast[1];
                    this.activeQueueFirst[1] = -1;
                    this.activeQueueLast[1] = -1;
                    if (node == -1) {
                        return -1;
                    }
                }
                if (this.graph.getNextNode(node) == node) {
                    this.activeQueueFirst[0] = -1;
                    this.activeQueueLast[0] = -1;
                } else {
                    this.activeQueueFirst[0] = this.graph.getNextNode(node);
                }
                this.graph.setNextNode(node, -1);
            } while (this.graph.getParent(node) == -1);
            return node;
        }

        private void addOrphanAtFront(int node) {
            this.graph.setParent(node, -3);
            this.orphans.addFirst(node);
        }

        private void addOrphanAtBack(int node) {
            this.graph.setParent(node, -3);
            this.orphans.addLast(node);
        }

        private void addToChangedList(int node) {
            this.graph.isInChangedList(node, true);
        }

        private void maxflowInit() {
            this.activeQueueFirst[0] = -1;
            this.activeQueueLast[0] = -1;
            this.activeQueueFirst[1] = -1;
            this.activeQueueLast[1] = -1;
            this.orphans.clear();
            this.time = 0;
            int node = 0;
            while (node < this.graph.getNumNodes()) {
                this.graph.setNextNode(node, -1);
                this.graph.isMarked(node, false);
                this.graph.isInChangedList(node, false);
                this.graph.setTimestamp(node, this.time);
                if (this.graph.getResidualNodeCapacity(node) > 0.0f) {
                    this.graph.isInSink(node, false);
                    this.graph.setParent(node, -2);
                    this.setNodeActive(node);
                    this.graph.setDistance(node, 1);
                } else if (this.graph.getResidualNodeCapacity(node) < 0.0f) {
                    this.graph.isInSink(node, true);
                    this.graph.setParent(node, -2);
                    this.setNodeActive(node);
                    this.graph.setDistance(node, 1);
                } else {
                    this.graph.setParent(node, -1);
                }
                ++node;
            }
        }

        private void maxflowReuseTreesInit() {
            int node1;
            int queueStart = this.activeQueueFirst[1];
            this.activeQueueFirst[0] = -1;
            this.activeQueueLast[0] = -1;
            this.activeQueueFirst[1] = -1;
            this.activeQueueLast[1] = -1;
            this.orphans.clear();
            ++this.time;
            while ((node1 = queueStart) != -1) {
                int node2;
                int edge;
                queueStart = this.graph.getNextNode(node1);
                if (queueStart == node1) {
                    queueStart = -1;
                }
                this.graph.setNextNode(node1, -1);
                this.graph.isMarked(node1, false);
                this.setNodeActive(node1);
                if (this.graph.getResidualNodeCapacity(node1) == 0.0f) {
                    if (this.graph.getParent(node1) == -1) continue;
                    this.addOrphanAtBack(node1);
                    continue;
                }
                if (this.graph.getResidualNodeCapacity(node1) > 0.0f) {
                    if (this.graph.getParent(node1) == -1 || this.graph.isInSink(node1)) {
                        this.graph.isInSink(node1, false);
                        edge = this.graph.getFirstOutgoing(node1);
                        while (edge != -1) {
                            node2 = this.graph.getHead(edge);
                            if (!this.graph.isMarked(node2)) {
                                if (this.graph.getParent(node2) == this.graph.getSister(edge)) {
                                    this.addOrphanAtBack(node2);
                                }
                                if (this.graph.getParent(node2) != -1 && this.graph.isInSink(node2) && this.graph.getResidualEdgeCapacity(edge) > 0.0f) {
                                    this.setNodeActive(node2);
                                }
                            }
                            edge = this.graph.getNextEdge(edge);
                        }
                        this.addToChangedList(node1);
                    }
                } else if (this.graph.getParent(node1) == -1 || !this.graph.isInSink(node1)) {
                    this.graph.isInSink(node1, true);
                    edge = this.graph.getFirstOutgoing(node1);
                    while (edge != -1) {
                        node2 = this.graph.getHead(edge);
                        if (!this.graph.isMarked(node2)) {
                            if (this.graph.getParent(node2) == this.graph.getSister(edge)) {
                                this.addOrphanAtBack(node2);
                            }
                            if (this.graph.getParent(node2) != -1 && !this.graph.isInSink(node2) && this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) > 0.0f) {
                                this.setNodeActive(node2);
                            }
                        }
                        edge = this.graph.getNextEdge(edge);
                    }
                    this.addToChangedList(node1);
                }
                this.graph.setParent(node1, -2);
                this.graph.setTimestamp(node1, this.time);
                this.graph.setDistance(node1, 1);
            }
            while (this.orphans.size() > 0) {
                int orphan = this.orphans.poll();
                if (this.graph.isInSink(orphan)) {
                    this.processSinkOrphan(orphan);
                    continue;
                }
                this.processSourceOrphan(orphan);
            }
        }

        private void augment(int middle) {
            int edge;
            float bottleneck = this.graph.getResidualEdgeCapacity(middle);
            int node = this.graph.getHead(this.graph.getSister(middle));
            while ((edge = this.graph.getParent(node)) != -2) {
                if (bottleneck > this.graph.getResidualEdgeCapacity(this.graph.getSister(edge))) {
                    bottleneck = this.graph.getResidualEdgeCapacity(this.graph.getSister(edge));
                }
                node = this.graph.getHead(edge);
            }
            if (bottleneck > this.graph.getResidualNodeCapacity(node)) {
                bottleneck = this.graph.getResidualNodeCapacity(node);
            }
            node = this.graph.getHead(middle);
            while ((edge = this.graph.getParent(node)) != -2) {
                if (bottleneck > this.graph.getResidualEdgeCapacity(edge)) {
                    bottleneck = this.graph.getResidualEdgeCapacity(edge);
                }
                node = this.graph.getHead(edge);
            }
            if (bottleneck > -this.graph.getResidualNodeCapacity(node)) {
                bottleneck = -this.graph.getResidualNodeCapacity(node);
            }
            this.graph.setResidualEdgeCapacity(this.graph.getSister(middle), this.graph.getResidualEdgeCapacity(this.graph.getSister(middle)) + bottleneck);
            this.graph.setResidualEdgeCapacity(middle, this.graph.getResidualEdgeCapacity(middle) - bottleneck);
            node = this.graph.getHead(this.graph.getSister(middle));
            while ((edge = this.graph.getParent(node)) != -2) {
                this.graph.setResidualEdgeCapacity(edge, this.graph.getResidualEdgeCapacity(edge) + bottleneck);
                this.graph.setResidualEdgeCapacity(this.graph.getSister(edge), this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) - bottleneck);
                if (this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) == 0.0f) {
                    this.addOrphanAtFront(node);
                }
                node = this.graph.getHead(edge);
            }
            this.graph.setResidualNodeCapacity(node, this.graph.getResidualNodeCapacity(node) - bottleneck);
            if (this.graph.getResidualNodeCapacity(node) == 0.0f) {
                this.addOrphanAtFront(node);
            }
            node = this.graph.getHead(middle);
            while ((edge = this.graph.getParent(node)) != -2) {
                this.graph.setResidualEdgeCapacity(this.graph.getSister(edge), this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) + bottleneck);
                this.graph.setResidualEdgeCapacity(edge, this.graph.getResidualEdgeCapacity(edge) - bottleneck);
                if (this.graph.getResidualEdgeCapacity(edge) == 0.0f) {
                    this.addOrphanAtFront(node);
                }
                node = this.graph.getHead(edge);
            }
            this.graph.setResidualNodeCapacity(node, this.graph.getResidualNodeCapacity(node) + bottleneck);
            if (this.graph.getResidualNodeCapacity(node) == 0.0f) {
                this.addOrphanAtFront(node);
            }
            this.totalFlow += bottleneck;
        }

        private void processSourceOrphan(int orphan) {
            int parentEdge;
            int node;
            int bestEdge = -1;
            int minDistance = Integer.MAX_VALUE;
            int orphanEdge = this.graph.getFirstOutgoing(orphan);
            while (orphanEdge != -1) {
                if (this.graph.getResidualEdgeCapacity(this.graph.getSister(orphanEdge)) != 0.0f) {
                    node = this.graph.getHead(orphanEdge);
                    parentEdge = this.graph.getParent(node);
                    if (!this.graph.isInSink(node) && parentEdge != -1) {
                        int distance = 0;
                        while (true) {
                            if (this.graph.getTimestamp(node) == this.time) {
                                distance += this.graph.getDistance(node);
                                break;
                            }
                            parentEdge = this.graph.getParent(node);
                            ++distance;
                            if (parentEdge == -2) {
                                this.graph.setTimestamp(node, this.time);
                                this.graph.setDistance(node, 1);
                                break;
                            }
                            if (parentEdge == -3) {
                                distance = Integer.MAX_VALUE;
                                break;
                            }
                            node = this.graph.getHead(parentEdge);
                        }
                        if (distance < Integer.MAX_VALUE) {
                            if (distance < minDistance) {
                                bestEdge = orphanEdge;
                                minDistance = distance;
                            }
                            node = this.graph.getHead(orphanEdge);
                            while (this.graph.getTimestamp(node) != this.time) {
                                this.graph.setTimestamp(node, this.time);
                                this.graph.setDistance(node, distance);
                                --distance;
                                node = this.graph.getHead(this.graph.getParent(node));
                            }
                        }
                    }
                }
                orphanEdge = this.graph.getNextEdge(orphanEdge);
            }
            this.graph.setParent(orphan, bestEdge);
            if (bestEdge != -1) {
                this.graph.setTimestamp(orphan, this.time);
                this.graph.setDistance(orphan, minDistance + 1);
            } else {
                this.addToChangedList(orphan);
                orphanEdge = this.graph.getFirstOutgoing(orphan);
                while (orphanEdge != -1) {
                    node = this.graph.getHead(orphanEdge);
                    parentEdge = this.graph.getParent(node);
                    if (!this.graph.isInSink(node) && parentEdge != -1) {
                        if (this.graph.getResidualEdgeCapacity(this.graph.getSister(orphanEdge)) != 0.0f) {
                            this.setNodeActive(node);
                        }
                        if (parentEdge != -2 && parentEdge != -3 && this.graph.getHead(parentEdge) == orphan) {
                            this.addOrphanAtBack(node);
                        }
                    }
                    orphanEdge = this.graph.getNextEdge(orphanEdge);
                }
            }
        }

        private void processSinkOrphan(int orphan) {
            int parentEdge;
            int node;
            int bestEdge = -1;
            int minDistance = Integer.MAX_VALUE;
            int orphanEdge = this.graph.getFirstOutgoing(orphan);
            while (orphanEdge != -1) {
                if (this.graph.getResidualEdgeCapacity(orphanEdge) != 0.0f) {
                    node = this.graph.getHead(orphanEdge);
                    parentEdge = this.graph.getParent(node);
                    if (this.graph.isInSink(node) && parentEdge != -1) {
                        int distance = 0;
                        while (true) {
                            if (this.graph.getTimestamp(node) == this.time) {
                                distance += this.graph.getDistance(node);
                                break;
                            }
                            parentEdge = this.graph.getParent(node);
                            ++distance;
                            if (parentEdge == -2) {
                                this.graph.setTimestamp(node, this.time);
                                this.graph.setDistance(node, 1);
                                break;
                            }
                            if (parentEdge == -3) {
                                distance = Integer.MAX_VALUE;
                                break;
                            }
                            node = this.graph.getHead(parentEdge);
                        }
                        if (distance < Integer.MAX_VALUE) {
                            if (distance < minDistance) {
                                bestEdge = orphanEdge;
                                minDistance = distance;
                            }
                            node = this.graph.getHead(orphanEdge);
                            while (this.graph.getTimestamp(node) != this.time) {
                                this.graph.setTimestamp(node, this.time);
                                this.graph.setDistance(node, distance);
                                --distance;
                                node = this.graph.getHead(this.graph.getParent(node));
                            }
                        }
                    }
                }
                orphanEdge = this.graph.getNextEdge(orphanEdge);
            }
            this.graph.setParent(orphan, bestEdge);
            if (bestEdge != -1) {
                this.graph.setTimestamp(orphan, this.time);
                this.graph.setDistance(orphan, minDistance + 1);
            } else {
                this.addToChangedList(orphan);
                orphanEdge = this.graph.getFirstOutgoing(orphan);
                while (orphanEdge != -1) {
                    node = this.graph.getHead(orphanEdge);
                    parentEdge = this.graph.getParent(node);
                    if (this.graph.isInSink(node) && parentEdge != -1) {
                        if (this.graph.getResidualEdgeCapacity(orphanEdge) != 0.0f) {
                            this.setNodeActive(node);
                        }
                        if (parentEdge != -2 && parentEdge != -3 && this.graph.getHead(parentEdge) == orphan) {
                            this.addOrphanAtBack(node);
                        }
                    }
                    orphanEdge = this.graph.getNextEdge(orphanEdge);
                }
            }
        }
    }

    public class Semaphore {
        private int evolution = 0;
        private int totalEvolution = 0;

        Semaphore(int e, int t) {
            this.evolution = e;
            this.totalEvolution = t;
        }

        Semaphore() {
            this.evolution = 0;
            this.totalEvolution = 1;
        }

        public void init(int e, int t) {
            this.evolution = e;
            this.totalEvolution = t;
        }

        public boolean unfinished() {
            return this.evolution < this.totalEvolution;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getProgress() {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                return (float)this.evolution / (float)this.totalEvolution;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float getEvolution() {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                return this.evolution;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progress() {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                ++this.evolution;
                this.notify();
            }
        }
    }
}

