/*
 * Decompiled with CFR 0.152.
 */
package plugins.fcordelieres.IcyMetamorphRoiImporter.rgnFile;

import icy.roi.ROI2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class rgnFileContent {
    public int roiType = -1;
    public int color = 0;
    public static final int[] MM_COLORS = new int[]{255, 65280, 0xFF0000, 0xFFFF00, 0xFF00FF, 65535, 128, 32768, 0x800000, 0x808000, 0x800080, 32896, 83954956, 251856644};
    public static int currColor = 0;
    public int xTL = -1;
    public int yTL = -1;
    public String field3 = "0 0";
    public String field4 = "0";
    public String field5 = "1";
    public int nCoord = -1;
    public int[] xCoord = null;
    public int[] yCoord = null;
    public int roiNb = 1;

    public rgnFileContent() {
    }

    public rgnFileContent(String line) {
        this.parseMMFormattedRoi(line);
    }

    public void parseMMFormattedRoi(String line) {
        try {
            String[] fields = line.split(", ");
            if (fields.length == 8) {
                int i = 0;
                while (i < fields.length) {
                    int field = Integer.parseInt(fields[i].split(" ")[0]);
                    String argument = fields[i].substring(fields[i].indexOf(" ") + 1);
                    switch (field) {
                        case 0: {
                            this.roiType = Integer.parseInt(argument);
                            break;
                        }
                        case 1: {
                            this.color = Integer.parseInt(argument);
                            break;
                        }
                        case 2: {
                            this.xTL = Integer.parseInt(argument.split(" ")[0]);
                            this.yTL = Integer.parseInt(argument.split(" ")[1]);
                            break;
                        }
                        case 3: {
                            this.field3 = argument;
                            break;
                        }
                        case 4: {
                            this.field4 = argument;
                            break;
                        }
                        case 5: {
                            this.field5 = argument;
                            break;
                        }
                        case 6: {
                            String[] coord = argument.split(" ");
                            this.nCoord = Integer.parseInt(coord[0]);
                            this.xCoord = new int[this.roiType == 1 ? this.nCoord - 1 : this.nCoord];
                            this.yCoord = new int[this.xCoord.length];
                            int index = 1;
                            int j = 0;
                            while (j < this.xCoord.length) {
                                this.xCoord[j] = Integer.parseInt(coord[index++]);
                                this.yCoord[j] = Integer.parseInt(coord[index++]);
                                ++j;
                            }
                            break;
                        }
                        case 7: {
                            this.roiNb = Integer.parseInt(argument);
                        }
                    }
                    ++i;
                }
            } else {
                Logger.getLogger("The current roi line is not formatted as in Metamorph rgn files");
            }
        }
        catch (Exception ex) {
            Logger.getLogger("The current roi line is not formatted as in Metamorph rgn files");
        }
    }

    public ROI2D getIcyRoifromMMRoi() {
        ROI2DPolyLine roi = null;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        int i = 0;
        while (i < this.xCoord.length) {
            points.add(new Point2D.Double(this.xCoord[i], this.yCoord[i]));
            ++i;
        }
        switch (this.roiType) {
            case 1: {
                roi = new ROI2DRectangle((double)this.xTL, (double)this.yTL, (double)this.xCoord[0], (double)this.yCoord[0]);
                break;
            }
            case 2: {
                roi = new ROI2DPolyLine(points);
                break;
            }
            case 3: {
                roi = new ROI2DPolygon(points);
                break;
            }
            case 5: {
                int[] tmp = (int[])this.xCoord.clone();
                Arrays.sort(tmp);
                int width = tmp[this.nCoord - 1] - tmp[0];
                tmp = (int[])this.yCoord.clone();
                Arrays.sort(tmp);
                int height = tmp[this.nCoord - 1] - tmp[0];
                roi = new ROI2DEllipse((double)this.xTL, (double)this.yTL, (double)(this.xTL + width), (double)(this.yTL + height));
                break;
            }
            case 6: {
                roi = new ROI2DPolygon(points);
                break;
            }
            default: {
                roi = null;
                Logger.getLogger("This type of Metamorph roi (" + this.roiType + ") is not yet supported");
            }
        }
        if (roi != null) {
            roi.setColor(new Color(this.color));
        }
        return roi;
    }
}

