package plugins.fab.singlemousetracker;

import icy.main.Icy;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import ucar.nc2.Sequence;

public class ShortestPathSolver {

	//private ROI2DPolygon roiPoly;
	private Point2D p1;
	private Point2D endPoint;
	BooleanMask2D booleanMask2D; // booleanMask of the polygon.
	ArrayList<Line2D> line2DList = new ArrayList<Line2D>();
	ArrayList<Point2D> polygonPointList;
	double maxLength;
	ROI2DPolygon roiPoly; // polygon describing the cage
	
	public ShortestPathSolver(ROI2DPolygon roiPoly, BooleanMask2D booleanMask2D , Point2D p1, Point2D p2) {
		
		this.p1 = p1;
		this.endPoint = p2;
		this.roiPoly = roiPoly;
		this.booleanMask2D = booleanMask2D; //roiPoly.getBooleanMask2D( 0 , 0 , 0 , true );
		
		polygonPointList = roiPoly.getPoints();

		{
			Point2D previousPoint = null;
			Point2D startPoint = null;
			Point2D lastPoint = null;
			for ( Point2D p : polygonPointList )
			{
				if ( previousPoint != null )
				{
					line2DList.add( new Line2D.Double( previousPoint , p ) ); // add one way segment
				}
				previousPoint = p;
				if ( startPoint == null )
				{
					startPoint = p;
				}
				lastPoint = p;
			}
			if ( startPoint != null )
			{
				// close loop
				if ( lastPoint != startPoint )
				{
					line2DList.add( new Line2D.Double( lastPoint , startPoint) );
				}
			}
		}		
		//maxLength = roiPoly.getNumberOfContourPoints() / 2;
		
		maxLength = Double.MAX_VALUE;
		
		// initiate Branch List
		Branch rootBranch = new Branch( p1 , null );
		
		boolean allPathFound = true;
		while ( allPathFound )
		{
			//System.out.println("Branch Iteration");
			// propagate branches
			
			rootBranch.grow( );
			//System.out.println( "Root number of child: " + rootBranch.branchList.size() );
			
			for ( Branch branch : allBranchList )
			{
				if ( branch.branchList.size() == 0 && branch.terminated )
				{
					allPathFound = false;
					break;
				}
			}
		
		}

		for ( Branch branch : allBranchList )
		{
			if ( branch.branchList.size() == 0 && branch.startPoint == endPoint )
			{
				double distance = branch.getDistance();
				if ( distance < shortestDistance )
				{
					shortestDistance = distance;
					bestLeaf = branch;
				}
			}
				
		}
		// remove previous existing paths
		icy.sequence.Sequence activeSequence = Icy.getMainInterface().getActiveSequence();
		for ( ROI roi : activeSequence.getROIs() )
		{
			if ( roi.getName().startsWith("path") ) activeSequence.removeROI( roi );
		}
		
		// TEST: display all possible paths.
		/*
		{
			for ( Branch branch : allBranchList )
			{
// 				FIXME: put back this test !
//				if ( branch.branchList.size() == 0 && branch.startPoint == endPoint )
				{
					if ( branch != bestLeaf )
					{
						ROI2DPolyLine pathROI = new ROI2DPolyLine( branch.getPath() );
						pathROI.setName("path " + branch.distance );
						pathROI.setColor( Color.YELLOW );
						Icy.getMainInterface().getActiveSequence().addROI( pathROI );
					}
				}				
			}
		}
		{
			// TEST: display polyLine set
			for ( Line2D polyLine : line2DList )
			{
				ROI2DPolyLine pathROI = new ROI2DPolyLine( polyLine.getP1() );
				pathROI.addNewPoint( polyLine.getP2(), true );
				pathROI.setColor( Color.PINK );
				Icy.getMainInterface().getActiveSequence().addROI( pathROI );
				pathROI.setName("path A");
			}
		}
		*/
		
		
		/*
		if ( bestLeaf != null )
		{
			System.out.println( "found" );
			
			ROI2DPolyLine pathROI = new ROI2DPolyLine( bestLeaf.getPath() );
			pathROI.setName("path FOUND " + bestLeaf.distance );
			pathROI.setColor( Color.RED );
			Icy.getMainInterface().getActiveSequence().addROI( pathROI );
		}

*/
		
		//System.out.println("DONE");
		
	}
	
	public double getShortestDistance() {
		return shortestDistance;	
	}
	
	public ROI2DPolyLine getBestPathAsROI()
	{
		if ( bestLeaf == null )
		{
			System.out.println("GetBestPathAsROI: No best path found.");
			return null;
		}
		ROI2DPolyLine pathROI = new ROI2DPolyLine( bestLeaf.getPath() );
		pathROI.setName("path FOUND " + bestLeaf.distance );
		pathROI.setColor( Color.RED );
		return pathROI;
		//Icy.getMainInterface().getActiveSequence().addROI( pathROI );
	}
	
	// TODO: pruning
	double shortestDistance = Double.MAX_VALUE; // could be perimeter / 2
	
	Branch bestLeaf = null;
	
	//	ArrayList<Point2D> bestPath = null;
//	boolean goalReached = false;
	ArrayList<Branch> allBranchList = new ArrayList<ShortestPathSolver.Branch>();
	
	
	class Branch
	{		
		Point2D startPoint;
		ArrayList<Branch> branchList = new ArrayList<Branch>();
		Branch parent;
		int ID = icy.util.Random.nextInt();
		boolean terminated = false;
		double distance = 0;
		
		public Branch( Point2D startPoint , Branch parent ) {
			this.startPoint = startPoint;
			this.parent = parent;
			allBranchList.add( this );
			if ( parent != null )
			{
				distance += parent.distance + startPoint.distance( parent.startPoint );
			}
			// TODO: pruning			
			if ( distance > maxLength ) terminated = true;
		}

		public ArrayList<Point2D> getPath() {
			
			ArrayList<Point2D> pointList = new ArrayList<Point2D>();
			Branch leaf = this;
			while ( leaf != null )
			{
				pointList.add( leaf.startPoint );
				leaf = leaf.parent;
			}

			return pointList;
		}

		public double getDistance() {

			return distance;

		}

		public void showFullBranch( Branch leaf )
		{
			//System.out.println("------- FULL BRANCH:");
			while ( leaf != null )
			{
			//	System.out.println( leaf.startPoint );
				leaf = leaf.parent;
			}
			//System.out.println("---");
		}
		
		public void grow( ) {
			
			//System.out.println("Branch Growing " + ID );
			
			// TODO: pruning
			if ( distance > shortestDistance ) terminated = true;
			
			if ( startPoint == endPoint )
			{
				//System.out.println("Goal leaf.");
				if ( shortestDistance > distance )
				{
					shortestDistance = distance;
					bestLeaf = this;
				}
				terminated = true;
			}
			
			if ( terminated ) return;
			
			
			if( branchList.size() == 0 ) // if this branch is a leaf, create child
			{
				//System.out.println("Create branch childs");
				// check if this branch can see the target p2.
				if ( isLineInsideBooleanMask( startPoint, endPoint ) )
				{
					branchList.add( new Branch( endPoint , this ) );
					//showFullBranch( this );
					//goalReached = true;
					return;
				}

				terminated = true;
				for ( Point2D p : polygonPointList )
				{
					if ( !contain( p ) )
					if ( isLineInsideBooleanMask( startPoint, p ) )
					{
						branchList.add( new Branch( p , this ) );
						terminated = false;
					}
				}
				
				/*
				for ( Segment segment : segmentList )  // propagate along possible segment if start by one of them.
				{
					if ( segment.p1 == startPoint )
//					if ( isLineInsideBooleanMask( startPoint, segment.p2 ) )
					{
						System.out.println("Growing to " + segment.p2 );
						branchList.add( new Branch( segment.p2 , this ) );
					}
				}
				
				if ( startPoint == p1 ) // if we start from the very beginning of the path, go to all polygon points.
				{
					for ( Segment segment : segmentList )
					{
						if ( isLineInsideBooleanMask( startPoint, segment.p1 ) )
						{
							// TODO: check for doublon
							System.out.println("Growing to poly " + segment.p1 );
							branchList.add( new Branch( segment.p1 , this ) );			
						}
					}
				}
				*/
			}
			else
			{
				for ( Branch branch : branchList ) // propagate to next branch.
				{
					branch.grow( );
				}
			}
			
		}

		/** check if the point is in here or in the parents */
		private boolean contain(Point2D p) {
			
			Branch leaf = this;
			while ( leaf != null )
			{
				if ( leaf.startPoint == p ) return true;
				leaf= leaf.parent;
			}
			
			return false;
		}
	}
	

	private boolean isLineInsideBooleanMask( Point2D p1, Point2D p2 ) {

		/*
		ROI2DLine line = new ROI2DLine( p1, p2 );
		BooleanMask2D lineMask = line.getBooleanMask( true );
		
		return booleanMask2D.contains( lineMask );
		*/
		
		Line2D line = new Line2D.Double( p1, p2 );
		
		double vx = p2.getX() - p1.getX();
		double vy = p2.getY() - p1.getY();
		
		double norm = Point2D.distance( 0 , 0 , vx, vy );
		vx/=norm;
		vy/=norm;
		
		// reduce line by 1 pix each side to avoid point match.
		Point2D p1offset = new Point2D.Double( p1.getX() + vx , p1.getY() + vy );
		Point2D p2offset = new Point2D.Double( p2.getX() - vx , p2.getY() - vy );
		Line2D lineOffset = new Line2D.Double( p1offset , p2offset );
		
		for ( Line2D polyLine : line2DList )
		{
			// TODO: ce test ne marche pas ?
			if ( 
				( polyLine.getP1().equals( p1 ) && polyLine.getP2().equals( p2 ) )
					||
				( polyLine.getP1().equals( p2 ) && polyLine.getP2().equals( p1 ) )
				)
			{
				// same line
				return true;
			}
		}
			
		for ( Line2D polyLine : line2DList )
		{	
			if ( polyLine.intersectsLine( lineOffset ) ) 
				return false;
		}
		
		if ( !roiPoly.getShape().contains( p1offset ) ) 
			return false;

	//	if ( polyLine.intersectsLine( lineOffset ) ) return false;

		
		
		return true;
		
	}

	
	
}
