package plugins.adufour.roi;

import java.awt.event.KeyEvent;

import javax.vecmath.Point3i;

import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.ToolTipFrame;
import icy.painter.Overlay;
import icy.plugin.abstract_.PluginActionable;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.type.point.Point5D.Double;
import icy.util.EventUtil;

public class ROIMover extends PluginActionable
{
    private static class MoverOverlay extends Overlay
    {
        private final ToolTipFrame tooltip;
        
        public MoverOverlay()
        {
            super("ROI Mover", OverlayPriority.TOOLTIP_HIGH);
            
            String howto = "<b>ROI Mover is now active</b><br/>";
            howto += "Instructions:<br/>";
            howto += "1) Draw and/or select one (or more) regions of interest<br/>";
            howto += "2) Move or copy the selected ROI using the following shortcuts:<ul>";
            howto += "<li>Ctrl/Command + LEFT: moves the ROI to the left (by 1 pixel)</li>";
            howto += "<li>Ctrl/Command + RIGHT: moves the ROI to the right (by 1 pixel)</li>";
            howto += "<li>Ctrl/Command + UP: moves the ROI upwards in the same plane (by 1 pixel)</li>";
            howto += "<li>Ctrl/Command + DOWN: moves the ROI downwards in the same plane (by 1 pixel)</li>";
            howto += "<li>Ctrl/Command + U: moves the ROI to the upper Z plane</li>";
            howto += "<li>Ctrl/Command + D: moves the ROI to the lower Z plane</li>";
            howto += "<li>Add the 'Shift' key to move the ROI by 10 pixels/planes instead of 1</li>";
            howto += "<li>Add the 'Alt' key to grow the ROI instead of moving them</li>";
            howto += "<li>Escape: deactivates these shortcuts and closes this box</li>";
            howto += "</ul>";
            
            tooltip = new ToolTipFrame(howto);
        }
        
        @Override
        public void keyPressed(KeyEvent e, Double imagePoint, IcyCanvas canvas)
        {
            Point3i translation = getTranslation(e.getKeyCode());
            
            if (translation != null && EventUtil.isMenuControlDown(e))
            {
                e.consume();
                
                if (EventUtil.isShiftDown(e)) translation.scale(10);
                
                int currentZ = canvas.getPositionZ();
                int newZ = canvas.getPositionZ() + translation.z;
                
                for (ROI2D roi : canvas.getSequence().getSelectedROI2Ds())
                {
                    if (!roi.isActiveFor(currentZ, canvas.getPositionT(), canvas.getPositionC())) continue;
                    
                    if (newZ < 0 || newZ >= canvas.getSequence().getSizeZ(canvas.getPositionT())) continue;
                    
                    if (e.isAltDown())
                    {
                        if (roi.getZ() == -1) roi.setZ(currentZ);
                        
                        // grow it as required
                        for (int z = currentZ + 1; z <= newZ; z++)
                        {
                            ROI2D copy = (ROI2D) roi.getCopy();
                            copy.setZ(z);
                            copy.setSelected(true);
                            canvas.getSequence().addROI(copy);
                        }
                    }
                    else // just move it
                    {
                        roi.setZ(newZ);
                    }
                    
                    canvas.setPositionZ(newZ);
                }
                for (ROI3D roi : canvas.getSequence().getSelectedROI3Ds())
                {
                    if (e.isAltDown())
                    {
                        // be sorry
                        System.err.println("WARNING: cannot grow a ROI of type " + roi.getClassName());
                    }
                    else // just move it
                    {
                        roi.translate(0, 0, translation.z);
                    }
                }
            }
            else if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
            {
                canvas.removeLayer(this);
                tooltip.close();
            }
        }
        
        static Point3i getTranslation(int keyCode)
        {
            switch (keyCode)
            {
            case KeyEvent.VK_U:
                return new Point3i(0, 0, 1);
            case KeyEvent.VK_D:
                return new Point3i(0, 0, -1);
            }
            return null;
        }
    };
    
    @Override
    public void run()
    {
        if (getActiveViewer() != null)
        {
            getActiveViewer().getCanvas().addLayer(new MoverOverlay());
        }
    }
}
