package plugins.dmandache.denoise;


public class Util {
	
	/**
	 * Helper functions for different arithmetical operations on 2D and 1D matrices  
	 *  
	 * @author Diana Mandache
	 * @version 1.0
	 * @date 2017-02-20
	 * @license gpl v3.0
	 */
	
	/**
	* Subtract 2 bi-dimensional arrays of same size
	* */
	public static double[][] subtract2D(double[][] M1, double[][] M2, int rows, int cols){
		double [][] result = new double[rows][cols];
		for(int r=0; r<rows; r++){
			for(int c=0; c<cols; c++){
				result[r][c] = M1[r][c] - M2[r][c];
			}
		}
		return result;	
	}
	
	/**
	* Subtract 2 uni-dimensional arrays of same size
	* */
	public static double[] subtract1D(double[] M1, double[] M2){
		double [] result = new double[M1.length];
		for(int k=0; k<M1.length; k++)
			result[k] = M1[k] - M2[k];
		return result;	
	}
	
	/**
	* Add 2 uni-dimensional arrays of same size
	* */
	public static double[] add1D(double[] M1, double[] M2){
		double [] result = new double[M1.length];
		for(int k=0; k<M1.length; k++)
			result[k] = M1[k] + M2[k];
		return result;	
	}

	/**
	* Sum of elements of an array M
	* */
	public static double sum1D(double[] M1){
		double result = 0.0;
		for(int k=0; k<M1.length; k++)
			result += M1[k];
		return result;	
	}
		
	/**
	* Multiply an array M with a scalar c
	* */
	public static double[] multiplyScalar1D(double[] M, double c){
		for(int k=0; k<M.length; k++)
			M[k] *= c;
		return M;	
	}
	
	/**
	* Multiply element wise two arrays M1 and M2
	* */
	public static double[] multiplyElementwise1D(double[] M1, double[] M2){
		double [] result = new double[M1.length];
		for(int k=0; k<M1.length; k++)
			result[k] = M1[k] * M2[k];
		return result;	
	}
	
	/**
	* Find mean value of an array M
	* */
	public static double mean1D(double[] M){	 
		double result = 0.0;
		for(int k=0; k<M.length; k++)
			result += M[k];
		result = result / M.length;
		return result;	
	}
	
	/**
	* Find L2 norm of an array M
	* */
	public static double normL2(double[] M){		 
		double result = 0.0;
		for(int k=0; k<M.length; k++)
			result += M[k] * M[k];
		result = Math.sqrt(result);
		return result;	
	}
	
	/**
	* Find maximum value of an array M
	* */
	public static double findMax(double[] M){
		double max = M[0];	
		for (int i = 1; i < M.length; i++) 
		    if ( M[i] > max) 
		      max = M[i];
		return max;
	}
	
	/**
	* Find minimum value of an array M
	* */
	public static double findMin(double[] M){
		double min = M[0];	
		for (int i = 1; i < M.length; i++) 
		    if ( M[i] < min) 
		      min = M[i];
		return min;
	}

	/**
	* Scales an array M to a given range [newMin, newMax]
	* */
	public static double[] scale(double[] M, double newMin, double newMax){	
		double oldMax = findMax(M);
		double oldMin = findMin(M);
		System.out.println(oldMin + " - " + oldMax);
		double[] scaled = new double[M.length];
		for (int i = 0; i < M.length; i++) 
		  scaled[i] = ((newMax - newMin) * (M[i] - oldMin) / (oldMax - oldMin)) + newMin;
		return scaled;
	}
	
	/**
	 * Computes the PSNR (Peak Signal to Noise Ratio) between 2 images M1 and M2
	 * */
	public static double psnr(double[] M1, double[] M2){
		double mse = 0.0;
		double psnr = 0.0;
		for( int k=0; k<M1.length; k++){
	        mse += (M2[k]- M1[k]) * (M2[k] - M1[k]);
		}
	    mse = mse/M1.length;
	    psnr = (-10*Math.log10(mse/(255*255)));	
	    return (double)Math.round(psnr * 100000d) / 100000d;
	}
	
}

