package plugins.vannary.morphomaths;

import icy.type.point.Point3D;
import icy.util.StringUtil;

public class Point3DEdge extends Point3D.Integer implements Comparable<Point3DEdge> {

	final String id;

	public Point3DEdge(int k, int l, int m) {
		super(k, l, m);

		id = StringUtil.toString(k) + " " + StringUtil.toString(l) + " " + StringUtil.toString(m);
	}

	@Override
	public int compareTo(Point3DEdge p) {
		if (this.getX() < p.getX()) {
			return -1;
		} else if (this.getX() == p.getX()) {
			if (this.getY() < p.getY())
				return -1;
			else if (this.getY() == p.getY()) {
				if (this.getZ() < p.getZ())
					return -1;
				else if (this.getZ() == p.getZ())
					return 0;
				else
					return 1;
			} else
				return 1;
		} else {
			return 1;
		}
	}

	public String getId() {
		return id;
	}

}
