package plugins.tprovoost.Microscopy.CalibratorManager;

import icy.plugin.abstract_.Plugin;

import java.awt.Component;

import javax.swing.JPanel;

import mmcorej.CMMCore;

/**
 * This is the class to inherit in order to create a Calibrator Plugin.<br/>
 * <b>The sub-class must have a constructor without arguments in order to be created by
 * {@link CalibratorManagerPlugin}</b>
 * <p>
 * <b>Example: </b>
 * 
 * <pre>
 *    class Test extends CalibratorPlugin { <br/>
 * 	  public Test(){
 * 	  	super("TestCalibratorPlugin");
 * 	  }
 * 	  
 * 	  public JPanel initGui(){
 * 	  	JPanel pan = new JPanel();
 * 	  	pan.add(new JTextField("testText"));
 * 	  	return pan;
 * 	  }
 *   }
 * </pre>
 * </p>
 * 
 * @author Irsath Nguyen
 */
public abstract class CalibratorPlugin extends Plugin
{
    private String title;

    public CalibratorPlugin(String title)
    {
        this.title = title;
    }

    public String getJTabbedPaneTitle()
    {
        return title;
    }

    public Component getJTabbedPaneContent()
    {
        return initializeGUI();
    }

    /**
     * Use this method to retrieve data before creating the content. This method is called before
     * {@link #initializeGUI()}
     * 
     * @param core
     */
    public abstract void initializePluginData(CMMCore core);

    /**
     * Use this method to create the content JPanel of the JTabbedPane of
     * {@link CalibratorManagerPlugin} <br/>
     * <b>WARNING : This method is called on the on the AWT event dispatching thread, making other
     * thing than creating graphical component may lead to dead lock !</b>
     * 
     * @return the content as a JPanel
     */
    public abstract JPanel initializeGUI();
}
