package plugins.tprovoost.Microscopy.CalibratorPixelSize;

import icy.canvas.IcyCanvas;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.painter.Overlay;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import mmcorej.CMMCore;
import plugins.tprovoost.Microscopy.CalibratorManager.CalibratorPlugin;
import plugins.tprovoost.Microscopy.MicroManager.MicroscopeOverlayPreferences;

public class CalibratorPixelSize extends CalibratorPlugin
{
    private CMMCore _core;
    private String _XYStage;
    private JLabel _lblValue;
    double value;
    private XMLPreferences prefs;
    private static final String PREFS_VALUE = "value";

    public CalibratorPixelSize()
    {
        super("PixelSize Config");
    }

    void calibratePxSizeConf()
    {
        _XYStage = _core.getXYStageDevice();
        Sequence s = getActiveSequence();
        if (s == null)
        {
            MessageDialog.showDialog("Error", "Live Sequence (Live2D, Live3D) must be running.",
                    MessageDialog.INFORMATION_MESSAGE);
            return;
        }
        Overlay over = new Overlay("CalibratorPainter")
        {
            @Override
            public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
            {
                super.paint(g, sequence, canvas);
                int w = sequence.getWidth();
                int h = sequence.getHeight();
                int sizew = (int) canvas.canvasToImageLogDeltaX(20);

                // Draw the shadow
                g.setColor(MicroscopeOverlayPreferences.getInstance().getColor("shadow"));
                g.setStroke(new BasicStroke((float) canvas.canvasToImageDeltaX(2)));

                // draw the reticle
                g.setColor(MicroscopeOverlayPreferences.getInstance().getColor("normal"));
                g.drawLine(sizew, sizew, sizew * 2, sizew);
                g.drawLine(sizew, sizew, sizew, sizew * 2);
                g.drawLine(w - sizew, h - sizew, w - sizew * 2, h - sizew);
                g.drawLine(w - sizew, h - sizew, w - sizew, h - sizew * 2);
            }
        };
        s.addOverlay(over);
        MessageDialog.showDialog("Please move the desired cell to the upper left corner and hit OK.");
        double xposOrigin, yposOrigin;
        try
        {
            xposOrigin = _core.getXPosition(_XYStage);
            yposOrigin = _core.getYPosition(_XYStage);
        }
        catch (Exception e)
        {
            System.out.println("Error on :" + getClass().getName() + " while getting position");
            return;
        }
        MessageDialog.showDialog("Please move the cell to the lower right corner, then hit OK.");
        double xposDest, yposDest;
        try
        {
            xposDest = _core.getXPosition(_XYStage);
            yposDest = _core.getYPosition(_XYStage);
        }
        catch (Exception e)
        {
            System.out.println("Error on :" + getClass().getName() + " while getting position");
            return;
        }
        Point2D orig = new Point2D.Double(xposOrigin, yposOrigin);
        Point2D dest = new Point2D.Double(xposDest, yposDest);
        double w = getActiveImage().getWidth();
        double h = getActiveImage().getHeight();
        double distance_um = orig.distance(dest);
        double distance_px = Math.sqrt(w * w + h * h);
        value = distance_um / distance_px;
        prefs.putDouble(PREFS_VALUE, value);
        _lblValue.setToolTipText("This value is the one calculated.");
        _lblValue.setText("" + value);
        s.removeOverlay(over);
    }

    @Override
    public void initializePluginData(CMMCore core)
    {
        _core = core;
        _XYStage = _core.getXYStageDevice();
    }

    @Override
    public JPanel initializeGUI()
    {
        // / sets the value used by Calibrator Manager
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        JPanel panelAlgorithm = new JPanel();
        panelAlgorithm.setLayout(new BorderLayout());

        // set the descriptor
        JLabel descriptor = new JLabel(
                "<html>Represents how many m corresponds to a single pixel on your image.</html>");

        // set the button
        JButton btnRun = new JButton("Run");
        btnRun.addActionListener(new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent e)
            {
                calibratePxSizeConf();
            }
        });
        JButton btnCopy = new JButton("Set to Sequence");
        btnCopy.setToolTipText("Copy the current value to the X & Y PixelSize of the focused Sequence.");
        btnCopy.addActionListener(new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent e)
            {
                Sequence s = getActiveSequence();
                if (s == null)
                    return;
                if (value <= 0)
                {
                    new AnnounceFrame("Error in pixel size calculation, pixel size cannot be : " + value + " m", 5);
                    return;
                }
                s.setPixelSizeX(value);
                s.setPixelSizeY(value);
                new AnnounceFrame("Pixel size changed to : " + value + " m", 5);
            }
        });
        panelAlgorithm.add(descriptor, BorderLayout.CENTER);
        panelAlgorithm.add(btnRun, BorderLayout.SOUTH);
        JPanel panelResult = new JPanel();
        panelResult.setLayout(new BoxLayout(panelResult, BoxLayout.X_AXIS));
        panelResult.add(new JLabel("PixelSize: "));
        prefs = PluginsPreferences.root(CalibratorPixelSize.this);
        value = prefs.getDouble(PREFS_VALUE, 1);
        _lblValue = new JLabel("" + value);
        _lblValue.setToolTipText("This value is the one previously calculated (or default).");
        panelResult.add(Box.createHorizontalGlue());
        panelResult.add(_lblValue);

        panel.add(panelAlgorithm);
        panel.add(panelResult);
        panel.add(btnCopy);

        if (_XYStage == null || _XYStage == "")
            btnRun.setEnabled(false);

        return panel;
    }
}
