package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.CompareUtil;
import plugins.ylemontag.sequencecomparator.Controller;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;
import plugins.ylemontag.sequencecomparator.GlobalComparator;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Global distance generator for distances which can be computed by aggregating
 * the distances between the XY planes of the two compared sequences
 */
public abstract class PlaneSeparableGlobalComparator extends GlobalComparator
{
	/**
	 * Constructor
	 */
	public PlaneSeparableGlobalComparator(String distanceName)
	{
		super(distanceName);
	}
	
	/**
	 * Aggregation function
	 */
	protected abstract double aggregateOutsideXY(double accu, double errorOverPlane);
	
	/**
	 * Compute the planar error
	 */
	protected abstract double computePlaneError(int sizeX, int sizeY, double[] refPlane, double[] seqPlane);
	
	/**
	 * Normalization function
	 */
	protected void normalizeErrorMeasure(ErrorMeasure retVal, Sequence seq) {}

	@Override
	protected void implCompare(Sequence ref, Sequence seq, ErrorMeasure out, Controller controller)
		throws Controller.CanceledByUser
	{
		boolean extendRefT = false;
		boolean extendRefZ = false;
		if(!CompareUtil.haveSameSize(ref, seq)) {
			if(CompareUtil.comparableWithZExtent(ref, seq)) {
				extendRefZ = true;
			}
			else if(CompareUtil.comparableWithTExtent(ref, seq)) {
				extendRefT = true;
			}
			else if(CompareUtil.comparableWithZTExtent(ref, seq)) {
				extendRefZ = true;
				extendRefT = true;
			}
			else {
				throw new IncompatibleSizes();
			}
		}
		int sizeX = seq.getSizeX();
		int sizeY = seq.getSizeY();
		int sizeZ = seq.getSizeZ();
		int sizeT = seq.getSizeT();
		int sizeC = seq.getSizeC();
		makeErrorMeasure(ref, seq, out);
		for(int t=0; t<sizeT; ++t) {
			for(int z=0; z<sizeZ; ++z) {
				for(int c=0; c<sizeC; ++c) {
					controller.checkPoint();
					int t0 = extendRefT ? 0 : t;
					int z0 = extendRefZ ? 0 : z;
					double[] refPlane = getReadOnlyDataXYAsDouble(ref, t0, z0, c);
					double[] seqPlane = getReadOnlyDataXYAsDouble(seq, t , z , c);
					double accu = computePlaneError(sizeX, sizeY, refPlane, seqPlane);
					out.errorAll  = aggregateOutsideXY(out.errorAll , accu);
					out.errorZ[z] = aggregateOutsideXY(out.errorZ[z], accu);
					out.errorT[t] = aggregateOutsideXY(out.errorT[t], accu);
					out.errorC[c] = aggregateOutsideXY(out.errorC[c], accu);
				}
			}
		}
		normalizeErrorMeasure(out, seq);
	}
}
