/*
 *  This file is part of the StereoViewer plug-in for ICY.
 *  Copyright (C) 2012 Ricard Delgado-Gonzalo
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plugins.rdelgado.stereoviewer.utils;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;

/**
 * Display utilities.
 * 
 * @version February 8, 2012
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class ScreenUtils
{
	// ============================================================================
	// PUBLIC METHODS

	/** Returns the number of displays found in the system. */
	public static int getNDisplays()
	{
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		return ge.getScreenDevices().length;
	}

	// ----------------------------------------------------------------------------

	/** Displays in full screen a frame in a given monitor. */
	public static JFrame showOnFullScreen(int screen, JFrame frame)
	{
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice[] gs = ge.getScreenDevices();
		if( screen > -1 && screen < gs.length )
			gs[screen].setFullScreenWindow(frame);
		else if( gs.length > 0 )
			gs[0].setFullScreenWindow(frame);
		else
			throw new RuntimeException( "No Screens Found" );
		return frame;
	}

	// ----------------------------------------------------------------------------

	/** Displays in full screen a frame in a given monitor. */
	public static JFrame showOnFullScreen(int screen, JPanel panel)
	{
		JFrame frame = new JFrame();
		frame.setUndecorated(true);
		frame.getRootPane().setWindowDecorationStyle(JRootPane.NONE);
		frame.add(panel);
		frame.setVisible(true);

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice[] gs = ge.getScreenDevices();
		if( screen > -1 && screen < gs.length )
			gs[screen].setFullScreenWindow(frame);
		else if( gs.length > 0 )
			gs[0].setFullScreenWindow(frame);
		else
			throw new RuntimeException( "No Screens Found" );
		return frame;
	}
}