package plugins.ylemontag.matlabblocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;

import java.io.IOException;
import java.util.Set;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarFile;
import plugins.ylemontag.matlabio.MatlabImporter;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Extract the list of variables contained in a Matlab file
 */
public class MatlabDiscovererBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private VarFile          _file       = new VarFile      ("File"      , null);
	private VarBoolean       _importable = new VarBoolean   ("Importable", true);
	private Var<String[]>    _out        = new Var<String[]>("Variables" , String[].class, null);

	@Override
	public void declareInput(VarList inputMap)
	{
		_file.setDefaultEditorModel(MatlabBlockUtil.makeMatFileEditor());
		inputMap.add(_file      );
		inputMap.add(_importable);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		outputMap.add(_out);
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return MatlabBlockLibrary.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Matlab discoverer";
	}

	@Override
	public String getDescription()
	{
		return "List the variables contained in a Matlab .mat file";
	}
	
	@Override
	public void run()
	{
		try {
			MatlabImporter importer = new MatlabImporter(_file.getValue());
			Set<String> vals = _importable.getValue() ? importer.getImportableSequences() : importer.getVariables();
			String[] retVal = new String[vals.size()];
			int k=0;
			for(String s : vals) {
				retVal[k] = s;
				++k;
			}
			_out.setValue(retVal);
		}
		catch(IOException err) {
			MatlabBlockUtil.reportError(err);
		}
	}
}
