package plugins.ylemontag.matlabblocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;

import java.io.IOException;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.ylemontag.matlabio.MatlabExporter;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Block that takes an .mat file and a Matlab variable ID (i.e. a string) in
 * input and return the imported sequence
 */
public class MatlabExporterBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private VarFile             _file    = new VarFile("File", null);
	private VarBoolean          _append  = new VarBoolean("Append", true);
	private VarString           _key     = new VarString("Variable ID", "");
	private VarDimensionMapping _mapping = new VarDimensionMapping("Dimension mapping", null);
	private VarBoolean          _complex = new VarBoolean("Is complex", false);
	private VarSequence         _in      = new VarSequence("Data", null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		_file.setDefaultEditorModel(MatlabBlockUtil.makeMatFileEditor());
		inputMap.add(_file   );
		inputMap.add(_append );
		inputMap.add(_key    );
		inputMap.add(_mapping);
		inputMap.add(_complex);
		inputMap.add(_in     );
	}
	
	@Override
	public void declareOutput(VarList outputMap)
	{
		// No output
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return MatlabBlockLibrary.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Matlab exporter";
	}

	@Override
	public String getDescription()
	{
		return "Append a sequence to a Matlab .mat file";
	}
	
	@Override
	public void run()
	{
		try {
			MatlabExporter exporter = new MatlabExporter(_file.getValue(), _append.getValue());
			exporter.putData(_in.getValue(), _key.getValue(), _mapping.getValue(), _complex.getValue());
			exporter.export();
		}
		catch(IOException err) {
			MatlabBlockUtil.reportError(err);
		}
	}
}
