package plugins.ylemontag.matlabblocks;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;

/**
 * 
 * @author Yoann Le Montagner
 *
 * Input dimension mapping block
 */
public class DimensionMappingBlock extends Plugin implements Block, BlockInfo, PluginBundled
{
	private VarDimensionMapping _var = new VarDimensionMapping("Dimension mapping", null);
	
	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add(_var);
	}

	@Override
	public void declareOutput(VarList outputMap)
	{
		// Nothing to do
	}
	
	@Override
	public String getMainPluginClassName()
	{
		return MatlabBlockLibrary.class.getName();
	}
	
	@Override
	public String getName()
	{
		return "Dimension mapping";
	}

	@Override
	public String getDescription()
	{
		return
			"Return a dimension mapping object describing how to perform conversions between " +
			"Matlab nD arrays and Icy 5D sequences";
	}
	
	@Override
	public void run()
	{
		// Nothing to do
	}
}
