package plugins.tlecomte.rectangularFEM;

import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;

public class ShiftingMatrix {
	public static SparseRCDoubleMatrix2D ZeroInsideShiftingMatrix(Mesh mesh) {
		int Ng = mesh.boundaryNodes.length; // number of quadratic nodes on the boundary
		int N = mesh.nodes.length;
		
		int[] row = new int[Ng];
		int[] col = new int[Ng];
		double[] data = new double[Ng];
		
		for (int i=0; i<mesh.boundaryNodes.length; i++) {
			row[i] = mesh.boundaryNodes[i].gridNode.index;
			col[i] = mesh.boundaryNodes[i].index;
			data[i] = 1.;
		}
		
		SparseRCDoubleMatrix2D Ashift = new SparseRCDoubleMatrix2D(N, Ng, row, col, data, true /* remove duplicates */, true /* remove zeroes */, false /* sort column indices */);
		
		return Ashift;
	}
}
