package plugins.vannary.contourdetection;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.VarSequence;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import icy.util.StringUtil;


public class ContourDetection extends EzPlug implements Block {

	private EzVarSequence	input = new EzVarSequence("Input");
	private EzVarDouble		alphaValue = new EzVarDouble("Alpha value", 1., 0.25, 2.0, 0.1);
	
	private VarSequence output = new VarSequence("EDGE", null);
	
	// Method used
		EzVarEnum<MethodType>		method = new EzVarEnum<MethodType>("Method:", MethodType.values());;

	@Override
	protected void initialize() {
	
		super.addEzComponent(input);
		super.addEzComponent(alphaValue );
		
	
		super.addEzComponent(method);
		
	}
	
	@Override
	protected void execute() {
		Sequence seqIn = input.getValue();
		Sequence seqOut = doDeriche(seqIn, alphaValue.getValue());
		if (isHeadLess()){
			output.setValue(seqOut);
		}else{
			
			addSequence(seqOut);
		}

	}

	@Override
	public void clean() {
		// TODO Auto-generated method stub
		
	}

	// Enum containing the methods that can be called in this plug in
		private enum MethodType
		{
			DERICHE("Deriche"), Other_CHOICE(" other choices");
			
			private final String	name;
			
			private MethodType(String string)
			{
				this.name = string;
			}
			
			public String toString()
			{
				return this.name;
			}
		}
	

		
		
	/*
	DERICHE EDGE DETECTOR FILTER
  Usage: gmaxl input output grad_x grad_y -a N 
  input : Input image codee sur un octet
  output : Image des maxima locaux. Format reel.
  grad_x : X gradient image. Format reel.
  grad_y : Y gradient image. Format reel.
  alpha : parametre definissant la resolution a laquelle les contours 
  doivent etre detectes. a should be positive and different from zero.
  plus a est grand plus la taille du filtre est petite. 
  Extrema values of alpha: 0.25 to 2.
  Default value of alpha: 1.0
*/
		Sequence doDeriche( Sequence seq, double alpha){
			Sequence seqOut=new Sequence(); 

			int nmem;
			float [] nf_grx=null; 
			float [] nf_gry=null;
			short []a1;
			int icolonnes,icoll;
			int  lignes, colonnes;
			int  lig_1,lig_2,lig_3,col_1,col_2,col_3,jp1,jm1,im1,ip1;
			int i,j;
			float ad1,ad2,wd,gzr,gun;
			float an1 ,an2 ,an3, an4, an11;
			float a2[],a3[],a4[];
			int icol_1,icol_2;


			lignes = seq.getHeight();
			colonnes =  seq.getWidth();
			nmem = lignes * colonnes;

			lig_1 = lignes -1;
			lig_2 = lignes -2;
			lig_3 = lignes -3;
			col_1 = colonnes -1 ;
			col_2 = colonnes -2 ;
			col_3 = colonnes -3 ;

			/* alloc temporary buffers */
			nf_grx = new float[nmem];
			nf_gry = new float[nmem];

			a2 = new float[nmem];
			a3 =new float[nmem];
			a4 =new float[nmem];


			ad1  = (float) -Math.exp(-alpha);
			ad2  = 0;
			an1  = 1;
			an2  = 0;
			an3  = (float) Math.exp(-alpha);
			an4  = 0;
			an11 = 1;

			/* FIRST STEP:  Y GRADIENT */
			/* x-smoothing */  

			for (int t = 0; t<seq.getSizeT(); t++){
				for (int z = 0; z<seq.getSizeZ(); z++){
					IcyBufferedImage img = seq.getImage(t, z);
					IcyBufferedImage img2 =img.getCopy();// TODO new 

					for (int ch = 0; ch<seq.getSizeC(); ch++){


						double[] tabInDouble = Array1DUtil.arrayToDoubleArray(img.getDataXY(ch), img.isSignedDataType());

						a1=new short[nmem];
						// Copy mina1 to a1 

						for (int y = 0; y < lignes; ++y){
							for (int x = 0; x < colonnes; ++x){				  
								a1[y*colonnes+x] = (short) tabInDouble[y*colonnes+x];	
							}
						}


						for (i = 0; i < lignes; ++i){       
							icolonnes=i*colonnes;
							icol_1=icolonnes-1;
							icol_2=icolonnes-2;
							a2[icolonnes] = an1 * a1[icolonnes];
							a2[icolonnes+1] = an1 * a1[icolonnes+1] + 
									an2 * a1[icolonnes] - ad1 * a2[icolonnes];
							for (j = 2; j < colonnes; ++j)
								a2[icolonnes+j] = an1 * a1[icolonnes+j] + an2 * a1[icol_1+j] -
								ad1 * a2[icol_1+j] - ad2 * a2[icol_2+j];
						}

						for (i = 0; i < lignes; ++i){       
							icolonnes=i*colonnes;
							icol_1=icolonnes+1;
							icol_2=icolonnes+2;
							a3[icolonnes+col_1] = 0;
							a3[icolonnes+col_2] = an3 * a1[icolonnes+col_1];
							for (j = col_3; j >= 0; --j)
								a3[icolonnes+j] = an3 * a1[icol_1+j] + an4 * a1[icol_2+j] -
								ad1 * a3[icol_1+j] - ad2 * a3[icol_2+j];
						}

						icol_1=lignes*colonnes;

						for (i = 0; i < icol_1; ++i)
							a2[i] += a3[i]; 

						/* FIRST STEP Y-GRADIENT : y-derivative  */
						/* columns top - downn */
						for (j = 0; j < colonnes; ++j){
							a3[j] = 0;
							a3[colonnes+j] = an11 * a2[j]-ad1*a3[j];
							for (i = 2; i < lignes; ++i)
								a3[i*colonnes+j] = an11 * a2[(i-1)*colonnes+j] - 
								ad1 * a3[(i-1)*colonnes+j] - ad2 * a3[(i-2)*colonnes+j];
						}

						/* columns down top */
						for (j = 0; j < colonnes; ++j){
							a4[lig_1*colonnes+j] = 0;
							a4[(lig_2*colonnes)+j] = -an11 * a2[lig_1*colonnes+j]-
									ad1*a4[lig_1*colonnes+j];
							for (i = lig_3; i >= 0; --i)
								a4[i*colonnes+j] = -an11 * a2[(i+1)*colonnes+j] -
								ad1 * a4[(i+1)*colonnes+j] -ad2 * a4[(i+2)*colonnes+j];
						}

						icol_1=colonnes*lignes;
						for(i=0;i<icol_1;++i)
							a3[i]+=a4[i]; /**** a2 ??? *****/

						for (i=0; i<lignes; i++)
							for (j=0; j<colonnes; j++)
								nf_gry[i*colonnes+j] = a3[i*colonnes+j];

						/* SECOND STEP X-GRADIENT  */

						for (i = 0; i < lignes; ++i){       
							icolonnes=i*colonnes;
							icol_1=icolonnes-1;
							icol_2=icolonnes-2;
							a2[icolonnes] = 0;
							a2[icolonnes+1] = an11 * a1[icolonnes];
							for (j = 2; j < colonnes; ++j)
								a2[icolonnes+j] = an11 * a1[icol_1+j] -
								ad1 * a2[icol_1+j] - ad2 * a2[icol_2+j];
						}

						for (i = 0; i < lignes; ++i){       
							icolonnes=i*colonnes;
							icol_1=icolonnes+1;
							icol_2=icolonnes+2;
							a3[icolonnes+col_1] = 0;
							a3[icolonnes+col_2] = -an11 * a1[icolonnes+col_1];
							for (j = col_3; j >= 0; --j)
								a3[icolonnes+j] = -an11 * a1[icol_1+j] -
								ad1 * a3[icol_1+j] - ad2 * a3[icol_2+j];
						}
						icol_1=lignes*colonnes;
						for (i = 0; i < icol_1; ++i)
							a2[i] += a3[i]; 

						/*on the columns */
						/* columns top down */
						for (j = 0; j < colonnes; ++j){
							a3[j] = an1 * a2[j];
							a3[colonnes+j] = an1 * a2[colonnes+j] + an2 * a2[j] 
									- ad1 * a3[j];
							for (i = 2; i < lignes; ++i)
								a3[i*colonnes+j] = an1 * a2[i*colonnes+j] + an2 * a2[(i-1)*colonnes+j] -
								ad1 * a3[(i-1)*colonnes+j] - ad2 * a3[(i-2)*colonnes+j];
						}

						/* columns down top */
						for (j = 0; j < colonnes; ++j){
							a4[lig_1*colonnes+j] = 0;
							a4[lig_2*colonnes+j] = an3 * a2[lig_1*colonnes+j]-ad1*a4[lig_1*colonnes+j];
							for (i = lig_3; i >= 0; --i)
								a4[i*colonnes+j] = an3 * a2[(i+1)*colonnes+j] + an4 * a2[(i+2)*colonnes+j] -
								ad1 * a4[(i+1)*colonnes+j] - ad2 * a4[(i+2)*colonnes+j];
						}

						icol_1=colonnes*lignes;
						for(i=0;i<icol_1;++i)
							a3[i]+=a4[i]; 


						for (i=0; i<lignes; i++)
							for (j=0; j<colonnes; j++)
								nf_grx[i*colonnes+j] = a3[i*colonnes+j];

						/* SECOND STEP X-GRADIENT : the x-gradient is  done */

						/* THIRD STEP : NORM */
						/* the magnitude computation*/

						for (i=0; i<lignes; i++)
							for (j=0; j<colonnes; j++)
								a2[i*colonnes+j] = nf_gry[i*colonnes+j];
						icol_1=colonnes*lignes;
						for(i=0;i<icol_1;++i) a2[i] =  Modul(a2[i],a3[i]);

						/* THIRD STEP : the norm is done */


						/* FOURTH STEP : NON MAXIMA SUPPRESSION */
						for (i=0; i<lignes; i++)
							for (j=0; j<colonnes; j++)
								a4[i*colonnes+j] = nf_grx[i*colonnes+j];

						for (i=0; i<lignes; i++)
							for (j=0; j<colonnes; j++)
								a3[i*colonnes+j] = nf_gry[i*colonnes+j];

						/* Nom maxima suppression with linear interpolation */
						for (i = 1; i <= lig_2; ++i){ 
							icoll=i*colonnes;
							for (j = 1; j <= col_2; ++j){
								jp1=j+1;
								jm1=j-1;
								ip1=i+1;
								im1=i-1;
								if ( a3[icoll+j] > 0. ){       
									wd = a4[icoll+j] / a3[icoll+j];
									a3[icoll+j]=0;
									if ( wd >= 1 ){
										gun = a2[icoll+jp1] +
												(a2[ip1*colonnes+jp1] - a2[icoll+jp1]) / wd;
										if ( a2[icoll+j] <= gun ) continue;
										gzr = a2[icoll+jm1] + 
												(a2[im1*colonnes+jm1] - a2[icoll+jm1]) / wd;
										if ( a2[icoll+j] < gzr ) continue;
										a3[icoll+j] = a2[icoll+j];
										continue; 
									}
									if ( wd >= 0 ){
										gun = a2[ip1*colonnes+j] +
												(a2[ip1*colonnes+jp1] - a2[ip1*colonnes+j]) * wd;
										if ( a2[icoll+j] <= gun ) continue;
										gzr = a2[im1*colonnes+j] + 
												(a2[im1*colonnes+jm1] - a2[im1*colonnes+j]) * wd;
										if ( a2[icoll+j] < gzr ) continue;
										a3[icoll+j] = a2[icoll+j];
										continue; 
									}
									if ( wd >= -1){
										icolonnes=ip1*colonnes;
										gun = a2[icolonnes+j] - 
												(a2[icolonnes+jm1] - a2[icolonnes+j]) * wd;
										if ( a2[icoll+j] <= gun ) 
											continue;
										icolonnes=im1*colonnes;
										gzr = a2[icolonnes+j] - 
												(a2[icolonnes+jp1] - a2[icolonnes+j]) * wd;
										if ( a2[icoll+j] < gzr ) continue;
										a3[icoll+j] = a2[icoll+j];
										continue; 
									}
									gun = a2[icoll+jm1] - (a2[ip1*colonnes+
									                          jm1] - a2[icoll+jm1]) / wd; 
									if ( a2[icoll+j] <= gun ) continue;
									gzr = a2[icoll+jp1] - (a2[im1*colonnes+
									                          jp1] - a2[icoll+jp1]) / wd;
									if ( a2[icoll+j] < gzr ) continue;
									a3[icoll+j] = a2[icoll+j];
									continue;
								}
								if (  (a3[icoll+j]) == 0.){       
									if ( a4[icoll+j] == 0 ) continue;
									if ( a4[icoll+j] < 0  ){
										gzr = a2[icoll+jp1];
										if ( a2[icoll+j] < gzr ) continue;
										gun = a2[icoll+jm1];
										if ( a2[icoll+j] <= gun ) continue;
										a3[icoll+j] = a2[icoll+j];
										continue;
									}
									gzr = a2[icoll+jm1];
									if ( a2[icoll+j] < gzr ) continue;
									gun = a2[icoll+jp1];
									if ( a2[icoll+j] <= gun ) continue;
									a3[icoll+j] = a2[icoll+j];
									continue;
								}
								wd = a4[icoll+j] / a3[icoll+j];
								a3[icoll+j]=0;
								if ( wd >= 1 ){
									gzr = a2[icoll+jp1] + (a2[ip1*colonnes+
									                          jp1] - a2[icoll+jp1]) / wd;
									if ( a2[icoll+j] < gzr ) continue;
									gun = a2[icoll+jm1] + (a2[im1*colonnes+
									                          jm1] - a2[icoll+jm1]) / wd;
									if ( a2[icoll+j] <= gun ) continue;
									a3[icoll+j] = a2[icoll+j];
									continue;
								}
								if ( wd >= 0 ){
									gzr = a2[ip1*colonnes+j] + (a2[ip1*
									                               colonnes+jp1] - a2[ip1*colonnes+j]) * wd;
									if ( a2[icoll+j] < gzr ) continue;
									gun = a2[im1*colonnes+j] + (a2[im1*
									                               colonnes+jm1] - a2[im1*colonnes+j]) * wd;
									if ( a2[icoll+j] <= gun ) continue;
									a3[icoll+j] = a2[icoll+j];
									continue;
								}
								if ( wd >= -1){
									icolonnes=ip1*colonnes;
									gzr = a2[icolonnes+j] - (a2[icolonnes+
									                            jm1] - a2[icolonnes+j]) * wd;
									if ( a2[icoll+j] < gzr ) continue;
									icolonnes=im1*colonnes;
									gun = a2[icolonnes+j] - (a2[icolonnes+
									                            jp1] - a2[icolonnes+j]) * wd;
									if ( a2[icoll+j] <= gun ) continue;
									a3[icoll+j] = a2[icoll+j];
									continue;
								}
								gzr = a2[icoll+jm1] - (a2[ip1*colonnes+jm1] - 
										a2[icoll+jm1]) / wd; 
								if ( a2[icoll+j] < gzr )    continue;
								gun = a2[icoll+jp1] - (a2[im1*colonnes+jp1] - 
										a2[icoll+jp1]) / wd;
								if ( a2[icoll+j] <= gun )   continue;
								a3[icoll+j] = a2[icoll+j];
							}
						}

						for(i=0;i< lignes;++i)
							a3[i*colonnes]=0;
						for(i=0;i< lignes;++i)
							a3[i*colonnes+colonnes-1]=0; 
						for(i=0;i< colonnes;++i)
							a3[i]=0;
						for(i=0;i< colonnes;++i)
							a3[colonnes*lig_1+i]=0;

						/* TODO ? transfert au format int */

						img2.setDataXY(ch, Array1DUtil.floatArrayToArray(a3, img2.getDataXY(ch)));
					}
					seqOut.setImage(t,z, img2); 
				}
			}
			seqOut.setName(seq.getFilename()+"Deriche_alpha"+StringUtil.toString(alpha, 2));

			
			
				seqOut.getColorModel().copyColormap(seq.getColorModel());
			
			return(seqOut);


		}


	float Modul (float a , float b){
		return ((float) Math.sqrt(Math.pow(a, 2) + Math.pow(b, 2)));
	}

	@Override
	public void declareInput(VarList inputMap) {
		inputMap.add(input.getVariable()); 
		inputMap.add(alphaValue.getVariable());
		inputMap.add(method.getVariable());
	}

	@Override
	public void declareOutput(VarList outputMap) {
		// TODO Auto-generated method stub
		outputMap.add(output);
	}
}
