package plugins.adufour.activemeshes.mesh;

/**
 * Top-level class for all exceptions occurring in the active meshes framework
 * 
 * @author adufour
 * 
 */
public class MeshException extends RuntimeException
{
	private static final long	serialVersionUID	= 1L;
	
	public final Mesh			mesh;
	
	/**
	 * Creates a new exception occurring on the specified contour
	 * 
	 * @param mesh
	 * @param message
	 */
	public MeshException(Mesh mesh, String message)
	{
		super(message);
		this.mesh = mesh;
	}
}
