package plugins.fab.thresholdedpixeldensity;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.dialog.MessageDialog;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;

import java.io.File;
import java.io.IOException;

import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.thresholder.Thresholder;
import plugins.adufour.vars.util.VarException;

public class ThresholdedPixelDensity extends EzPlug implements Block
{

	Double[] defaultThreshold = { 128d };
	EzVarDouble thresholdVar = new EzVarDouble( "threshold", defaultThreshold , true );
	EzVarInteger channelVar = new EzVarInteger( "channel", 0 , 0 , 100 , 1 );
	EzVarSequence sequenceInput = new EzVarSequence("input Sequence" );
	EzVarFile excelExportFileVar = new EzVarFile( "Excel file", null );
	EzVarSequence sequenceOutput = new EzVarSequence( "threshoded Sequence" );

	void compute(boolean computeInBlock )
	{
		Sequence sequence = sequenceInput.getValue();

		if ( sequence == null )
		{
			String error = "No sequence found as input.";
			if ( computeInBlock )
			{
				throw new VarException( error );
			}else
			{
				MessageDialog.showDialog( error , MessageDialog.ERROR_MESSAGE );
				return;
			}
		}

		if ( sequence.getSizeT() != 1 )
		{
			String error = "The sequence must contain only 1 time point.";
			if ( computeInBlock )
			{
				throw new VarException( error );
			}else
			{
				MessageDialog.showDialog( error , MessageDialog.ERROR_MESSAGE );
				return;
			}
		}

		if ( sequence.getSizeZ() != 1 )
		{
			String error = "The sequence must contain only 1 Z.";
			if ( computeInBlock )
			{
				throw new VarException( error );
			}else
			{
				MessageDialog.showDialog( error , MessageDialog.ERROR_MESSAGE );
				return;
			}
		}

		int channel = channelVar.getValue();
		double threshold = thresholdVar.getValue();

		double[] thresholds = { threshold } ;
		Sequence binaryOutSequence = Thresholder.threshold( sequence , channel , thresholds, false );

		// compute thresholded pixel density for each ROI.

		XlsManager xls = null;
		if ( excelExportFileVar.getValue() != null )
		{
			try {
				xls = new XlsManager( new File( FileUtil.setExtension( excelExportFileVar.getValue().getAbsolutePath() , ".xls" ) ) );
			} catch (IOException e) {

				String error = "Can't create Excel file named: " + excelExportFileVar.getValue();
				if ( computeInBlock )
				{
					throw new VarException( error );
				}else
				{
					MessageDialog.showDialog( error , MessageDialog.ERROR_MESSAGE );
					return;
				}

			}
		}

		if ( excelExportFileVar.getValue() != null )
		{
			xls.createNewPage("Thresholded pixel density");
			writeTitle(xls, "ROI List:");
			int y = xls.getExcelPage().getRows();
			xls.setLabel(0, y, "ROI name" );
			xls.setLabel(1, y, "ROI surface" );
			xls.setLabel(2, y, "pixel over threshold" );
			xls.setLabel(3, y, "density" );
		}

		byte[] binaryBuffer = new byte[binaryOutSequence.getWidth() * binaryOutSequence.getHeight() ];
		Array1DUtil.arrayToArray( binaryOutSequence.getDataXY( 0, 0, 0 ) , binaryBuffer, binaryOutSequence.isSignedDataType() );

//		byte[] binaryBuffer = binaryOutSequence.getDataCopyXYAsByte( 0 , 0 , 0 );

		int width = sequence.getSizeX();
		int height = sequence.getSizeY();

		for ( ROI2D roi2D : sequence.getROI2Ds() )
		{
			System.out.println("---");

			boolean[] bool = roi2D.getAsBooleanMask( 0 , 0 , width , height );

			double surface = 0;
			double pixelOverThreshold = 0;

			for ( int y = (int)roi2D.getBounds2D().getMinY() ; y < roi2D.getBounds2D().getMaxY() ; y++ )
			{
				for ( int x = (int)roi2D.getBounds2D().getMinX() ; x < roi2D.getBounds2D().getMaxX() ; x++ )
				{
					int offset = y*width+ x;

					if ( bool[offset] )
					{
						surface++;
						if ( binaryBuffer[offset] == 1 )
						{
							pixelOverThreshold++;
						}
					}
				}
			}
			System.out.println("surface: " + surface );
			System.out.println("pixel over threshold : " + pixelOverThreshold );

			double density = pixelOverThreshold / surface;

			if ( excelExportFileVar.getValue() != null )
			{
				int y = xls.getExcelPage().getRows();

				xls.setLabel(0, y, roi2D.getName() );
				xls.setNumber(1, y, surface );
				xls.setNumber(2, y, pixelOverThreshold );
				xls.setNumber(3, y, density );
			}
		}

		if ( excelExportFileVar.getValue() != null )
		{
			xls.SaveAndClose();
		}

		// copy ROI from input to output.
		for ( ROI roi : sequence.getROIs() )
		{
			ROI roiCopy = roi.getCopy();
			roiCopy.setColor( roi.getColor() );
			binaryOutSequence.addROI( roiCopy );
		}


		sequenceOutput.setValue( binaryOutSequence );
	}

	@Override
	public void run() {

		compute( true );

	}

	private void writeTitle( XlsManager xls,  String text ) {

		int y = xls.getExcelPage().getRows();
		xls.setLabel( 0 , y++, "--------" );
		xls.setLabel( 0 , y++, text );
		xls.setLabel( 0 , y, "----" );

	}


	public void declareInput(VarList inputMap) {

		inputMap.add( sequenceInput.getVariable() );
		inputMap.add( channelVar.getVariable() );
		inputMap.add( thresholdVar.getVariable() );
		inputMap.add( excelExportFileVar.getVariable() );

	}

	public void declareOutput(VarList outputMap) {

		outputMap.add( sequenceOutput.getVariable() );

	}

	@Override
	public void clean() {

	}

	@Override
	protected void execute() {

		compute( false );

	}

	@Override
	protected void initialize() {

		addEzComponent( thresholdVar );
		addEzComponent( channelVar );
		addEzComponent( sequenceInput );
		addEzComponent( excelExportFileVar );
		addEzComponent( sequenceOutput );

	}



}
