package plugins.fab.splashscreenmaker;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.util.GraphicsUtil;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;

public class SplashScreenMaker extends EzPlug {

	EzVarText line1 = new EzVarText("Plugin name" , "Plugin Name");
	EzVarText line2 = new EzVarText("");
	EzVarSequence varSequence = new EzVarSequence("input Sequence");
	EzVarInteger xOffset = new EzVarInteger("xOffset" );
	EzVarInteger yOffset = new EzVarInteger("yOffset" );
	
	Sequence renderingSequence;
	static int LOGO_WIDTH = 800;
	static int LOGO_HEIGHT = 200;
	
	@Override
	public void clean() {
		
	}

	@Override
	protected void execute() {

		Sequence inputSequence = varSequence.getValue();
		IcyBufferedImage image = null;
		try
		{
			int t = inputSequence.getFirstViewer().getT();
			int z = inputSequence.getFirstViewer().getZ();
			int c = inputSequence.getFirstViewer().getC();
			image = IcyBufferedImage.createFrom(
			inputSequence.getFirstViewer().getCanvas().getRenderedImage(t, z, c , false ) );
		}catch ( Exception e)		
		{
			new AnnounceFrame("Please open a sequence first");
			return;
		}
		if ( image == null ) return;
		
		IcyBufferedImage croppedImage = IcyBufferedImageUtil.getSubImage( image , xOffset.getValue() , yOffset.getValue() , 800, 200 );
		
		buildSplash( croppedImage );
		
		
	}

	private void buildSplash(IcyBufferedImage croppedImage) {
		
		if ( croppedImage==null )
		{
			MessageDialog.showDialog("No image", MessageDialog.ERROR_MESSAGE );
			return;
		}
				
		if ( croppedImage==null || croppedImage.getWidth() != LOGO_WIDTH || croppedImage.getHeight() != LOGO_HEIGHT )
		{
			MessageDialog.showDialog("Cropped image size does not match logo size", MessageDialog.ERROR_MESSAGE );
			return;
		}
		
		IcyBufferedImage renderedImage = new IcyBufferedImage( LOGO_WIDTH, LOGO_HEIGHT, 3, DataType.UBYTE );
		IcyBufferedImage originalLogoImage = IcyBufferedImage.createFrom( getImageResource( "plugins/fab/splashscreenmaker/splash.png" ) );

		
		
		byte alphaBuffer[] = originalLogoImage.getDataXYAsByte( 3 );		
		
		for ( int c = 0 ; c< 3 ; c++ )
		{
			byte originalLogoBuffer[] = originalLogoImage.getDataXYAsByte( c );
			byte croppedImageBuffer[] = croppedImage.getDataXYAsByte( c );
			byte renderBuffer[] = renderedImage.getDataXYAsByte( c );
			
			for ( int i = 0 ; i < originalLogoBuffer.length ; i++ )
			{
				float image = croppedImageBuffer[i] & 0xFF;
				float alpha =  ( alphaBuffer[i] & 0xFF ) / 255f ;
				float logo =  originalLogoBuffer[i] & 0xFF;
				
				float v = alpha * logo + ( 1-alpha ) * image;

				renderBuffer[i] = (byte) (v); 
			}
			
		}
		
		// draw text

		Graphics2D g = (Graphics2D) renderedImage.getGraphics(); 
		g.setColor( Color.WHITE );
		g.setFont( new Font("Arial" , Font.BOLD , 20 ) );
		g.setRenderingHint( RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON );
						
		if ( line2.getValue().isEmpty() )
		{
			Rectangle2D bound1 = GraphicsUtil.getStringBounds( g , line1.getValue() );
		
			int offsetX = 128-(int)(bound1.getWidth() / 2);
			
			
			g.drawString( line1.getValue() , offsetX, 165 );
		
		}else
		{			
			Rectangle2D bound1 = GraphicsUtil.getStringBounds( g , line1.getValue() );
			Rectangle2D bound2 = GraphicsUtil.getStringBounds( g , line2.getValue() );
			
			int offsetX1 = 128-(int)(bound1.getWidth() / 2);
			int offsetX2 = 128-(int)(bound2.getWidth() / 2);
						
			g.drawString( line1.getValue() , offsetX1, 158 );
			g.drawString( line2.getValue() , offsetX2, 185 );
		}
		
		// display
		
		renderedImage.dataChanged();
				
		if ( renderingSequence == null || renderingSequence.getFirstViewer() == null )
		{
			renderingSequence = new Sequence ( "SplashScreen Rendering");
			addSequence( renderingSequence );
		}
		
		renderingSequence.setImage( 0,0 , renderedImage );

		
	}

	@Override
	protected void initialize() {

		EzGroup group1 = new EzGroup( "Input", varSequence , xOffset, yOffset );
		EzGroup group2 = new EzGroup( "Message", line1 , line2 );
				
		addEzComponent( group1 );
		addEzComponent( group2 );
		
	}




}
