package plugins.ylemontag.noisegenerator.noisemodels;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Base class for pixel separable stationary noise models
 * 
 * A noise model is said to be pixel separable and stationary if the random
 * processes that degrades the data at a coordinate (x,y,z,t,c) depends only on
 * the value of the unnoisy sequence at (x,y,z,t,c) (and not on the coordinate
 * (x,y,z,t,c) itself).
 */
public abstract class PixelSeparableStationaryNoise extends PixelSeparableNoise
{
	/**
	 * Constructor
	 */
	protected PixelSeparableStationaryNoise() {}
	
	@Override
	protected double generateNoise(double in, int x, int y, int z, int t, int c)
	{
		return generateNoise(in);
	}
	
	/**
	 * Generate a degraded sample given the value of the clean sample 'in'
	 */
	protected abstract double generateNoise(double in);
}
