package plugins.fab.manualtnt.toremove;

import java.util.ArrayList;



//class to speed up B3 tansform.
//Warning many things are specified in hard, wihtout later control, check validity before using.


/**
 * @author Mr Nicolas Chenouard Ist
 */
public final class B3WT_speedy{
	public static final int pad[] = {2, 4, 8, 16, 32, 64, 128, 256, 512};
	public static final int step[] = {1, 2, 4, 8, 16, 32, 64, 128, 256};
	public static final double w2 = (double)1/16;
	public static final double w1 = (double)1/4;
	public static final double w0 = (double)3/8;


	/*	private int maxScale;
	private MArray arrayi;
	private MArray[] resArray;
	 */
	/*public B3WT_speedy(MArray[] res, MArray array1, int maxScale1)
	{
		arrayi = array1;
		maxScale = maxScale1;
		if (maxScale < 1)
		{
			resArray = new MArray[1];
			resArray[0] = arrayi;
			res = resArray;
			return;
		}
		else
		{
			resArray = new MArray[maxScale];
			//start();
			if(resArray==null) System.out.println("echec resArray");
			res = resArray;
		}
	}*/

	public static MArray[] b3wt(MArray arrayi, int maxScale)
	{
		if (maxScale < 1)
		{
			MArray[] resArray = new MArray[1];
			resArray[0] = arrayi;
			return resArray;
		}
		else
		{
			MArray[] resArray = new MArray[maxScale];
			int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
			int s;
			int padMax = pad[maxScale-1];
			int stepS;

			MArray array1 = arrayi;
			MArray arrayX = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayY = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayZ = new MArray(Types.DOUBLE, width, height, depth);

			int maxSz = 0;
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				if(depth >= 2*pad[s-1]) maxSz = s;
			}

			int cntX, cntY, cntZ;
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				stepS = step[s-1];
				for (int z=0; z<depth; z++)
				{
					for (int y=0; y<height; y++)
					{
						cntX = 0;
						while(cntX < stepS)
						{
							arrayX.set(cntX, y, z, w2* array1.get(2* stepS - cntX-1, y, z) + w1*array1.get(stepS - cntX-1,y,z) + w0*array1.get(cntX,y,z) + w1*array1.get(cntX + stepS,y,z) + w2* array1.get(cntX + 2* stepS,y,z) );						
							cntX++;
						}
						while(cntX < 2*stepS)
						{
							arrayX.set(cntX, y, z, w2* array1.get(2* stepS - cntX-1, y, z) + w1*array1.get(cntX-stepS,y,z) + w0*array1.get(cntX,y,z)+ w1*array1.get(cntX + stepS,y,z) + w2* array1.get(cntX + 2* stepS,y,z) );												
							cntX++;
						}
						while(cntX < width - 2*stepS)
						{	
							arrayX.set(cntX, y, z, w2* array1.get(cntX-2*stepS, y, z) + w1*array1.get(cntX-stepS,y,z) + w0*array1.get(cntX,y,z)+ w1*array1.get(cntX + stepS,y,z) + w2* array1.get(cntX + 2* stepS,y,z) );												
							cntX++;
						}
						while (cntX < width - stepS)
						{
							arrayX.set(cntX, y, z, w2* array1.get(cntX-2*stepS, y, z) + w1*array1.get(cntX-stepS,y,z) + w0*array1.get(cntX,y,z)+ w1*array1.get(cntX + stepS,y,z) + w2* array1.get(2*(width-1)-2*stepS-cntX+1,y,z) );												
							cntX++;
						}
						while (cntX < width)
						{
							arrayX.set(cntX, y, z, w2* array1.get(cntX-2*stepS, y, z) + w1*array1.get(cntX-stepS,y,z) + w0*array1.get(cntX,y,z)+ w1*array1.get(2*(width-1)-stepS-cntX+1,y,z) + w2* array1.get(2*(width-1)-2*stepS-cntX+1,y,z) );												
							cntX++;
						}
					}
				}
				for (int z=0; z<depth; z++)
				{
					//Y axis transforms
					for (int x=0; x<width; x++)
					{
						cntY = 0;
						while(cntY < stepS)
						{
							arrayY.set(x, cntY, z, w2* arrayX.get(x, 2* stepS - cntY-1, z) + w1*arrayX.get(x, stepS - cntY-1,z) + w0*arrayX.get(x,cntY,z) + w1*arrayX.get(x, cntY + stepS,z) + w2* arrayX.get(x,cntY + 2* stepS,z) );						
							cntY++;
						}
						while(cntY < 2*stepS)
						{
							arrayY.set(x, cntY, z, w2* arrayX.get(x, 2* stepS - cntY-1, z) + w1*arrayX.get(x,cntY-stepS,z) + w0*arrayX.get(x,cntY,z) + w1*arrayX.get(x, cntY + stepS,z) + w2* arrayX.get(x,cntY + 2* stepS,z) );						
							cntY++;
						}
						while(cntY < height - 2*stepS)
						{	
							arrayY.set(x, cntY, z, w2* arrayX.get(x,cntY-2*stepS, z) + w1*arrayX.get(x,cntY-stepS,z) + w0*arrayX.get(x,cntY,z) + w1*arrayX.get(x, cntY + stepS,z) + w2* arrayX.get(x,cntY + 2* stepS,z) );						
							cntY++;
						}
						while (cntY < height - stepS)
						{
							arrayY.set(x, cntY, z, w2* arrayX.get(x,cntY-2*stepS, z) + w1*arrayX.get(x,cntY-stepS,z) + w0*arrayX.get(x,cntY,z) + w1*arrayX.get(x, cntY + stepS,z) + w2* arrayX.get(x,2*(height-1)-2*stepS-cntY+1,z) );						
							cntY++;
						}
						while (cntY < height)
						{
							arrayY.set(x, cntY, z, w2* arrayX.get(x,cntY-2*stepS, z) + w1*arrayX.get(x,cntY-stepS,z) + w0*arrayX.get(x,cntY,z) + w1*arrayX.get(x, 2*(height-1)-stepS-cntY+1,z) + w2* arrayX.get(x,2*(height-1)-2*stepS-cntY+1,z) );						
							cntY++;
						}
					}
				}
				if(depth < 2*pad[s-1]) stepS = step[maxSz-1];
				//if(depth >= 2*pad[s-1])
				//{
				for (int x=0; x<width; x++)
				{
					for (int y=0; y<height; y++)
					{
						cntZ = 0;
						while(cntZ<stepS)
						{
							arrayZ.set(x, y, cntZ, w2* arrayY.get(x, y, 2* stepS - cntZ-1) + w1*arrayY.get(x, y, stepS - cntZ-1) + w0*arrayY.get(x, y, cntZ) + w1*arrayY.get(x, y, cntZ + stepS) + w2* arrayY.get(x, y, cntZ + 2* stepS));						
							cntZ++;
						}
						while(cntZ<2*stepS)
						{
							arrayZ.set(x, y, cntZ, w2* arrayY.get(x, y, 2* stepS - cntZ-1) + w1*arrayY.get(x, y, cntZ-stepS) + w0*arrayY.get(x, y, cntZ) + w1*arrayY.get(x, y, cntZ + stepS) + w2* arrayY.get(x, y, cntZ + 2* stepS));						
							cntZ++;
						}
						while(cntZ <depth-2*stepS)
						{
							arrayZ.set(x, y, cntZ, w2* arrayY.get(x, y, cntZ-2*stepS) + w1*arrayY.get(x, y, cntZ-stepS) + w0*arrayY.get(x, y, cntZ) + w1*arrayY.get(x, y, cntZ + stepS) + w2* arrayY.get(x, y, cntZ + 2* stepS));						
							cntZ++;
						}
						while(cntZ <depth-stepS)
						{
							arrayZ.set(x, y, cntZ, w2* arrayY.get(x, y, cntZ-2*stepS) + w1*arrayY.get(x, y, cntZ-stepS) + w0*arrayY.get(x, y, cntZ) + w1*arrayY.get(x, y, cntZ + stepS) + w2* arrayY.get(x, y, 2*(depth-1)-2*stepS-cntZ+1));						
							cntZ++;
						}
						while(cntZ <depth)
						{
							arrayZ.set(x, y, cntZ, w2* arrayY.get(x, y, cntZ-2*stepS) + w1*arrayY.get(x, y, cntZ-stepS) + w0*arrayY.get(x, y, cntZ) + w1*arrayY.get(x, y, 2*(depth-1)-stepS-cntZ+1) + w2* arrayY.get(x, y, 2*(depth-1)-2*stepS-cntZ+1));						
							cntZ++;
						}
					}
				}
				resArray[s-1] = new MArray(arrayZ);
				array1 = arrayZ;
				/*}
				else
				{
					System.out.println("z-axis wavelet scale too large, so no z-transform");
					resArray[s-1] = new MArray(arrayY);
					array1 = arrayY;
				}*/
			}
			return resArray;
		}
	}

	public static boolean isZScalesValid(int maxScale, int depth)
	{
		if(depth <= 2*pad[maxScale-1])
		{
			System.out.println("Z scale was too large for valid Z transform");
			return false;
		}
		return true;
	}

	public static MArray[] b3wtTest(MArray arrayi, int maxScale)
	{
		if (maxScale < 1)
		{
			MArray[] resArray = new MArray[1];
			resArray[0] = arrayi;
			return resArray;
		}
		else
		{
			MArray[] resArray = new MArray[maxScale];
			int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
			int s;
			int padMax = pad[maxScale-1];
			int stepS;
			int wh = width*height;
			MArray array1 = arrayi;
			MArray arrayX = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayY = new MArray(Types.DOUBLE, width, height, depth);
			MArray arrayZ = new MArray(Types.DOUBLE, width, height, depth);

			int maxSz = 0;
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				if(depth >= 2*pad[s-1]) maxSz = s;
			}

			int cntX, cntY, cntZ;
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				stepS = step[s-1];
				int idx0 = 0;
				int w2idx1;
				int w1idx1;
				int w1idx2;
				int w2idx2;
				for (int z=0; z<depth; z++)
				{
					for (int y=0; y<height; y++)
					{
						w1idx1 = idx0 + stepS-1;
						w2idx1 = w1idx1+stepS;
						w1idx2 = idx0+stepS;
						w2idx2 = w1idx2+stepS;

						cntX = 0;
						while(cntX < stepS)
						{
							arrayX.set(idx0, w2* (array1.get(w2idx1)+ array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
							w1idx1--;
							w2idx1--;
							w1idx2++;
							w2idx2++;
							idx0++;
							cntX++;
						}
						w1idx1++;
						while(cntX < 2*stepS)
						{
							arrayX.set(idx0, w2* (array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1) +array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1++;
							w2idx1--;
							w1idx2++;
							w2idx2++;
							idx0++;
							cntX++;
						}
						w2idx1++;
						while(cntX < width - 2*stepS)
						{	
							arrayX.set(idx0, w2*(array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1)+ array1.get(w1idx2))+ w0*array1.get(idx0) );						
							w1idx1++;
							w2idx1++;
							w1idx2++;
							w2idx2++;
							idx0++;
							cntX++;
						}
						w2idx2--;
						while (cntX < width - stepS)
						{
							arrayX.set(idx0, w2* (array1.get(w2idx1)+array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
							w1idx1++;
							w2idx1++;
							w1idx2++;
							w2idx2--;
							idx0++;
							cntX++;
						}
						w1idx2--;
						while (cntX < width)
						{
							arrayX.set(idx0, w2*( array1.get(w2idx1)+array1.get(w2idx2)) + w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
							w1idx1++;
							w2idx1++;
							w1idx2--;
							w2idx2--;
							idx0++;
							cntX++;
						}
					}
				}
				//Y axis transforms
				idx0 = 0;
				int sw = stepS*width;
				for (int z=0; z<depth; z++)
				{
					for (int x=0; x<width; x++)
					{
						idx0 = x + z * wh;
						w1idx1 = idx0 + sw-width;
						w2idx1 = w1idx1 + sw;
						w1idx2 = idx0+sw;
						w2idx2 = w1idx2+sw;
						cntY = 0;
						while(cntY < stepS)
						{
							arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+ arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
							w1idx1-=width;
							w2idx1-=width;
							w1idx2+=width;
							w2idx2+=width;
							idx0+=width;
							cntY++;
						}
						w1idx1+=width;
						while(cntY < 2*stepS)
						{
							arrayY.set(idx0, w2* (arrayX.get(w2idx1)+ arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
							w1idx1+=width;
							w2idx1-=width;
							w1idx2+=width;
							w2idx2+=width;
							idx0+=width;
							cntY++;
						}
						w2idx1+=width;
						while(cntY < height - 2*stepS)
						{	
							arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2) )+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
							w1idx1+=width;
							w2idx1+=width;
							w1idx2+=width;
							w2idx2+=width;
							idx0+=width;
							cntY++;
						}
						w2idx2-=width;
						while (cntY < height - stepS)
						{
							arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
							w1idx1+=width;
							w2idx1+=width;
							w1idx2+=width;
							w2idx2-=width;
							idx0+=width;
							cntY++;
						}
						w1idx2-=width;
						while (cntY < height)
						{
							arrayY.set(idx0, w2*( arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+ arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
							w1idx1+=width;
							w2idx1+=width;
							w1idx2-=width;
							w2idx2-=width;
							idx0+=width;
							cntY++;
						}
					}
				}
				if (maxSz>0)
				{
					if(depth <= 2*pad[s-1])
					{
						stepS = step[maxSz-1];
						sw = stepS*width;
					}
					int swh = sw*height;
					/*if(depth >= 2*pad[s-1])
				{*/
					for (int x=0; x<width; x++)
					{
						for (int y=0; y<height; y++)
						{
							idx0 = x + y*width;
							w1idx1 = idx0 + swh-wh;
							w2idx1 = w1idx1 + swh;
							w1idx2 = idx0+swh;
							w2idx2 = w1idx2+swh;

							cntZ = 0;
							while(cntZ < stepS)
							{
								arrayZ.set(idx0, w2*(arrayY.get(w2idx1)+arrayY.get(w2idx2))+ w1*(arrayY.get(w1idx1)+arrayY.get(w1idx2))+ w0*arrayY.get(idx0));						
								w1idx1-=wh;
								w2idx1-=wh;
								w1idx2+=wh;
								w2idx2+=wh;
								idx0+=wh;
								cntZ++;
							}
							w1idx1+=wh;
							while(cntZ < 2*stepS)
							{
								arrayZ.set(idx0, w2*(arrayY.get(w2idx1)+ arrayY.get(w2idx2))+ w1*(arrayY.get(w1idx1)+arrayY.get(w1idx2))+ w0*arrayY.get(idx0));						
								w1idx1+=wh;
								w2idx1-=wh;
								w1idx2+=wh;
								w2idx2+=wh;
								idx0+=wh;
								cntZ++;
							}
							w2idx1+=wh;
							while(cntZ < depth - 2*stepS)
							{	
								arrayZ.set(idx0, w2*(arrayY.get(w2idx1)+arrayY.get(w2idx2))+ w1*(arrayY.get(w1idx1)+ arrayY.get(w1idx2))+ w0*arrayY.get(idx0));						
								w1idx1+=wh;
								w2idx1+=wh;
								w1idx2+=wh;
								w2idx2+=wh;
								idx0+=wh;
								cntZ++;
							}
							w2idx2-=wh;
							while (cntZ < depth - stepS)
							{
								arrayZ.set(idx0, w2*(arrayY.get(w2idx1)+arrayY.get(w2idx2))+ w1*(arrayY.get(w1idx1)+arrayY.get(w1idx2))+ w0*arrayY.get(idx0));						
								w1idx1+=wh;
								w2idx1+=wh;
								w1idx2+=wh;
								w2idx2-=wh;
								idx0+=wh;
								cntZ++;
							}
							w1idx2-=wh;
							while (cntZ < depth)
							{
								arrayZ.set(idx0, w2*(arrayY.get(w2idx1)+ arrayY.get(w2idx2) )+ w1*(arrayY.get(w1idx1)+arrayY.get(w1idx2))+ w0*arrayY.get(idx0));						
								w1idx1+=wh;
								w2idx1+=wh;
								w1idx2-=wh;
								w2idx2-=wh;
								idx0+=wh;
								cntZ++;
							}
						}
					}
					resArray[s-1] = new MArray(arrayZ);
					array1 = arrayZ;
				}
				else
				{
					System.out.println("z-axis wavelet scale too large, so no z-transform");
					resArray[s-1] = new MArray(arrayY);
					array1 = arrayY;
				}
			}
			return resArray;
		}
	}


//	public static double[][] b3wtXY(double[][] data, int width, int height, int depth, int maxScale)
//	{
//		if (maxScale < 1)
//		{
//			return null;
//		}
//		else
//		{
//			boolean parralel = true;
//
//			double[][] resArray = new double[maxScale][];
//			for (int s =0; s<maxScale; s++)
//				resArray[s]  = new double[width*height*depth];
//			ArrayList<Thread> thrList = new ArrayList<Thread>(depth);
//			for (int i =0; i < depth; i++)
//			{
//				Thread thr = new WaveletTransform2DTabThread(data[i], width, height, i, maxScale); 
//				thrList.add(thr);
//				thr.start();
//				if (!parralel)
//					try {
//						thr.join();
//					} catch (InterruptedException e) {
//						e.printStackTrace();
//					}
//			}
//			for (Thread thr:thrList)
//				try {
//					thr.join();
//					for (int s = 0; s < maxScale; s++)
//						System.arraycopy(((double[])((WaveletTransform2DTabThread)thr).res[s]), 0, (double[])resArray[s], width*height*((WaveletTransform2DTabThread)thr).z, width*height);
//				} catch (InterruptedException e) {
//					e.printStackTrace();
//				}
//				return resArray;
//		}
//	}
	
//	public static double[][] b3wt2D(double[] data, int width, int height, int maxScale)
//	{
//		if (maxScale < 1)
//		{
//			return null;
//		}
//		else
//		{
//			double[][] resArray = new double[maxScale][];
//			for (int s =0; s<maxScale; s++)
//				resArray[s]  = new double[width*height];
//			Thread thr = new WaveletTransform2DTabThread(data, width, height, 0, maxScale); 
//			thr.start();
//					try {
//						thr.join();
//					} catch (InterruptedException e) {
//						e.printStackTrace();
//					}
//			for (int s = 0; s < maxScale; s++)
//				System.arraycopy(((double[])((WaveletTransform2DTabThread)thr).res[s]), 0, (double[])resArray[s], 0, width*height);
//			return resArray;
//		}
//	}

	public static MArray[] b3wtXY(MArray arrayi, int maxScale)
	{
//		long l1 = System.currentTimeMillis();
		if (maxScale < 1)
		{
			MArray[] resArray = new MArray[1];
			resArray[0] = arrayi;
			return resArray;
		}
		else
		{
			boolean parralel = true;
			if (parralel)
			{
				MArray[] resArray = new MArray[maxScale];
				int depth = arrayi.getDimSize(2);
				for (int s =0; s<maxScale; s++)
					resArray[s]  = new MArray(Types.DOUBLE, arrayi.getDimSize(0), arrayi.getDimSize(1), depth);
				ArrayList<Thread> thrList = new ArrayList<Thread>(depth);
				for (int i =0; i < depth; i++)
				{
					Thread thr = new WaveletTransform2DThread(arrayi, i, maxScale, resArray); 
					thrList.add(thr);
					thr.start();
				}
				for (Thread thr:thrList)
					try {
						thr.join();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
//					long l2 = System.currentTimeMillis();
//					System.out.println("elapse : "+(l1-l2));
					return resArray;
			}
			else
			{
				MArray[] resArray = new MArray[maxScale];
				int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
				int s;
				int stepS;
				int wh = width*height;
				MArray array1 = arrayi;
				MArray arrayX = new MArray(Types.DOUBLE, width, height, depth);
				MArray arrayY = new MArray(Types.DOUBLE, width, height, depth);

				int cntX, cntY;
				for (s = 1; s <= maxScale; s++)//for each scale
				{
					stepS = step[s-1];
					int idx0 = 0;
					int w2idx1;
					int w1idx1;
					int w1idx2;
					int w2idx2;
					for (int z=0; z<depth; z++)
					{
						for (int y=0; y<height; y++)
						{
							w1idx1 = idx0 + stepS-1;
							w2idx1 = w1idx1+stepS;
							w1idx2 = idx0+stepS;
							w2idx2 = w1idx2+stepS;

							cntX = 0;
							while(cntX < stepS)
							{
								arrayX.set(idx0, w2* (array1.get(w2idx1)+ array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
								w1idx1--;
								w2idx1--;
								w1idx2++;
								w2idx2++;
								idx0++;
								cntX++;
							}
							w1idx1++;
							while(cntX < 2*stepS)
							{
								arrayX.set(idx0, w2* (array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1) +array1.get(w1idx2))+ w0*array1.get(idx0));						
								w1idx1++;
								w2idx1--;
								w1idx2++;
								w2idx2++;
								idx0++;
								cntX++;
							}
							w2idx1++;
							while(cntX < width - 2*stepS)
							{	
								arrayX.set(idx0, w2*(array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1)+ array1.get(w1idx2))+ w0*array1.get(idx0) );						
								w1idx1++;
								w2idx1++;
								w1idx2++;
								w2idx2++;
								idx0++;
								cntX++;
							}
							w2idx2--;
							while (cntX < width - stepS)
							{
								arrayX.set(idx0, w2* (array1.get(w2idx1)+array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
								w1idx1++;
								w2idx1++;
								w1idx2++;
								w2idx2--;
								idx0++;
								cntX++;
							}
							w1idx2--;
							while (cntX < width)
							{
								arrayX.set(idx0, w2*( array1.get(w2idx1)+array1.get(w2idx2)) + w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
								w1idx1++;
								w2idx1++;
								w1idx2--;
								w2idx2--;
								idx0++;
								cntX++;
							}
						}
					}
					//Y axis transforms
					idx0 = 0;
					int sw = stepS*width;
					for (int z=0; z<depth; z++)
					{
						for (int x=0; x<width; x++)
						{
							idx0 = x + z * wh;
							w1idx1 = idx0 + sw-width;
							w2idx1 = w1idx1 + sw;
							w1idx2 = idx0+sw;
							w2idx2 = w1idx2+sw;
							cntY = 0;
							while(cntY < stepS)
							{
								arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+ arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
								w1idx1-=width;
								w2idx1-=width;
								w1idx2+=width;
								w2idx2+=width;
								idx0+=width;
								cntY++;
							}
							w1idx1+=width;
							while(cntY < 2*stepS)
							{
								arrayY.set(idx0, w2* (arrayX.get(w2idx1)+ arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
								w1idx1+=width;
								w2idx1-=width;
								w1idx2+=width;
								w2idx2+=width;
								idx0+=width;
								cntY++;
							}
							w2idx1+=width;
							while(cntY < height - 2*stepS)
							{	
								arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2) )+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
								w1idx1+=width;
								w2idx1+=width;
								w1idx2+=width;
								w2idx2+=width;
								idx0+=width;
								cntY++;
							}
							w2idx2-=width;
							while (cntY < height - stepS)
							{
								arrayY.set(idx0, w2* (arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
								w1idx1+=width;
								w2idx1+=width;
								w1idx2+=width;
								w2idx2-=width;
								idx0+=width;
								cntY++;
							}
							w1idx2-=width;
							while (cntY < height)
							{
								arrayY.set(idx0, w2*( arrayX.get(w2idx1)+arrayX.get(w2idx2))+ w1*(arrayX.get(w1idx1)+ arrayX.get(w1idx2))+ w0*arrayX.get(idx0));						
								w1idx1+=width;
								w2idx1+=width;
								w1idx2-=width;
								w2idx2-=width;
								idx0+=width;
								cntY++;
							}
						}
					}
					resArray[s-1] = new MArray(arrayY);
					array1 = arrayY;
				}

//				long l2 = System.currentTimeMillis();
//				System.out.println("elapse : "+(l1-l2));
				return resArray;
			}
		}
	}
	public static MArray[] b3wtZ(MArray arrayi, int maxScale)
	{
		if (maxScale < 1)
		{
			MArray[] resArray = new MArray[1];
			resArray[0] = arrayi;
			return resArray;
		}
		else
		{
			MArray[] resArray = new MArray[maxScale];
			int width = arrayi.getDimSize(0), height = arrayi.getDimSize(1), depth = arrayi.getDimSize(2);
			int s;
			int padMax = pad[maxScale-1];
			int stepS;
			int wh = width*height;
			MArray array1 = arrayi;
			MArray arrayZ = new MArray(Types.DOUBLE, width, height, depth);

			int cntZ;
			for (s = 1; s <= maxScale; s++)//for each scale
			{
				stepS = step[s-1];
				int sw = stepS*width;
				int swh = sw*height;
				int idx0, w1idx1, w2idx1, w1idx2, w2idx2;
				for (int x=0; x<width; x++)
				{
					for (int y=0; y<height; y++)
					{
						idx0 = x + y*width;
						w1idx1 = idx0 + swh-wh;
						w2idx1 = w1idx1 + swh;
						w1idx2 = idx0+swh;
						w2idx2 = w1idx2+swh;

						cntZ = 0;
						while(cntZ < stepS)
						{
							arrayZ.set(idx0, w2*(array1.get(w2idx1)+array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1-=wh;
							w2idx1-=wh;
							w1idx2+=wh;
							w2idx2+=wh;
							idx0+=wh;
							cntZ++;
						}
						w1idx1+=wh;
						while(cntZ < 2*stepS)
						{
							arrayZ.set(idx0, w2*(array1.get(w2idx1)+ array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1+=wh;
							w2idx1-=wh;
							w1idx2+=wh;
							w2idx2+=wh;
							idx0+=wh;
							cntZ++;
						}
						w2idx1+=wh;
						while(cntZ < depth - 2*stepS)
						{	
							arrayZ.set(idx0, w2*(array1.get(w2idx1)+array1.get(w2idx2))+ w1*(array1.get(w1idx1)+ array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1+=wh;
							w2idx1+=wh;
							w1idx2+=wh;
							w2idx2+=wh;
							idx0+=wh;
							cntZ++;
						}
						w2idx2-=wh;
						while (cntZ < depth - stepS)
						{
							arrayZ.set(idx0, w2*(array1.get(w2idx1)+array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1+=wh;
							w2idx1+=wh;
							w1idx2+=wh;
							w2idx2-=wh;
							idx0+=wh;
							cntZ++;
						}
						w1idx2-=wh;
						while (cntZ < depth)
						{
							arrayZ.set(idx0, w2*(array1.get(w2idx1)+ array1.get(w2idx2) )+ w1*(array1.get(w1idx1)+array1.get(w1idx2))+ w0*array1.get(idx0));						
							w1idx1+=wh;
							w2idx1+=wh;
							w1idx2-=wh;
							w2idx2-=wh;
							idx0+=wh;
							cntZ++;
						}
					}
				}
				resArray[s-1] = new MArray(arrayZ);
				array1 = arrayZ;
			}
			return resArray;
		}
	}



}
