package plugins.fab.manualtnt.toremove;

public class WaveletTransform2DThread extends Thread
{
	final double[][] res;
	final double[] datai;
	final int z;
	final int width;
	final int height;
	final int maxScale;
	final MArray[] resArray;
	final int pad[] = B3WT_speedy.pad;
	final int step[] = B3WT_speedy.step;
	final double w2 = B3WT_speedy.w2;
	final double w1 = B3WT_speedy.w1;
	final double w0 = B3WT_speedy.w0;
	
	WaveletTransform2DThread(MArray arrayi, int z, int maxScale, MArray[] resArray)
	{
		this.z = z;
		res = new double[maxScale][];
		this.width = arrayi.getDimSize(0);
		this.height = arrayi.getDimSize(1);
		datai = new double[width*height];
		for (int j = 0; j < height; j++)
			for (int i = 0; i < width; i++)
				datai[i+width*j] = arrayi.get(i,j,z);	
		this.maxScale = maxScale;
		this.resArray = resArray;
	}
	
	@Override
	public void run()
	{
		int cntX, cntY;
		int stepS;
		int wh = width*height;
		double[] arrayX = new double[wh];
		double[] arrayY = new double[wh];
		double[] array1 =datai;
		
		for (int s = 1; s <= maxScale; s++)//for each scale
		{
			stepS = step[s-1];
			int idx0 = 0;
			int w2idx1;
			int w1idx1;
			int w1idx2;
			int w2idx2;
			
			for (int y=0; y<height; y++)
				{
					w1idx1 = idx0 + stepS-1;
					w2idx1 = w1idx1+stepS;
					w1idx2 = idx0+stepS;
					w2idx2 = w1idx2+stepS;

					cntX = 0;
					while(cntX < stepS)
					{
						//arrayX.set(idx0, w2* (array1.get(w2idx1)+ array1.get(w2idx2))+ w1*(array1.get(w1idx1)+array1.get(w1idx2)) + w0*array1.get(idx0));						
						arrayX[idx0]  = w2* (array1[w2idx1]+ array1[w2idx2])+ w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];													
						w1idx1--;
						w2idx1--;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w1idx1++;
					while(cntX < 2*stepS)
					{
//						arrayX.set(idx0, w2* (array1.get(w2idx1) + array1.get(w2idx2))+ w1*(array1.get(w1idx1) +array1.get(w1idx2))+ w0*array1.get(idx0));						
						arrayX[idx0] =  w2* (array1[w2idx1] + array1[w2idx2])+ w1*(array1[w1idx1] +array1[w1idx2])+ w0*array1[idx0];													
						w1idx1++;
						w2idx1--;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w2idx1++;
					while(cntX < width - 2*stepS)
					{	
						arrayX[idx0] = w2*(array1[w2idx1] + array1[w2idx2])+ w1*(array1[w1idx1]+ array1[w1idx2])+ w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2++;
						w2idx2++;
						idx0++;
						cntX++;
					}
					w2idx2--;
					while (cntX < width - stepS)
					{
						arrayX[idx0] =  w2*(array1[w2idx1]+array1[w2idx2])+ w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2++;
						w2idx2--;
						idx0++;
						cntX++;
					}
					w1idx2--;
					while (cntX < width)
					{
						arrayX[idx0] =  w2*(array1[w2idx1]+array1[w2idx2]) + w1*(array1[w1idx1]+array1[w1idx2]) + w0*array1[idx0];						
						w1idx1++;
						w2idx1++;
						w1idx2--;
						w2idx2--;
						idx0++;
						cntX++;
					}
				}
			//Y axis transforms
			idx0 = 0;
			int sw = stepS*width;
				for (int x=0; x<width; x++)
				{
					idx0 = x;// + z * wh;
					w1idx1 = idx0 + sw-width;
					w2idx1 = w1idx1 + sw;
					w1idx2 = idx0+sw;
					w2idx2 = w1idx2+sw;
					cntY = 0;
					while(cntY < stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+ arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1-=width;
						w2idx1-=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w1idx1+=width;
					while(cntY < 2*stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+ arrayX[w2idx2])+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1-=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w2idx1+=width;
					while(cntY < height - 2*stepS)
					{	
						arrayY[idx0] = w2* (arrayX[w2idx1]+arrayX[w2idx2] )+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2+=width;
						w2idx2+=width;
						idx0+=width;
						cntY++;
					}
					w2idx2-=width;
					while (cntY < height - stepS)
					{
						arrayY[idx0] =  w2* (arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2+=width;
						w2idx2-=width;
						idx0+=width;
						cntY++;
					}
					w1idx2-=width;
					while (cntY < height)
					{
						arrayY[idx0] =  w2*( arrayX[w2idx1]+arrayX[w2idx2])+ w1*(arrayX[w1idx1]+ arrayX[w1idx2])+ w0*arrayX[idx0];						
						w1idx1+=width;
						w2idx1+=width;
						w1idx2-=width;
						w2idx2-=width;
						idx0+=width;
						cntY++;
					}
				}
				res[s-1] = arrayY;
				array1 = arrayY;
				arrayY = new double[wh];
		}
		for (int s = 0; s < maxScale;s++)
		{
			synchronized(resArray[s])
			{
				MArray array =resArray[s];
				for (int j = 0; j < height; j++)
					for (int i = 0; i < width; i++)
						 array.set(i,j,z, res[s][i+width*j]);
			}
		}
	}
}