package plugins.lagache.spatialanalysis;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import icy.file.FileUtil;
import icy.file.xls.XlsManager;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.plugin.abstract_.Plugin;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI2DPolygon;
import icy.roi.ROI2DRectangle;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import icy.util.ShapeUtil.BooleanOperator;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarDoubleArrayNative;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSwimmingObject;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarDoubleArrayNative;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

// Colocalisation with Ripley function K
// Significant 

public class SpatialAnalysisBlock extends Plugin implements Block {	
				
	
	//EzVarSwimmingObject<DetectionResult> detections = new EzVarSwimmingObject<DetectionResult>("Detections");
	VarROIArray	detection_roi		= new VarROIArray("List of detection ROIs");
	VarSequence input_sequence = new VarSequence("Input sequence", null);

	 //VarDouble pas = new VarDouble("Step" , 1, 1, 100, 1);
	VarDouble pas = new VarDouble("Step (in pixels)", 1);
	 VarDouble mindist = new VarDouble("Min. Radius (in pixels)", 0);
	 VarDouble maxdist =  new VarDouble("Max. Radius (in pixels)", 5);

	
	
	//VarDoubleArrayNative K = new VarDoubleArrayNative("Ripley", null, false);
	 VarDoubleArrayNative K = new VarDoubleArrayNative("Ripley", null);
	
	VarDouble confidence_level = new VarDouble("Confidence level", 0.99); 
	VarDoubleArrayNative quantile_bas = new VarDoubleArrayNative("Quantile bas", null);
	VarDoubleArrayNative quantile_haut = new VarDoubleArrayNative("Quantile_haut", null);
	 
	double d_min = 1; // pixels
	double d_max = 5;
	double dist_tab[] = null;
	
    VarFile                             exportExcelFile        = new VarFile("Excel File", null);
	
	

	@Override
	public void declareInput(VarList inputMap)
	{
		inputMap.add("Detections (ROIs)", detection_roi);
		inputMap.add("Input Sequence", input_sequence);
		inputMap.add("Step ",pas);
		inputMap.add("Min. radius (pixels) ",mindist);
		inputMap.add("Max. radius (pixels) ",maxdist);	
		inputMap.add("Level of confidence",confidence_level);
		inputMap.add( exportExcelFile );
		
			}

	@Override
	public void declareOutput(VarList outputMap)
	{		
		outputMap.add("Low quantile",quantile_bas);
		outputMap.add("High quantile",quantile_haut);		
	}


	
	
	// N: nb entre dmin et dmax avec pas donne
	@Override
	public void run() {
		if (detection_roi == null) {
			new AnnounceFrame("Please first select a detection set");
			return;
		} else {			
			Vector<Spot> detection = new Vector<Spot>();
			
			for (ROI roi:detection_roi.getValue())
			{
				Point2D p = getMassCenter((ROI2D) roi);				
				Spot spot=new Spot(p.getX(),p.getY(),0);				
				detection.add(spot);
			}
						
			if (detection.size() == 0) {
				new AnnounceFrame("There is no detections associated with the ROI");
				return;
			} else {
				if (mindist.getValue()>maxdist.getValue())
					{new AnnounceFrame("min radius must be less than max radius");
				return;}
				else
				{
					if (pas.getValue()>(maxdist.getValue()-mindist.getValue()))
					{new AnnounceFrame("step must be less than (max radius-min radius)");
				return;}
					else				
				performAnalysis(detection, mindist, maxdist, pas, input_sequence,exportExcelFile);// detections.getSequence()
																						// );
			}}
		}
	}

	private void performAnalysis(Vector<Spot> detection, VarDouble min, VarDouble max, VarDouble pas,VarSequence input_sequence, VarFile Excel) {
		// refinement des spots avec local maxima si possible
									
		Sequence sequence=input_sequence.getValue();
		// gestion de plusieurs ROIs
		 ArrayList<ROI2D>    roiArrayList = sequence.getROI2Ds();
		 //TODO Ou sont les ROIs???
		 if (roiArrayList.size()==0){
				Polygon polygon = new Polygon();
				polygon.addPoint(0, 0);
				polygon.addPoint(0, sequence.getWidth());
				polygon.addPoint(sequence.getHeight(), sequence.getWidth());
				polygon.addPoint(sequence.getHeight(), 0);
			 ROI2DPolygon roitmp= new ROI2DPolygon();
			 roitmp.setPolygon(polygon);					 
			 roiArrayList.add(roitmp);
		 }
		
		 //on initialise les parametres intemporels en t=0
		//initialisation 									 		
			 //construction des Hashmaps avec les detections au temps 0
			HashMap<ROI2D, Vector<Spot>> ROI2Detection  = detectionsInRoi(sequence, detection, roiArrayList);		
			
			//calcul des parametres globaux: aire et perimetres totaux des rois et nb de detections
			double area = 0;
			double perimeter=0;
			int nbdet = detection.size();
			
			for (ROI2D roi : ROI2Detection.keySet()) {
				area=area+Roiarea(roi);
				perimeter=perimeter+roi.getPerimeter();
			}
			
			//construction du distance_tab pour calculer la p_value de coloc							

			// initialisation possible de la sauvegarde
			double temp = (max.getValue() - min.getValue()) / pas.getValue();
			int N = (int) temp;
			dist_tab = new double[N];
			for (int u = 0; u < N; u++) {
				dist_tab[u] = min.getValue() + u * pas.getValue();
			}
			
				
				ROI2Detection  = detectionsInRoi(sequence, detection, roiArrayList);											
		
		//mise  jour du nb de detections a et b au temps t
		nbdet=detection.size();
					
		//////////////////////////////////////////////////////////								
		// calcul de la fonction de Ripley et des quantiles
		
		// calcul de la fonction de Ripley
			double[] Ktemp = new double[N];			
			Ktemp = corrfunction(ROI2Detection, area, nbdet, N);
			double[] var = new double[N];
			
			var = variance_theo(area, perimeter, nbdet, N);
			double[] skew = new double[N];
			skew = skew_theo(area, perimeter, nbdet, N);
			double[] kurt = new double[N];
			kurt = kurt_theo(area,perimeter,nbdet,N);
			
 
			double[] Y = new double[N];
			
			double[] skew_Y = new double[N];
			double[] kurt_Y = new double[N];
			double[] q_bas = new double[N];
			double[] q_haut = new double[N];
			
			//double z_bas=-2.32;
			//double z_haut=2.32;
			double z_bas=NormInv.compute(1-confidence_level.getValue(), 0, 1);
			double z_haut=NormInv.compute(confidence_level.getValue(), 0, 1);
			
			double tempi=0;
			for (int p = 0; p < N; p++) {
				Y[p] = (Ktemp[p] - Math.PI*Math.pow(dist_tab[p],2)) / Math.sqrt(var[p]);				
				skew_Y[p]=skew[p]/Math.pow(var[p],1.5);
				kurt_Y[p]=kurt[p]/Math.pow(var[p], 2);				
				//calcul des quantiles avec la formule de Cornish Fisher
				q_bas[p]=z_bas+((z_bas*z_bas-1)*skew_Y[p])/6+((z_bas*z_bas*z_bas-3*z_bas)*(kurt_Y[p]-3))/24-((2*z_bas*z_bas*z_bas-5*z_bas)*skew_Y[p]*skew_Y[p])/36;
				q_haut[p]=z_haut+((z_haut*z_haut-1)*skew_Y[p])/6+(z_haut*z_haut*z_haut-3*z_haut)*(kurt_Y[p]-3)/24-((2*z_haut*z_haut*z_haut-5*z_haut)*skew_Y[p]*skew_Y[p])/36;
			}
			
			K.setValue(Y);
			quantile_bas.setValue(q_bas);
			quantile_haut.setValue(q_haut);
			
			//sauvegarde Excel
XlsManager xls = null;
			
			if ( exportExcelFile.getValue() == null ) return;		
			System.out.println("You need to set an Excel File for output.");
			
			File xlsFile = new File ( FileUtil.setExtension( exportExcelFile.getValue().getAbsolutePath() , ".xls" ) );
			
			try {
				xls = new XlsManager( xlsFile );
			} catch (IOException e) {
				throw new VarException("Can't write XLS file. File already opened ?");
			}

			int row=0;						 			
			xls.createNewPage("Results ");
			 			 
				xls.setLabel( 0 , 0 , "Date of XLS page:" );
				row++;
				xls.setLabel( 0 , row , new Date().toString() );
				row++;
				xls.setLabel( 0 , row , "r min" );xls.setLabel( 1 , row , "r max" );xls.setLabel( 2 , row , "step dr" );
				row++;
				xls.setNumber( 0 , row , min.getValue() );xls.setNumber( 1 , row , max.getValue() );xls.setNumber( 2 , row , pas.getValue() );				
				row++;
				xls.setLabel( 0 , row , "r" );
				xls.setLabel( 1 , row , "K(r)" );
				//xls.setLabel( 2 , row , "var(K)" );
				//xls.setLabel( 3 , row , "skew(Y)" );
				//xls.setLabel( 4 , row , "kurt(Y)" );
				xls.setLabel( 2 , row , "quantile_bas" );
				xls.setLabel( 3 , row , "quantile_haut" );
				row++ ;
			
						for (int p = 0; p < N; p++) {
							tempi=Math.PI*dist_tab[p]*dist_tab[p]*Math.sqrt(var[p]);
							xls.setNumber( 0 , row , min.getValue()+p*pas.getValue() );
							xls.setNumber( 1 , row , Y[p] );
							//xls.setNumber( 2 , row , var[p] );
							//xls.setNumber( 3 , row , skew[p]/(tempi*tempi*tempi) );
							//xls.setNumber( 4 , row , kurt[p]/(tempi*tempi*tempi*tempi) );
							xls.setNumber( 2 , row , q_bas[p] );
							xls.setNumber( 3 , row , q_haut[p] );
							row++ ;					
						}
						xls.SaveAndClose();
						//fin de la fonction perform analysis
			}
		
			//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////
	//

	// Calcul de la fonction de correlation (Ripley)
	private double[] corrfunction(HashMap<ROI2D, Vector<Spot>> ROI2Detection,double area, int nb_a,int N)	
	{
				
		
		double K[] = new double[N];
		int l=ROI2Detection.size();
		double K_tab[][] = new double[N][l];
		int inc=0;
		double CST = 0.0001;
		
		//on fait la boucle sur toutes les rois pour incrmenter le calcul de la fonction de Ripley
		
		for (ROI2D roi : ROI2Detection.keySet()) {
			
			Vector<Spot> spots = ROI2Detection.get(roi);		
			BooleanMask2D ma = roi.getAsBooleanMask(true);
			ArrayList<Point> polyg = getEdgePoints(ma);
			//il faut definir le nb local (par ROI) de detections afin de construire les boucles
			int nbdeta=spots.size();		
			
			for (int p = 0; p < nbdeta; p++) {
			double weight = 1;
			// distance du point a au bord de la ROI (polygon)
			Point pt1 = new Point((int) spots.get(p).mass_center.x, (int) spots.get(p).mass_center.y);
			
			double d = distance2Polygon(pt1, polyg);
			
			for (int p2 = 0; p2 < nbdeta; p2++) {
				Point pt2 = new Point((int) spots.get(p2).mass_center.x, (int) spots.get(p2).mass_center.y);
				double temp = pt1.distance(pt2);
				if (temp > CST) {
					// Calcul du poids (Ripley)
					weight = 1;
					if (d < temp) {
						weight = 1 - (Math.acos(d / temp)) / Math.PI;
					}
					for (int k = 0; k < N; k++) {
						if (temp < dist_tab[k]) {
							K[k] = K[k] + (1 / weight) * area / (nb_a * (nb_a - 1));
							K_tab[k][inc]=K_tab[k][inc]+(1 / weight)*area / (nb_a * (nb_a - 1));
						}
					}
				}
				}
			}
		inc=inc+1;		
		}
		
		return K;
	
		}


	// variance theorique

	private double[] variance_theo(double aire, double perimeter,int nb_a,int N){		
		double var[] = new double[N];
		for (int k = 0; k < N; k++) {
			double d2 = Math.pow(dist_tab[k], 2);
			double d3 = Math.pow(dist_tab[k], 3);
			double d4 = Math.pow(dist_tab[k], 4);
			double d5 = Math.pow(dist_tab[k], 5);

			var[k] = 2 * Math.pow(aire, 2) / (nb_a * (nb_a - 1)) * (Math.PI * d2 / aire + 0.96 * perimeter * d3 / Math.pow(aire, 2)  - Math.PI * Math.PI * d4 / (aire * aire) + (nb_a - 2) * 0.13 * perimeter * d5 / (aire * aire * aire));			                                                                         
		}
		return var;
	}
	private double[] skew_theo(double aire, double perimeter,int size,int N){ 

		double[] skew=new double[N];
		double alpha_2=size*(size-1);
        double alpha_3=alpha_2*(size-2);
        double alpha_4=alpha_3*(size-3);

		for (int k = 0; k < N; k++) {
			double d2 = Math.pow(dist_tab[k], 2);
			double e=Math.PI*d2;
			double betaa=e/aire;
	        double b=perimeter*dist_tab[k]/aire;
	    
	        //calcul du skew
	        //formule pour tout n
	        double t1=betaa*(1+0.76*b);
	        double t2=betaa*betaa*((-3+1.173*alpha_3/alpha_2)+(-0.915+alpha_3/alpha_2*0.414)*b);
	        double t3=betaa*betaa*betaa*(-2*alpha_3/alpha_2+0.012*alpha_4/alpha_2*b);
	        skew[k]=t1+t2+t3;
	        double a3=aire*aire*aire;
	        
	        double sizi=Math.pow(size*(size-1), 2);
	        skew[k]=(skew[k]*4*a3)/sizi;	        			        
		}
		return skew;
	}
	
	private double[] kurt_theo(double aire, double perimeter,int size,int N) {

		double[] kurt=new double[N];
		
		double alpha_2=size*(size-1);
        double alpha_3=alpha_2*(size-2);
        double alpha_4=alpha_3*(size-3);
        double alpha_5=alpha_4*(size-4);
        double alpha_6=alpha_5*(size-5);

		for (int k = 0; k < N; k++) {
			double d2 = dist_tab[k] * dist_tab[k];
			double e=Math.PI*d2;
			double betaa=e/aire;
	        double b=perimeter*dist_tab[k]/aire;
	        
	        
	        
	        //calcul du kurtosis
	        //formule pour tout n
	        /*double I1=betaa*(8+11.52*b);
	        double I2=betaa*betaa*((-32+104.3*(alpha_3/alpha_2)+12*(alpha_4/alpha_2))+(-24.32+78.7*(alpha_3/alpha_2)+7.32*(alpha_4/alpha_2))*b+(1.116*(alpha_4/alpha_2))*b*b);
	        double I3=betaa*betaa*betaa*((48-304.3*alpha_3/alpha_2-1.92*alpha_4/alpha_2)+(14.784-97.9*(alpha_3/alpha_2)+2.69*(alpha_4/alpha_2)+0.317*(alpha_5/alpha_2))*b+((alpha_5/alpha_2)*0.0966)*b*b);
	        double I4=betaa*betaa*betaa*betaa*(-36*(alpha_4/alpha_2)+0.0021*(alpha_6/alpha_2)*b*b);
	        */
	        double I1=betaa*(8+11.52*b);
	        double I2=betaa*betaa*size*((104.3+12*size)+(78.7+7.32*size)*b+(1.116*size)*b*b);
	        double I3=betaa*betaa*betaa*size*((-304.3-1.92*size)+(-97.9+2.69*size+0.317*Math.pow(size, 2))*b+(Math.pow(size, 2)*0.0966)*b*b);
	        double I4=betaa*betaa*betaa*betaa*Math.pow(size, 2)*(-36+0.0021*Math.pow(size, 2)*b*b);
	        
	        
	        kurt[k]=I1+I2+I3+I4;	       	       
	        double a4=aire*aire*aire*aire;
	        double s1=size-1;
	        double sizi=Math.pow(size*(size-1), 3);
	        kurt[k]=(kurt[k]*a4)/sizi;	        
	        
		}
		return kurt;

	}

	private double distance(Point mass_center, Point mass_center2) {
		return mass_center.distance(mass_center2);
	}

	/*
	 * private void var_K_theo(int N, int n_a, int n_b, double []dist_tab){
	 * 
	 * double [][] D_a= new double[n_a][n_a];
	 * 
	 * double [][][] A_a= new double[n_a][n_a][N]; double [][] h_a= new
	 * double[n_a][N];
	 * 
	 * // double [][] Aire= new double[n_e][N];
	 * 
	 * for (int k=0; k<N; k++) { for (int i=0; i<n_a; i++){ for (int j=i; j<n_a;
	 * j++){ D_a[i][j] = distance(pta , ptb ); // for (int t=0; t<N; t++){
	 * D_a[j][i] = D_a[i][j]; if (D_a[i][j]<2*dist_tab[k]){ A_a[i][j][k] =
	 * 2*dist_tab[k]*dist_tab[k] * Math.acos(D_a[i][j]/(2*dist_tab[k]) ) -
	 * 0.5*D_a[i][j] * Math.sqrt(4*dist_tab[k]*dist_tab[k] -
	 * D_a[i][j]*D_a[i][j]); A_a[j][i][k] = A_a[i][j][k]; } //} } } }
	 * 
	 * 
	 * 
	 * double []var_K_theo = new double[N] ;
	 * 
	 * double perim = new ROI2DPolygon().getAsBooleanMask() int area = roi.g;
	 * double I1, I2;
	 * 
	 * for (int k=0; k<N; k++){ // double dist = d_min+(j-1)*dx; //// dx???
	 * double e = Math.PI*dist_tab[k]*dist_tab[k]; I1 = 0.; I2=0;
	 * 
	 * double temp_A = 0;
	 * 
	 * for (int p=0;p<n_a;p++){ for (int n=p; p<n_a; n++){ temp_A =
	 * temp_A+A_a[p][n][k]*2; } }
	 * 
	 * double I3 = (temp_A-e*e/area * (n_a*(n_a-1)))*n_b/area;
	 * 
	 * 
	 * for (int p=0; p<n_a; p++){ // distance du point au bord double dist_a =
	 * distance2Polygon(pta, roi); if (dist_a<dist_tab[k]) h_a[p][k] = results[
	 * ]; else h_a[p][k] = 1; }
	 * 
	 * double sum_h_a = 0.; for ( int isum = 0; isum<n_a; isum++) sum_h_a +=
	 * h_a[isum][k]; double I4 = (e*sum_h_a - n_a*e*e/area)*n_b/area;
	 * var_K_theo[k] = (area/n_a*n_b)*(area/n_a*n_b)*(I1+I2+I3+I4)/
	 * (Math.PI*dist_tab[k]); }
	 * 
	 * // calcul des statistiques de test Y correspondantes for (int k=0;k<N;
	 * k++){ Y[k] = (K[k]-1)/(Math.sqrt(var_K_theo[k])); }
	 * 
	 * 
	 * }
	 */

	private double distance2Polygon(Point mass_center, ArrayList<Point> polyg) {
		double dist = Integer.MAX_VALUE;// roiPolyg.getPerimeter();

		int nbc = polyg.size();

		for (int i = 0; i < nbc; i++) {
			Point pt1 = polyg.get(i);
			double disttmp = mass_center.distance(pt1);
			dist = Math.min(dist, disttmp);
		}

		return (dist);

	}

	private double distancePt2Segment(Point2D pt, Point2D pt1, Point2D pt2) {
		double dist = 0.;
		double dAC = (pt1.getX() - pt.getX()) * (pt1.getX() - pt.getX()) + (pt1.getY() - pt.getY()) * (pt1.getY() - pt.getY());

		double[] v1 = new double[2];
		double[] v2 = new double[2];

		v1[0] = pt2.getX() - pt1.getX();
		v1[1] = pt2.getY() - pt1.getY();
		v2[0] = pt.getX() - pt1.getX();
		v2[1] = pt.getY() - pt1.getY();
		double r_numerator = dotProduct(v1, v2);
		double r_denomenator = (pt2.getX() - pt1.getX()) * (pt2.getX() - pt1.getX()) + (pt2.getY() - pt1.getY()) * (pt2.getY() - pt1.getY());

		double dAB = pt1.distance(pt2);
		r_denomenator = r_denomenator * r_denomenator;

		double r = r_numerator / r_denomenator;

		// System.out.println(" AC2:"+dAC+ " AB2:"+r_denomenator+ " AH:"+r);
		dAC = pt1.distance(pt);
		dAC = dAC * dAC;

		// System.out.println(" AC2:"+dAC);

		// double s =
		// ((pt1.getY()-pt.getY())*(pt2.getX()-pt1.getX())-(pt1.getX()-pt.getX())*(pt2.getY()-pt.getY())
		// ) / r_denomenator;
		// dist = Math.abs(s)*Math.sqrt(r_denomenator);

		dist = Math.sqrt(dAC - r);
		// System.out.println(" dist1:"+dist);

		dist = ((pt2.getX() - pt1.getX() * (pt1.getY() - pt.getY())) - (pt1.getX() - pt.getX()) * (pt2.getY() - pt1.getY()));
		dist = dist / dAB;

		// System.out.println(" dist2:"+dist);

		double x1 = pt1.getX();
		double y1 = pt1.getY();
		double x2 = pt2.getX();
		double y2 = pt2.getY();

		double px = pt.getX();
		double py = pt.getY();

		Line2D seg = new Line2D.Double();
		dist = Line2D.ptSegDist(x1, y1, x2, y2, px, py); // Ok

		return (dist);

	}

	private double dotProduct(double v1[], double v2[]) {

		double dotprod = 0;
		for (int i = 0; i < v1.length; i++)
			dotprod += v1[i] * v2[i];
		return dotprod;
	}

	public double getPerimeter(ROI2D roi) {
		// approximation by using number of point of the edge of boolean mask
		BooleanMask2D mas = roi.getAsBooleanMask(true);
		return getEdgePoints(mas).size();
	}

	public ArrayList<Point> getEdgePoints(BooleanMask2D ma) {
		if (ma.isEmpty())
			return new ArrayList<Point>(0);

		final ArrayList<Point> points = new ArrayList<Point>(1024);
		final int h = ma.bounds.height;
		final int w = ma.bounds.width;
		final int maxx = ma.bounds.x + (w - 1);
		final int maxy = ma.bounds.y + (h - 1);

		// cache
		boolean top = false;
		boolean bottom = false;
		boolean left = false;
		boolean right = false;
		boolean current;

		int offset = 0;

		// special case
		if ((w == 1) && (h == 1)) {
			if (ma.mask[0])
				points.add(new Point(ma.bounds.x, ma.bounds.y));
		} else if (w == 1) {
			// first pixel of row
			top = false;
			current = ma.mask[offset];
			bottom = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && bottom))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// row
			for (int y = ma.bounds.y + 1; y < maxy; y++) {
				// cache
				top = current;
				current = bottom;
				bottom = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && bottom))
					points.add(new Point(ma.bounds.x, y));
			}

			// cache
			top = current;
			current = bottom;
			bottom = false;

			// current pixel is a border ?
			if (current && !(top && bottom))
				points.add(new Point(ma.bounds.x, maxy));
		}
		// special case
		else if (h == 1) {
			// first pixel of line
			left = false;
			current = ma.mask[offset];
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(left && right))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(left && right))
					points.add(new Point(x, ma.bounds.y));
			}

			// last pixel of first line
			left = current;
			current = right;
			right = false;

			// current pixel is a border ?
			if (current && !(left && right))
				points.add(new Point(maxx, ma.bounds.y));
		} else {
			// first pixel of first line
			top = false;
			left = false;
			current = ma.mask[offset];
			bottom = ma.mask[offset + w];
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(ma.bounds.x, ma.bounds.y));

			// first line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				bottom = ma.mask[offset + w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(x, ma.bounds.y));
			}

			// last pixel of first line
			left = current;
			current = right;
			bottom = ma.mask[offset + w];
			right = false;
			offset++;

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(maxx, ma.bounds.y));

			for (int y = ma.bounds.y + 1; y < maxy; y++) {
				// first pixel of line
				left = false;
				current = ma.mask[offset];
				top = ma.mask[offset - w];
				bottom = ma.mask[offset + w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(ma.bounds.x, y));

				for (int x = ma.bounds.x + 1; x < maxx; x++) {
					// cache
					left = current;
					current = right;
					top = ma.mask[offset - w];
					bottom = ma.mask[offset + w];
					right = ma.mask[++offset];

					// current pixel is a border ?
					if (current && !(top && left && right && bottom))
						points.add(new Point(x, y));
				}

				// last pixel of line
				left = current;
				current = right;
				top = ma.mask[offset - w];
				bottom = ma.mask[offset + w];
				right = false;
				offset++;

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(maxx, y));
			}

			// first pixel of last line
			left = false;
			current = ma.mask[offset];
			top = ma.mask[offset - w];
			bottom = false;
			right = ma.mask[++offset];

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(ma.bounds.x, maxy));

			// last line
			for (int x = ma.bounds.x + 1; x < maxx; x++) {
				// cache
				left = current;
				current = right;
				top = ma.mask[offset - w];
				right = ma.mask[++offset];

				// current pixel is a border ?
				if (current && !(top && left && right && bottom))
					points.add(new Point(x, maxy));
			}

			// last pixel of last line
			left = current;
			current = right;
			top = ma.mask[offset - w];
			right = false;

			// current pixel is a border ?
			if (current && !(top && left && right && bottom))
				points.add(new Point(maxx, maxy));
		}

		return points;
	}

	// AIRE
	private double Roiarea(ROI2D roi) {
		BooleanMask2D roiMask = roi.getAsBooleanMask(true);
		int minx = Math.max(0, roiMask.bounds.x);
		int maxx = roiMask.bounds.x + roiMask.bounds.width;
		int miny = Math.max(0, roiMask.bounds.y);
		int maxy = roiMask.bounds.y + roiMask.bounds.height;
		double intensitySpot = 0.;
		int areaR = 0;// size Cell
		for (int ix = minx; ix < maxx; ix++)
			for (int y = miny; y < maxy; y++) {
				if (roiMask.contains(ix, y)) {
					areaR++;
				}

			}
		return areaR;
	}

	
	private Sequence doMaskSpots(Sequence seq, ArrayList<plugins.nchenouard.spot.Point3D> det) {

		int w = seq.getWidth();
		int h = seq.getHeight();

		IcyBufferedImage img = seq.getFirstImage();

		double[] tab = Array1DUtil.arrayToDoubleArray(img.getDataXY(0), img.isSignedDataType());

		Sequence seqOut = new Sequence();
		IcyBufferedImage imageOut = new IcyBufferedImage(seq.getSizeX(), seq.getSizeY(), seq.getSizeC(), seq.getDataType_());

		double[] tabOut = Array1DUtil.arrayToDoubleArray(imageOut.getDataXY(0), imageOut.isSignedDataType());

		for (plugins.nchenouard.spot.Point3D pt : det) {
			int x = (int) pt.x;
			int y = (int) pt.y;

			tabOut[x + y * w] = tab[x + y * w];

		}

		imageOut.setDataXY(0, Array1DUtil.doubleArrayToArray(tabOut, imageOut.getDataXY(0)));

		seqOut.addImage(imageOut);
		seqOut.dataChanged();
		return (seqOut);

	}
	private 	HashMap<ROI2D, Vector<Spot>> detectionsInRoi(Sequence sequence, Vector<Spot> detection, ArrayList<ROI2D> roiArrayList ){
		// SEQUENCE A remplacer par w,h	
			
			// create a hashMap with the detections binded to ROI
		
			HashMap<ROI2D, Vector<Spot>> ROI2Detection = new HashMap<ROI2D, Vector<Spot>>();
		
			// create a fake ROI taking all the sequence if no existing ROI on
			// sequence.
			if (roiArrayList.size() == 0) {
				ROI2Detection.put(new ROI2DRectangle(new Point2D.Double(0, 0), new Point2D.Double(sequence.getWidth(),
						sequence.getHeight()), false), (Vector<Spot>) detection.clone());
			} else { // there is ROI is the sequence
		
				// setup hashMap
				for (ROI2D roi : roiArrayList) {
					ROI2Detection.put(roi, new Vector<Spot>());
				}
		
				// fill hashMap
				for (ROI2D roi : roiArrayList) {
					for (Spot spot : detection) {
						if (roi.contains(spot.mass_center.x, spot.mass_center.y)) {
							ROI2Detection.get(roi).add(spot);
						}
					}
				}
			}
		
			// rebuild the detectionResult with what has been found in ROIs
		
			detection.clear();
			// Set<Entry<ROI2D, ArrayList<DetectionSpot>>> roiList =
			// ROI2Detection.keySet();
			for (ROI2D roi : ROI2Detection.keySet()) {
				for (Spot s : ROI2Detection.get(roi)) {
					detection.add(s);
				}
			}
		
			if (detection.size() == 0) {
				new AnnounceFrame("There is no detection associated with the ROI(s)");
			
			}
			
			return(ROI2Detection);
		}
	/**
	    * Returns the mass center of specified 2D ROI.
	    */
	   public Point2D getMassCenter(ROI2D roi)
	   {
	       double x = 0, y = 0;
	       long len = 0;

	       final BooleanMask2D mask = roi.getBooleanMask(true);
	       final boolean m[] = mask.mask;
	       final int h = mask.bounds.height;
	       final int w = mask.bounds.width;

	       int off = 0;
	       for (int j = 0; j < h; j++)
	       {
	           for (int i = 0; i < w; i++)
	           {
	               if (m[off++])
	               {
	                   x += i;
	                   y += j;
	                   len++;
	               }
	           }
	       }

	       final Point2D pos2d = roi.getPosition2D();
	       return new Point2D.Double(pos2d.getX() + (x / len), pos2d.getY() + (y / len));
	   }


}
