package plugins.fab.trackgenerator;

import java.util.ArrayList;

import flanagan.math.PsRandom;

public class ImageCreatorPSFlikeObjects {

	PSF psf; 
	ArrayList<Particle> allParticles;
	private ArrayList<VolumeImage> volumeImageList;
	private ArrayList<double[]> PSFProfile;

	private double[][][][] floatImage;
	int width;
	int height;
	int depth;
	int psfWidth;
	int psfDepth;
	int sequenceLength;
	double pixelSize;
	double sliceSpacing; 
	double psfMax;
	int psfWidthUpSampling;
	int psfDepthUpSampling;
	
	double shiftXY; 
	double shiftZ;
		
	int numberOfUpscaledIntervals; 
	
	PsRandom ran;
	double bg = 10; // background level
	double alphaSNR; // coefficient for making the desired snr 
	
	ImageCreatorPSFlikeObjects(ArrayList<Particle> allParticles, int width, int height, int depth, int sequenceLength, PsRandom ran, PSF psf, int psfWidth, int psfDepth, double pixelSize, double sliceSpacing, int psfWidthUpSampling, int psfDepthUpSampling, double SNR)
	{
		this.psf = psf;
		this.width = width;
		this.height = height;
		this.depth = depth;
		this.sequenceLength = sequenceLength;
		this.ran = ran;
		this.psfWidth = psfWidth;
		this.pixelSize = pixelSize;
		this.psfDepth = psfDepth;
		this.sliceSpacing = sliceSpacing;
		this.psfWidthUpSampling = psfWidthUpSampling;
		this.psfDepthUpSampling = psfDepthUpSampling;
		this.allParticles = allParticles;

		// size of the intervals, in which a pixel is split "psfWidthUpSampling" times
		shiftXY = 1.0 / psfWidthUpSampling;
		shiftZ = 1.0 / psfDepthUpSampling;
		
		// number of full length intervals of length "psfWidthUpSampling" that fit "psfWidth" 
		numberOfUpscaledIntervals = (psfWidth - psfWidthUpSampling) / psfWidthUpSampling + 1;
		// make it odd number
		numberOfUpscaledIntervals = (numberOfUpscaledIntervals % 2 == 0) ? numberOfUpscaledIntervals - 1 : numberOfUpscaledIntervals;
		
		PSFProfile = psf.getPSFProfile();
		
		//get the max value for PSF (for normalization and SNR computation)
		psfMax = 0; //PSFProfile.get(psfDepth / 2)[psfWidth / 2 * (1 + psfWidth)];
		for (int si = 0; si < psfWidthUpSampling; si++) {
			for (int sj = 0; sj < psfWidthUpSampling; sj++) {
				psfMax += PSFProfile.get(psfDepth / 2)[psfWidth / 2 - psfWidthUpSampling / 2 + si + (psfWidth / 2 - psfWidthUpSampling / 2 + sj) * psfWidth];
			}
		}
		
		alphaSNR = (Math.pow(SNR, 2) + SNR * Math.sqrt(Math.pow(SNR, 2) + 4 * bg)) / 2.0;
		System.out.println("SNR "+alphaSNR);
		
		// double valued image for placing the PSF and adding the noise
		floatImage = new double[sequenceLength][depth][height][width];  

		// final 8bit image for the output
		volumeImageList = new ArrayList<VolumeImage>();
		
		//RANDOMIZE BACKGROUND LEVEL FOR THE TEST DATA, SO PEOPLE CANNOT FIX THAT VALUE FROM THE VERY BEGINNING
		bg += 10 * ran.nextDouble();
	}
	
	public ArrayList<VolumeImage> getImage()
	{
		for(Particle p : allParticles)
		{
			for (int j = 0; j < p.detectionArrayList.size(); j++) 
			{
				TGDetection detection =  p.detectionArrayList.get(j);
				
				int x = (int)Math.round(detection.x);
				int y = (int)Math.round(detection.y);
				int z = (int)Math.round(detection.z);
				
				double dx = detection.x - x;
				double dy = detection.y - y;
				double dz = detection.z - z;
				
				int dxi = (int)((dx + 0.5) / shiftXY) - psfWidthUpSampling / 2; 
				int dyi = (int)((dy + 0.5) / shiftXY) - psfWidthUpSampling / 2; 
				int dzi = (int)((dz + 0.5) / shiftZ) - psfDepthUpSampling / 2; 

				for (int zz = 0; zz < depth; zz++) {
					int index = psfDepth / 2 + (z - zz) * psfDepthUpSampling + dzi;
					if (index < 0 || index >= psfDepth) {
						continue;
					}
					double[] psfProfile = PSFProfile.get(index);
					
					// use this if all particles are required to be in focus ( for debug purposes, to check if the in-place subresolution localization is correct)
					//double[] psfProfile = PSFProfile.get(psfDepth / 2);

					if (x >= 0 && x < width && y >= 0 && y < height) 
					{
						// the boundaries are cut like 
						//-numberOfUpscaledIntervals / 2 + 1 and numberOfUpscaledIntervals / 2 - 1
						// in order to avoid boundary problems, when we are trying to access pixels in PSF
						// |...|...|...|...|...|.x.| here for pixel x averaging with 2 neighbors can be done
						// |...|...|...|...|...|..x| here for pixel x averaging with 2 neighbors is not possible, 
						// because there is no (next to the left) interval for that

						for (int jj = -numberOfUpscaledIntervals / 2 + 1; jj < numberOfUpscaledIntervals / 2; jj++) {
							for (int ii = -numberOfUpscaledIntervals / 2 + 1; ii < numberOfUpscaledIntervals / 2; ii++) {
								int xi = x + ii; 
								int yi = y + jj; 
								if (xi >= 0 && xi < width && yi >= 0 && yi < height) { 
									int xii = ii * psfWidthUpSampling + psfWidth / 2 - dxi;
									int yii = jj * psfWidthUpSampling + psfWidth / 2 - dyi;

									double val = 0;
									for (int si = 0; si < psfWidthUpSampling; si++) {
										for (int sj = 0; sj < psfWidthUpSampling; sj++) {
											val += psfProfile[xii - psfWidthUpSampling / 2 + si + (yii - psfWidthUpSampling / 2 + sj) * psfWidth];
										}
									}
									floatImage[detection.t][zz][yi][xi] += val / psfMax * alphaSNR;
								}
							}
						}

					}
				}

				
			}			
		}
		
		// add background and apply noise
		for (int tt = 0; tt < sequenceLength; tt++) {
			VolumeImage volumeImage = new VolumeImage();
			volumeImage.imageData = new byte [depth][width * height];
			for (int zz = 0; zz < depth; zz++) {
				for (int jj = 0; jj < height; jj++) {
					for (int ii = 0; ii < width; ii++) {
						floatImage[tt][zz][jj][ii] += bg; 
						
						//add noise
						// line below uncommented by fab
						floatImage[tt][zz][jj][ii] = PoissonNoiseGenerator.nextPoissonian(floatImage[tt][zz][jj][ii]);
						
						// convert the original float image to byte, taking into account pixel SATURATION
						volumeImage.imageData[zz][ii + jj * width] = (floatImage[tt][zz][jj][ii] > 255) ? 
								(byte)255 : (byte)floatImage[tt][zz][jj][ii];
					}
				}
			}
			volumeImageList.add(volumeImage);
		}
		return volumeImageList;
	}
}
