package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

/**
 * Particle creation with
 * uniform distribution in space
 * and a Brownian motion with fixed diffusion coefficient
 * */

public class BrownianUniformParticleCreator implements ParticleCreator
{
	double sigma;
	PsRandom ran;
	Shape shapeModel;
	double minX, maxX, minY, maxY, minZ, maxZ;
	boolean isMotionPureIn2D;
	
	public BrownianUniformParticleCreator(double sigma, Shape shapeModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, PsRandom ran, boolean isMotionPureIn2D) {
		this.sigma = sigma;
		this.shapeModel = shapeModel;
		this.ran = ran;
		this.minX = minX;
		this.maxX = maxX;
		this.minY = minY;
		this.maxY = maxY;
		this.minZ = minZ;
		this.maxZ = maxZ;
		this.isMotionPureIn2D = isMotionPureIn2D;
	}

	@Override
	public Particle createNewParticle(int t) {
		// position sampling
		TGDetection firstDetection = new TGDetection(
				minX + ran.nextDouble()*(maxX-minX),
				minY + ran.nextDouble()*(maxY-minY),
				minZ + ran.nextDouble()*(maxZ-minZ),
				t);
		// create new motion model and shape
		Particle particle = new Particle(
				shapeModel.clone(),
				new BrownianMotionModel(firstDetection, sigma, ran, isMotionPureIn2D));
		return particle;
	}

}
