package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

/**
 * Particle creation with
 * uniform and localized (mixture) distribution in space
 * and a Directed Motion model (simulating microtubule dynamics)
 * */

public class DirectedMotionMixedParticleCreator implements ParticleCreator
{
	double q1;
	double minX, maxX, minY, maxY, minZ, maxZ;
	PsRandom ran;
	Shape shapeModel;
	double Vmin, Vmax;
	double p = 1; // proportion of uniform and localized initial states
	boolean isMotionPureIn2D;

	public DirectedMotionMixedParticleCreator(double q1, double Vmin, double Vmax, Shape shapeModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, PsRandom ran, boolean isMotionPureIn2D) {
		this.q1 = q1;
		this.shapeModel = shapeModel;
		this.ran = ran;
		this.Vmin = Vmin;
		this.Vmax = Vmax;
		this.minX = minX;
		this.maxX = maxX;
		this.minY = minY;
		this.maxY = maxY;
		this.minZ = minZ;
		this.maxZ = maxZ;
		this.isMotionPureIn2D = isMotionPureIn2D;
	}

	@Override
	public Particle createNewParticle(int t) {
		TGDetection firstDetection = null;
		double Vx, Vy, Vz = 0;
		if (ran.nextDouble() < p) {
			// uniform position sampling
			firstDetection = new TGDetection(
					minX + ran.nextDouble()*(maxX-minX),
					minY + ran.nextDouble()*(maxY-minY),
					minZ + ran.nextDouble()*(maxZ-minZ),
					t);
			double alpha = ran.nextDouble() * 2 * Math.PI;
			double Vamp = Vmin + (Vmax - Vmin) * ran.nextDouble();
			Vx = Vamp * Math.cos(alpha);
			Vy = Vamp * Math.sin(alpha);
		} else {
			// localized position sampling 
//			double alpha = Math.PI / 12 +  ran.nextDouble() * Math.PI / 3;
//			double r = 20 + ran.nextDouble() * 10;
//			double x0 = (minX + r) * Math.cos(alpha);
//			double y0 = (minY + r) * Math.sin(alpha);
//			double z0 = minZ + ran.nextDouble()*(maxZ-minZ);

			//double alpha = Math.PI / 2 +  ran.nextDouble() * 0.2;
			//double r = 20 + ran.nextDouble() * 10;
			double x0 = (maxX + minX) / 2 - 150 + 300 * ran.nextDouble();
			double y0 = 0;
			double z0 = minZ + ran.nextDouble()*(maxZ-minZ);
			double alpha = Math.atan2(y0 + 500, x0 - (maxX + minX) / 2);

			firstDetection = new TGDetection(x0, y0, z0, t);

			double Vamp = Vmin + (Vmax - Vmin) * ran.nextDouble();
			Vx = Vamp * Math.cos(alpha);
			Vy = Vamp * Math.sin(alpha);
		}
		// create new motion model and shape
		Particle particle = new Particle(
				shapeModel.clone(),
				new DirectedMotionModel(firstDetection, q1, Vmin, Vmax, Vx, Vy, 0, ran, isMotionPureIn2D));
		return particle;
	}

}
