package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

public class DirectedMotionModel extends MotionModel {

	double q1;
	PsRandom ran;
	double currentVx, currentVy, currentVz; 
	double Vmin, Vmax;
	boolean isMotionPureIn2D;
	
	public DirectedMotionModel( TGDetection firstDetection, double q1, double Vmin, double Vmax, double currentVx, double currentVy, double currentVz, PsRandom ran, boolean isMotionPureIn2D)
	{
		super( firstDetection );
		this.ran = ran;
		this.q1 = q1;
		this.currentVx = currentVx;
		this.currentVy = currentVy;
		this.currentVz = currentVz;
		this.Vmax = Vmax;
		this.Vmin = Vmin;
		this.isMotionPureIn2D = isMotionPureIn2D;
	}
	
	@Override
	public TGDetection getNextDetection( )
	{
		double noisePosition = ran.nextGaussian(0, 1); 
				
		double newDetectionX = currentDetection.x + currentVx + Math.sqrt(q1 / 3) * noisePosition;  
		double newCurrentVx = currentVx + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  

		noisePosition = ran.nextGaussian(0, 1); 
		double newDetectionY = currentDetection.y + currentVy + Math.sqrt(q1 / 3) * noisePosition;  
		double newCurrentVy = currentVy + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  

		noisePosition = ran.nextGaussian(0, 1); 
		double newDetectionZ = currentDetection.z + currentVz + Math.sqrt(q1 / 3) * noisePosition;  
		double newCurrentVz = currentVz + Math.sqrt(q1 / 4) * ran.nextGaussian(0, 1) + Math.sqrt(q1 / 3) * noisePosition * 1.5;  
		
		if (isMotionPureIn2D) {
			newCurrentVz = 0;
		}
		
		double Vel = Math.sqrt(newCurrentVx * newCurrentVx + newCurrentVy * newCurrentVy + newCurrentVz * newCurrentVz);
		
		if (Vel >= Vmin && Vel <= Vmax) 
		{
			currentVx = newCurrentVx;
			currentVy = newCurrentVy;
			currentVz = newCurrentVz;
		} 
		
		TGDetection newDetection = new TGDetection(newDetectionX, newDetectionY, newDetectionZ, currentDetection.t+1);
		currentDetection = newDetection;
		return newDetection;
	}
}