package plugins.fab.trackgenerator;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;

import java.util.ArrayList;

import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class DisplayTools {

	/**
	 * Displays a ubyte buffer as an image in Icy.
	 * */
	static void displayImage( byte data[] , int width , int height )
	{		
		IcyBufferedImage image = new IcyBufferedImage( width , height , 1 , DataType.UBYTE );
		image.setDataXY( 0 , data );		
		
		Sequence sequence = new Sequence();		
		sequence.addImage( image );
			
		Icy.addSequence( sequence );		
	}

	/**
	 * Displays a list of ubyte-buffer as an image in Icy.
	 * */
	static Sequence displayImage( ArrayList<byte[]> dataList, int width , int height )
	{		
		Sequence sequence = new Sequence();		

		for ( int i = 0 ; i < dataList.size() ; i++ )
		{
			byte[] imageData = dataList.get( i );
			IcyBufferedImage image = new IcyBufferedImage( width , height , 1 , DataType.UBYTE );
			image.setDataXY( 0 , imageData );					
			sequence.setImage( i, 0 , image );
		}
					
		Icy.addSequence( sequence );		
		return sequence;
	}	
	
	/**
	 * Displays a list of ubyte-buffer as an image in Icy.
	 * */
	static Sequence display3DImage( ArrayList<byte[][]> imageList , int width , int height )
	{		
		Sequence sequence = new Sequence();		

		for ( int t = 0 ; t < imageList.size() ; t++ )
		{
			byte[][] imageData = imageList.get( t );
			for ( int z = 0 ; z < imageData.length ; z++ )
			{
				IcyBufferedImage image = new IcyBufferedImage( width , height , 1 , DataType.UBYTE );
				image.setDataXY( 0 , imageData[z] );					
				sequence.setImage( t, z , image );
			}
		}
					
		Icy.addSequence( sequence );
		return sequence;
	}

	public static void displayImage(ArrayList<byte[]> imageList, int width , int height,
			ArrayList<Particle> particleArrayList) {
		
		Sequence sequence = displayImage( imageList , width , height );		
		addTracks( sequence , particleArrayList );		
		
	}

	static void display3DImage( ArrayList<byte[][]> imageList , int width , int height , ArrayList<Particle> particleArrayList )
	{
		Sequence sequence = display3DImage( imageList , width, height );		
		addTracks( sequence , particleArrayList );	
	}
	
	
	static void addTracks(final Sequence sequence, final ArrayList<Particle> particleArrayList)
	{
		
		System.out.println("The particleArrayList Size: " + particleArrayList.size() );
		
		
		
		ThreadUtil.invokeNow( new Runnable() {
			
			@Override
			public void run() {

				TrackManager trackManager = new TrackManager();
				
				TrackGroup trackGroup = new TrackGroup( sequence );
				for ( Particle particle : particleArrayList )
				{
					TrackSegment ts = new TrackSegment();
					
					for ( TGDetection tgDetection : particle.detectionArrayList )
					{
						Detection detection = new Detection( tgDetection.x , tgDetection.y, tgDetection.z , tgDetection.t );
						
						ts.addDetection( detection );
						
					}
					trackGroup.addTrackSegment( ts );
				}
				
				SwimmingObject so = new SwimmingObject( trackGroup );		
				
				Icy.getMainInterface().getSwimmingPool().add( so );
				
				trackManager.setDisplaySequence( sequence );				

			}
		});
		
		
	}	
	
}