package plugins.fab.trackgenerator;

import flanagan.math.PsRandom;

/**
 * Particle creation with
 * uniform distribution in space
 * and a Brownian motion with fixed diffusion coefficient
 * */

public class SwitchingUniformParticleCreator implements ParticleCreator
{
	double sigmaBrownian;
	double q1;
	double Vmin;
	double Vmax;
	double probaDirectedBrownian;
	double probaBrownianDirected;
	double minX, maxX, minY, maxY, minZ, maxZ;
	PsRandom ran;
	Shape shapeModel;
	boolean isMotionPureIn2D;
	
	public SwitchingUniformParticleCreator(double q1, double Vmin, double Vmax, double sigmaBrownian, double probaDirectedBrownian, double probaBrownianDirected, Shape shapeModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ, PsRandom ran, boolean isMotionPureIn2D)
	{
		this.sigmaBrownian = sigmaBrownian;
		this.q1 = q1;
		this.Vmax = Vmax;
		this.Vmin = Vmin;
		this.probaBrownianDirected = probaBrownianDirected;
		this.probaDirectedBrownian = probaDirectedBrownian;
		this.shapeModel = shapeModel;
		this.ran = ran;
		this.minX = minX;
		this.maxX = maxX;
		this.minY = minY;
		this.maxY = maxY;
		this.minZ = minZ;
		this.maxZ = maxZ;
		this.isMotionPureIn2D = isMotionPureIn2D;
	}

	@Override
	public Particle createNewParticle(int t) {
		// position sampling
		TGDetection firstDetection = new TGDetection(
				minX + ran.nextDouble()*(maxX-minX),
				minY + ran.nextDouble()*(maxY-minY),
				minZ + ran.nextDouble()*(maxZ-minZ),
				t);
		// create new motion model and shape
		double alpha = ran.nextDouble() * 2 * Math.PI;
		double Vamp = Vmin + (Vmax - Vmin) * ran.nextDouble();
		double currentVx = Vamp * Math.cos(alpha);
		double currentVy = Vamp * Math.sin(alpha);
		double currentVz = 0;
		Particle particle = new Particle(
				shapeModel.clone(),
				new SwitchingBrownianDirectedModel(firstDetection, q1, Vmin, Vmax, currentVx, currentVy, currentVz, sigmaBrownian, probaDirectedBrownian, probaBrownianDirected, ran, isMotionPureIn2D));
		return particle;
	}

}
