package plugins.fab.trackgenerator;

import icy.file.FileUtil;
import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;

import java.io.File;
import java.util.ArrayList;

import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import flanagan.math.PsRandom;

public class TrackGeneratorGUI  extends EzPlug // implements EzStoppable
{

	EzVarInteger sequenceLength = new EzVarInteger( "Sequence length", 100, 1, 10000, 1 );

	EzVarInteger width = new EzVarInteger("Image width" , 512 , 2 , 512*20 , 1 );
	EzVarInteger height = new EzVarInteger("Image height", 512 , 2 , 512*20 , 1 );
	EzVarInteger depth = new EzVarInteger("Image depth", 1 , 1 , 100 , 1 );
	
	EzVarInteger randomSeed = new EzVarInteger("Seed", 123456 , 0 , 1000000 , 1 );

	EzVarDouble deseapearingRate = new EzVarDouble("Extintion Rate", 0.05 , 0 , 1 , 0.01 );
		
	EzVarEnum<CreatorTypes> creatorEnum = new EzVarEnum<CreatorTypes>("Creator Types", CreatorTypes.values(), CreatorTypes.BROWNIAN_UNIFORM );
	EzVarDouble sigma_BROWNIAN_UNIFORM = new EzVarDouble("Sigma", 0, 100, 0.01 ); 
	
	// global parameters
	
	// limits of the simulated volume
	EzVarInteger xbordersSimu = new EzVarInteger("x borders simu", 100 , 0 , 10000 , 1 );
	EzVarInteger ybordersSimu = new EzVarInteger("y borders simu", 100 , 0 , 10000 , 1 );
	EzVarInteger zbordersSimu = new EzVarInteger("z borders simu", 20 , 0 , 10000 , 1 );
	EzVarInteger warmUpPeriod  = new EzVarInteger("warmup length", 50 , 0 , 10000 , 1 );  // number of frames of simulation before keeping tracks
	
	EzVarDouble xyPixelSize = new EzVarDouble("xy pixel size", 50 , 0 , 10000 , 0.01 );
	EzVarDouble sliceSpacing = new EzVarDouble("slice spacing", 300 , 0 , 10000 , 0.01 );
	
	// Switching uniform
	

	
	EzVarDouble Vmin = new EzVarDouble("V min", 1, 0, 100, 0.01 ); // 1
	EzVarDouble Vmax = new EzVarDouble("V max", 5, 0, 100, 0.01 ); // 5
	EzVarDouble sigmaBrownian_SWITCHING_UNIFORM = new EzVarDouble("Sigma Brownian", 2 , 0, 100, 0.01 ); // 2
	EzVarDouble probaDirectedBrownian = new EzVarDouble("Proba Directed Brownian", 0.3 , 0, 1, 0.01 ); // 0.3
	EzVarDouble probaBrownianDirected = new EzVarDouble("Proba Brownian Directed", 0.3 , 0, 1, 0.01 ); // 0.3
	EzVarDouble q1 = new EzVarDouble("q1", 1 , 0 , 100, 0.01 );
	EzVarDouble snr = new EzVarDouble("snr", 10 , 0 , 100, 0.01 );
	EzVarDouble density = new EzVarDouble("density", 100 , 0 , 100000, 0.01 );

	EzVarInteger minTrackLength = new EzVarInteger("minTrackLength", 2 , 0 , 10000 , 1 );
	
	EzVarBoolean useSNR = new EzVarBoolean("use SNR", true );
	
	EzVarBoolean displayTrackInTrackManager = new EzVarBoolean("Display tracks", true );
	
	EzVarBoolean saveXML = new EzVarBoolean("Save XML", true );
	EzVarFile xmlFile = new EzVarFile("XML File" , "" );
	
	@Override
	protected void initialize() {

		EzGroup generalParameters = new EzGroup("General parameters",
				snr,
				density,
				randomSeed,
				width,
				height,
				depth,
				sequenceLength,
				displayTrackInTrackManager,
				saveXML,
				xmlFile
				);

		xmlFile.setValue( new File( System.getProperty("user.home") + FileUtil.separator + "exportXML.xml") );
		
		super.addEzComponent( generalParameters );
		
		EzGroup trackParameters = new EzGroup("Track parameters",
				minTrackLength,
				warmUpPeriod,
				deseapearingRate
				);
		
		super.addEzComponent( trackParameters );	
		
		EzGroup advancedSimulationParameters = new EzGroup("Advanced parameters",
				xbordersSimu,
				ybordersSimu,
				zbordersSimu,
				xyPixelSize,
				sliceSpacing
				);
		
		super.addEzComponent( advancedSimulationParameters );		
		
		EzGroup groupMotion = new EzGroup("Particle motion",
				creatorEnum,				
				
				sigma_BROWNIAN_UNIFORM,
				sigmaBrownian_SWITCHING_UNIFORM,
				q1,
				Vmin,
				Vmax,
				probaDirectedBrownian,
				probaBrownianDirected
				);		
		
//		EzGroup renderingOption = new EzGroup("Rendering settings (for dev)",
//				useSNR
//				);
		
//		super.addEzComponent( renderingOption );
		
		super.addEzComponent( groupMotion );

		creatorEnum.addVisibilityTriggerTo( sigma_BROWNIAN_UNIFORM, CreatorTypes.BROWNIAN_UNIFORM );
		
		creatorEnum.addVisibilityTriggerTo( q1, CreatorTypes.SWITCHING_UNIFORM , CreatorTypes.DIRECTED_MIXED );
		creatorEnum.addVisibilityTriggerTo( Vmin, CreatorTypes.SWITCHING_UNIFORM ,  CreatorTypes.DIRECTED_MIXED  );
		creatorEnum.addVisibilityTriggerTo( Vmax, CreatorTypes.SWITCHING_UNIFORM ,  CreatorTypes.DIRECTED_MIXED  );		
		creatorEnum.addVisibilityTriggerTo( sigmaBrownian_SWITCHING_UNIFORM, CreatorTypes.SWITCHING_UNIFORM );
		creatorEnum.addVisibilityTriggerTo( probaBrownianDirected, CreatorTypes.SWITCHING_UNIFORM );
		creatorEnum.addVisibilityTriggerTo( probaDirectedBrownian, CreatorTypes.SWITCHING_UNIFORM );
		
		saveXML.addVisibilityTriggerTo( xmlFile, true );
		
		
	}

	@Override
	protected void execute() {		

		BenchmarkSequence benchmarkSequence = TrackGenerationUtil.generateSequenceBenchMark(
				xbordersSimu.getValue(),
				ybordersSimu.getValue(),
				zbordersSimu.getValue(),
				width.getValue(),
				height.getValue(),
				depth.getValue(),
				randomSeed.getValue(), 
				sliceSpacing.getValue(), 
				xyPixelSize.getValue(),
				creatorEnum.getValue(),
				sigma_BROWNIAN_UNIFORM.getValue(),
				q1.getValue(),
				Vmin.getValue(),
				Vmax.getValue(),
				sigmaBrownian_SWITCHING_UNIFORM.getValue(),
				probaDirectedBrownian.getValue(),
				probaBrownianDirected.getValue(), 
				deseapearingRate.getValue(), 
				sequenceLength.getValue(), 
				warmUpPeriod.getValue(), 
				minTrackLength.getValue(), 
				snr.getValue(),
				super.getUI(),
				density.getValue(),
				"low med high "+density.getValue(), // This is not consistant to this generation, so I put this inconsistent message :)
				Scenario.NO_SCENARIO
				);
		
		
		benchmarkSequence.displaySequence( displayTrackInTrackManager.getValue() );		
		benchmarkSequence.saveXML( xmlFile.getValue() );
		
	}

	@Override
	public void clean() {

	}
	

	
}
