/*
 * Decompiled with CFR 0.152.
 */
package bilib.commons.smarttable;

import bilib.commons.smarttable.SmartFormat;
import bilib.commons.smarttable.SmartTableColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SmartTableRenderer
extends DefaultTableCellRenderer {
    private SmartTableColumn[] columns;
    private Color colorOddRow = new Color(245, 245, 250);
    private Color colorEvenRow = new Color(232, 232, 237);
    private Color colorSelection = new Color(150, 150, 177);
    private Color colorTop = new Color(140, 140, 140);
    private int sizeFont = 0;
    private boolean monospace = false;
    public int top;
    private ArrayList<SmartFormat> nfRows;

    public SmartTableRenderer(SmartTableColumn[] columns, ArrayList<SmartFormat> nfRows) {
        this.columns = columns;
        this.nfRows = nfRows;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        SmartFormat nf = this.columns[col].numformat;
        if (row >= 0 && row < this.nfRows.size() && this.nfRows.get(row) != null) {
            nf = this.nfRows.get(row);
        }
        try {
            Component c = value.getClass() == Double.class ? super.getTableCellRendererComponent(table, nf.format((Double)value), isSelected, hasFocus, row, col) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(this.columns[col].getAlignment());
            }
            c.setFont(new Font(this.monospace ? "Monospace" : c.getFont().getFamily(), 0, c.getFont().getSize() + this.sizeFont));
            if (row < this.top) {
                c.setBackground(this.colorTop);
            } else if (isSelected) {
                c.setBackground(this.colorSelection);
            } else {
                c.setBackground(row % 2 == 0 ? this.colorEvenRow : this.colorOddRow);
            }
            c.setForeground(Color.black);
            return c;
        }
        catch (Exception e) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    public void setMonospaceFont(boolean monospace) {
        this.monospace = monospace;
    }

    public void incrementSizeFont(int sizeFont) {
        this.sizeFont = sizeFont;
    }

    public void setBackgroundColor(Color colorEvenRow, Color colorOddRow, Color colorSelection) {
        this.colorEvenRow = colorEvenRow;
        this.colorOddRow = colorOddRow;
        this.colorSelection = colorSelection;
    }

    public void setBackgroundTopColor(Color colorTop) {
        this.colorTop = colorTop;
    }
}

