/*
 * Decompiled with CFR 0.152.
 */
package psfgenerator;

import bilib.commons.gui.DoubleScrollablePanel;
import bilib.commons.gui.GridPanel;
import bilib.commons.gui.GridToolbar;
import bilib.commons.gui.HTMLPane;
import bilib.commons.gui.SpinnerDouble;
import bilib.commons.gui.SpinnerInteger;
import bilib.commons.job.ExecutionMode;
import bilib.commons.job.MonitorTimedProgressBar;
import bilib.commons.job.runnable.Pool;
import bilib.commons.job.runnable.PoolResponder;
import bilib.commons.settings.Settings;
import bilib.commons.settings.SettingsFileDialog;
import bilib.commons.utils.WebBrowser;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import psf.PSF;
import psfgenerator.About;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
ChangeListener {
    private MonitorTimedProgressBar progress = new MonitorTimedProgressBar();
    private SpinnerInteger spnNX = new SpinnerInteger(256, 1, 9999, 1, 3);
    private SpinnerInteger spnNY = new SpinnerInteger(256, 1, 9999, 1, 3);
    private SpinnerInteger spnNZ = new SpinnerInteger(32, 1, 9999, 1, 3);
    private SpinnerDouble spnResLateral = new SpinnerDouble(100.0, 1.0, 99999.0, 1.0, 3);
    private SpinnerDouble spnResAxial = new SpinnerDouble(250.0, 1.0, 999999.0, 1.0, 3);
    private SpinnerDouble spnNA = new SpinnerDouble(1.4, 0.1, 3.0, 0.1, 3);
    private SpinnerDouble spnLambda = new SpinnerDouble(610.0, 10.0, 9999.0, 10.0, 3);
    private JLabel lblResolutionXY = new JLabel("FWHM", 0);
    private JLabel lblResolutionZ = new JLabel("FWHM", 0);
    private JComboBox cmbType;
    private JComboBox cmbLUT;
    private JComboBox cmbScale = new JComboBox<String>(new String[]{"Linear", "Log", "Sqrt", "Decibel"});
    private JPanel pnPSF;
    private JList[] list = new JList[3];
    private ArrayList<DoubleScrollablePanel> cards = new ArrayList();
    private JTabbedPane tab = new JTabbedPane();
    private Settings settings;
    private ArrayList<PSF> psfs;
    private PSF psf;
    private PoolResponder responder;
    private HashMap<String, JButton> buttons;
    private JPanel pnApplication;

    public MainPanel(Settings settingsExt, HashMap<String, JButton> buttons, ArrayList<PSF> psfs, String[] luts, String[] types, PoolResponder responder) {
        this.settings = settingsExt == null ? new Settings("PSFGenerator", "config.txt") : settingsExt;
        this.psfs = psfs;
        this.buttons = buttons;
        for (PSF psf : psfs) {
            psf.addMonitor(this.progress);
        }
        this.responder = responder;
        this.progress.setString(About.copyright());
        this.lblResolutionXY.setBorder(BorderFactory.createEtchedBorder());
        this.lblResolutionZ.setBorder(BorderFactory.createEtchedBorder());
        if (luts != null) {
            this.cmbLUT = new JComboBox<String>(luts);
        }
        if (types != null) {
            this.cmbType = new JComboBox<String>(types);
        }
        JPanel[] pn = new JPanel[3];
        DefaultListModel[] model = new DefaultListModel[]{new DefaultListModel(), new DefaultListModel(), new DefaultListModel()};
        int i = 0;
        while (i < 5) {
            model[0].addElement(psfs.get(i).getFullname());
            ++i;
        }
        i = 5;
        while (i < 13) {
            model[1].addElement(psfs.get(i).getFullname());
            ++i;
        }
        i = 13;
        while (i < 15) {
            model[2].addElement(psfs.get(i).getFullname());
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.list[i] = new JList(model[i]);
            this.list[i].setVisibleRowCount(4);
            this.list[i].setSelectionMode(0);
            Font font = this.list[i].getFont();
            this.list[i].setFont(new Font(font.getFamily(), 1, font.getSize()));
            this.list[i].setSelectedIndex(0);
            JScrollPane scrollList = new JScrollPane(this.list[i]);
            pn[i] = new JPanel();
            scrollList.setBorder(BorderFactory.createEmptyBorder());
            pn[i].setLayout(new BoxLayout(pn[i], 1));
            pn[i].setBorder(BorderFactory.createEmptyBorder());
            pn[i].add(scrollList);
            ++i;
        }
        this.pnPSF = new JPanel(new CardLayout());
        for (PSF psf : psfs) {
            JPanel panel = psf.buildPanel(this.settings);
            HTMLPane info = new HTMLPane(psf.getDescription());
            DoubleScrollablePanel card = new DoubleScrollablePanel(105, info, 80, panel);
            card.setName(psf.getShortname());
            this.cards.add(card);
            this.pnPSF.add((Component)card, psf.getShortname());
        }
        this.tab.setBorder(BorderFactory.createEmptyBorder());
        this.tab.addTab("Optical Model", pn[0]);
        this.tab.addTab("Lateral/Axial", pn[1]);
        this.tab.addTab("OTF", pn[2]);
        this.tab.addChangeListener(this);
        GridPanel pnOptics = new GridPanel(2);
        pnOptics.place(0, 0, "Wavelength");
        pnOptics.place(0, 1, this.spnLambda);
        pnOptics.place(0, 2, "nm");
        pnOptics.place(0, 3, "  ");
        pnOptics.place(0, 4, "NA");
        pnOptics.place(0, 5, this.spnNA);
        pnOptics.place(2, 0, "Pixelsize XY");
        pnOptics.place(2, 1, this.spnResLateral);
        pnOptics.place(2, 2, "nm");
        pnOptics.place(2, 3, "  ");
        pnOptics.place(2, 4, "Z-step");
        pnOptics.place(2, 5, this.spnResAxial);
        pnOptics.place(2, 6, "nm");
        pnOptics.place(3, 0, "FWHM XY");
        pnOptics.place(3, 1, this.lblResolutionXY);
        pnOptics.place(3, 2, "nm");
        pnOptics.place(3, 3, "  ");
        pnOptics.place(3, 4, "FWHM Z");
        pnOptics.place(3, 5, this.lblResolutionZ);
        pnOptics.place(3, 6, "nm");
        GridPanel pnOut = new GridPanel(2);
        pnOut.place(1, 0, "Size XYZ");
        pnOut.place(1, 1, this.spnNX);
        pnOut.place(1, 2, this.spnNY);
        pnOut.place(1, 3, this.spnNZ);
        pnOut.place(3, 0, new JLabel("Display"));
        pnOut.place(3, 1, this.cmbScale);
        if (this.cmbType != null) {
            pnOut.place(3, 2, this.cmbType);
        }
        if (this.cmbLUT != null) {
            pnOut.place(3, 3, this.cmbLUT);
        }
        JPanel pnButtons = new JPanel(new GridLayout(1, 7));
        if (buttons.get("run") != null) {
            pnButtons.add(buttons.get("run"));
        }
        if (buttons.get("stop") != null) {
            pnButtons.add(buttons.get("stop"));
        }
        if (buttons.get("settings") != null) {
            pnButtons.add(buttons.get("settings"));
        }
        if (buttons.get("save") != null) {
            pnButtons.add(buttons.get("save"));
        }
        if (buttons.get("export") != null) {
            pnButtons.add(buttons.get("export"));
        }
        if (buttons.get("help") != null) {
            pnButtons.add(buttons.get("help"));
        }
        GridPanel pnMain = new GridPanel(false, 6);
        pnMain.place(0, 0, this.tab);
        pnMain.place(1, 0, this.pnPSF);
        pnMain.place(2, 0, pnOptics);
        pnMain.place(4, 0, pnOut);
        pnMain.place(5, 0, pnButtons);
        GridToolbar pnBase = new GridToolbar(false, 0);
        pnBase.setLayout(new BoxLayout(pnBase, 0));
        if (buttons.get("about") != null) {
            pnBase.place(0, 0, buttons.get("about"));
        }
        pnBase.place(0, 1, this.progress);
        if (buttons.get("close") != null) {
            pnBase.place(0, 2, buttons.get("close"));
        }
        this.pnApplication = new JPanel(new CardLayout());
        this.pnApplication.add((Component)pnMain, "Back");
        this.pnApplication.add((Component)About.getPanel(pnMain.getWidth(), pnMain.getHeight()), "About");
        pnBase.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.progress.getBackground()));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.pnApplication);
        this.add(pnBase);
        for (String key : buttons.keySet()) {
            buttons.get(key).addActionListener(this);
        }
        this.spnNA.addChangeListener(this);
        this.spnLambda.addChangeListener(this);
        this.spnResLateral.addChangeListener(this);
        this.spnResAxial.addChangeListener(this);
        this.list[0].addListSelectionListener(this);
        this.list[1].addListSelectionListener(this);
        this.list[2].addListSelectionListener(this);
        this.settings.record("NX", this.spnNX, "256");
        this.settings.record("NY", this.spnNY, "256");
        this.settings.record("NZ", this.spnNZ, "65");
        this.settings.record("ResLateral", this.spnResLateral, "100");
        this.settings.record("ResAxial", this.spnResAxial, "250");
        this.settings.record("NA", this.spnNA, "1.4");
        this.settings.record("Lambda", this.spnLambda, "610");
        if (this.cmbType != null) {
            this.settings.record("Type", this.cmbType, "" + this.cmbType.getItemAt(0));
        }
        if (this.cmbLUT != null) {
            this.settings.record("LUT", this.cmbLUT, "Special PSF");
        }
        this.settings.record("Scale", this.cmbScale, "Linear");
        this.settings.loadRecordedItems();
        this.setSelectedPSF(this.settings.loadValue("PSF-shortname", "BW"));
        this.updateInterface();
        this.setEnabledRun(true);
    }

    public PSF getLastPSF() {
        return this.psf;
    }

    public void success() {
        this.progress.progress(100.0, "End of PSF");
    }

    public void setEnabledRun(boolean enabled) {
        if (this.buttons.get("run") != null) {
            this.buttons.get("run").setEnabled(enabled);
        }
        if (this.buttons.get("stop") != null) {
            this.buttons.get("stop").setEnabled(!enabled);
        }
    }

    public void onClosed() {
        this.list[0].removeListSelectionListener(this);
        this.list[1].removeListSelectionListener(this);
        this.list[2].removeListSelectionListener(this);
        for (String key : this.buttons.keySet()) {
            this.buttons.get(key).removeActionListener(this);
        }
    }

    public int getSelectedType() {
        return this.cmbType == null ? 0 : this.cmbType.getSelectedIndex();
    }

    public int getSelectedLUT() {
        return this.cmbLUT == null ? 0 : this.cmbLUT.getSelectedIndex();
    }

    public int getSelectedPSF() {
        int itab = this.tab.getSelectedIndex();
        int selection = this.list[itab].getSelectedIndex();
        return itab == 0 ? selection : (itab == 1 ? selection + 5 : selection + 13);
    }

    public String getSelectedPSFShortname() {
        return this.psfs.get(this.getSelectedPSF()).getShortname();
    }

    public void setSelectedPSF(String shortname) {
        int index = 0;
        int i = 0;
        while (i < this.psfs.size()) {
            if (this.psfs.get(i).getShortname().equals(shortname)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 5) {
            this.tab.setSelectedIndex(0);
            this.list[0].setSelectedIndex(index);
        } else if (index < 14) {
            this.tab.setSelectedIndex(1);
            this.list[1].setSelectedIndex(index - 5);
        } else {
            this.tab.setSelectedIndex(2);
            this.list[2].setSelectedIndex(index - 13);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        CardLayout cl = (CardLayout)this.pnPSF.getLayout();
        cl.show(this.pnPSF, this.cards.get(this.getSelectedPSF()).getName());
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        JButton bn = (JButton)e.getSource();
        if (bn == this.buttons.get("stop")) {
            if (this.psf != null) {
                this.psf.abort();
                this.progress.print(this.psf.getShortname() + " stopped");
            }
        } else if (bn == this.buttons.get("about")) {
            CardLayout cl = (CardLayout)this.pnApplication.getLayout();
            cl.show(this.pnApplication, bn.getText());
            if (bn.getText().equals("About")) {
                bn.setText("Back");
                bn.setToolTipText("Back to " + About.title());
            } else {
                bn.setText("About");
                bn.setToolTipText("Back to the application");
            }
        } else if (bn == this.buttons.get("help")) {
            WebBrowser.open(About.url());
        } else if (bn == this.buttons.get("settings")) {
            new SettingsFileDialog(this.settings);
        } else if (bn == this.buttons.get("run")) {
            this.compute(ExecutionMode.MULTITHREAD_ASYNCHRONIZED);
        }
    }

    public void compute(ExecutionMode mode) {
        int index = this.getSelectedPSF();
        if (index < 0) {
            return;
        }
        int nx = this.spnNX.get();
        int ny = this.spnNY.get();
        int nz = this.spnNZ.get();
        int type = this.cmbType == null ? 0 : this.cmbType.getSelectedIndex();
        int scale = this.cmbScale == null ? 0 : this.cmbScale.getSelectedIndex();
        this.setEnabledRun(false);
        this.psf = this.psfs.get(index);
        this.psf.setOpticsParameters(this.spnNA.get(), this.spnLambda.get());
        this.psf.setResolutionParameters(this.spnResLateral.get(), this.spnResAxial.get());
        this.psf.setOutputParameters(nx, ny, nz, type, scale);
        Pool pool = new Pool("Main", this.responder);
        pool.register(this.psf);
        pool.execute(mode);
    }

    public void finish() {
        this.progress.progress(100.0, "End of " + this.psf.getShortname());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.tab) {
            CardLayout cl = (CardLayout)this.pnPSF.getLayout();
            cl.show(this.pnPSF, this.cards.get(this.getSelectedPSF()).getName());
        }
        this.updateInterface();
    }

    private void updateInterface() {
        double z = 2.0 * this.spnLambda.get() / (this.spnNA.get() * this.spnNA.get());
        String znm = new DecimalFormat("###.#").format(z);
        double xy = 0.61 * this.spnLambda.get() / this.spnNA.get();
        String snm = new DecimalFormat("###.#").format(xy);
        this.lblResolutionXY.setText(snm);
        this.lblResolutionZ.setText(znm);
    }
}

